<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.AddDirectDebitPaymentToBasketRequest StructType
 * @subpackage Structs
 */
class Payment_AddDirectDebitPaymentToBasketRequest extends Payment_AddPaymentToBasketRequestBase
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The Authorized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Authorized;
    /**
     * The BankAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankAddress;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BIC;
    /**
     * The CollectPaymentOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectPaymentOnDate;
    /**
     * The CollectPaymentOnDay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CollectPaymentOnDay;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The MandateExpirationInDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateExpirationInDays;
    /**
     * The MandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateId;
    /**
     * The MandateOnlyForThisTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MandateOnlyForThisTransaction;
    /**
     * The MandateTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MandateTypeId;
    /**
     * Constructor method for Payment.AddDirectDebitPaymentToBasketRequest
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setAccountName()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setAccountNumber()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setAuthorized()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setBankAddress()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setBankCode()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setBankName()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setBIC()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setCollectPaymentOnDate()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setCollectPaymentOnDay()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setIBAN()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setMandateExpirationInDays()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setMandateId()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setMandateOnlyForThisTransaction()
     * @uses Payment_AddDirectDebitPaymentToBasketRequest::setMandateTypeId()
     * @param string $accountName
     * @param string $accountNumber
     * @param bool $authorized
     * @param string $bankAddress
     * @param string $bankCode
     * @param string $bankName
     * @param string $bIC
     * @param string $collectPaymentOnDate
     * @param int $collectPaymentOnDay
     * @param string $iBAN
     * @param int $mandateExpirationInDays
     * @param string $mandateId
     * @param bool $mandateOnlyForThisTransaction
     * @param string $mandateTypeId
     */
    public function __construct($accountName = null, $accountNumber = null, $authorized = null, $bankAddress = null, $bankCode = null, $bankName = null, $bIC = null, $collectPaymentOnDate = null, $collectPaymentOnDay = null, $iBAN = null, $mandateExpirationInDays = null, $mandateId = null, $mandateOnlyForThisTransaction = null, $mandateTypeId = null)
    {
        $this
            ->setAccountName($accountName)
            ->setAccountNumber($accountNumber)
            ->setAuthorized($authorized)
            ->setBankAddress($bankAddress)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setBIC($bIC)
            ->setCollectPaymentOnDate($collectPaymentOnDate)
            ->setCollectPaymentOnDay($collectPaymentOnDay)
            ->setIBAN($iBAN)
            ->setMandateExpirationInDays($mandateExpirationInDays)
            ->setMandateId($mandateId)
            ->setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction)
            ->setMandateTypeId($mandateTypeId);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get Authorized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAuthorized()
    {
        return isset($this->Authorized) ? $this->Authorized : null;
    }
    /**
     * Set Authorized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $authorized
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setAuthorized($authorized = null)
    {
        // validation for constraint: boolean
        if (!is_null($authorized) && !is_bool($authorized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($authorized, true), gettype($authorized)), __LINE__);
        }
        if (is_null($authorized) || (is_array($authorized) && empty($authorized))) {
            unset($this->Authorized);
        } else {
            $this->Authorized = $authorized;
        }
        return $this;
    }
    /**
     * Get BankAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankAddress()
    {
        return isset($this->BankAddress) ? $this->BankAddress : null;
    }
    /**
     * Set BankAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankAddress
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setBankAddress($bankAddress = null)
    {
        // validation for constraint: string
        if (!is_null($bankAddress) && !is_string($bankAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankAddress, true), gettype($bankAddress)), __LINE__);
        }
        if (is_null($bankAddress) || (is_array($bankAddress) && empty($bankAddress))) {
            unset($this->BankAddress);
        } else {
            $this->BankAddress = $bankAddress;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get BIC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBIC()
    {
        return isset($this->BIC) ? $this->BIC : null;
    }
    /**
     * Set BIC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bIC
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        if (is_null($bIC) || (is_array($bIC) && empty($bIC))) {
            unset($this->BIC);
        } else {
            $this->BIC = $bIC;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectPaymentOnDate()
    {
        return isset($this->CollectPaymentOnDate) ? $this->CollectPaymentOnDate : null;
    }
    /**
     * Set CollectPaymentOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectPaymentOnDate
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setCollectPaymentOnDate($collectPaymentOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($collectPaymentOnDate) && !is_string($collectPaymentOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectPaymentOnDate, true), gettype($collectPaymentOnDate)), __LINE__);
        }
        if (is_null($collectPaymentOnDate) || (is_array($collectPaymentOnDate) && empty($collectPaymentOnDate))) {
            unset($this->CollectPaymentOnDate);
        } else {
            $this->CollectPaymentOnDate = $collectPaymentOnDate;
        }
        return $this;
    }
    /**
     * Get CollectPaymentOnDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCollectPaymentOnDay()
    {
        return isset($this->CollectPaymentOnDay) ? $this->CollectPaymentOnDay : null;
    }
    /**
     * Set CollectPaymentOnDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $collectPaymentOnDay
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setCollectPaymentOnDay($collectPaymentOnDay = null)
    {
        // validation for constraint: int
        if (!is_null($collectPaymentOnDay) && !(is_int($collectPaymentOnDay) || ctype_digit($collectPaymentOnDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($collectPaymentOnDay, true), gettype($collectPaymentOnDay)), __LINE__);
        }
        if (is_null($collectPaymentOnDay) || (is_array($collectPaymentOnDay) && empty($collectPaymentOnDay))) {
            unset($this->CollectPaymentOnDay);
        } else {
            $this->CollectPaymentOnDay = $collectPaymentOnDay;
        }
        return $this;
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get MandateExpirationInDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateExpirationInDays()
    {
        return isset($this->MandateExpirationInDays) ? $this->MandateExpirationInDays : null;
    }
    /**
     * Set MandateExpirationInDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateExpirationInDays
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setMandateExpirationInDays($mandateExpirationInDays = null)
    {
        // validation for constraint: int
        if (!is_null($mandateExpirationInDays) && !(is_int($mandateExpirationInDays) || ctype_digit($mandateExpirationInDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateExpirationInDays, true), gettype($mandateExpirationInDays)), __LINE__);
        }
        if (is_null($mandateExpirationInDays) || (is_array($mandateExpirationInDays) && empty($mandateExpirationInDays))) {
            unset($this->MandateExpirationInDays);
        } else {
            $this->MandateExpirationInDays = $mandateExpirationInDays;
        }
        return $this;
    }
    /**
     * Get MandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateId()
    {
        return isset($this->MandateId) ? $this->MandateId : null;
    }
    /**
     * Set MandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateId
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setMandateId($mandateId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateId) && !is_string($mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateId, true), gettype($mandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateId, true)), __LINE__);
        }
        if (is_null($mandateId) || (is_array($mandateId) && empty($mandateId))) {
            unset($this->MandateId);
        } else {
            $this->MandateId = $mandateId;
        }
        return $this;
    }
    /**
     * Get MandateOnlyForThisTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMandateOnlyForThisTransaction()
    {
        return isset($this->MandateOnlyForThisTransaction) ? $this->MandateOnlyForThisTransaction : null;
    }
    /**
     * Set MandateOnlyForThisTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mandateOnlyForThisTransaction
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setMandateOnlyForThisTransaction($mandateOnlyForThisTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateOnlyForThisTransaction) && !is_bool($mandateOnlyForThisTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateOnlyForThisTransaction, true), gettype($mandateOnlyForThisTransaction)), __LINE__);
        }
        if (is_null($mandateOnlyForThisTransaction) || (is_array($mandateOnlyForThisTransaction) && empty($mandateOnlyForThisTransaction))) {
            unset($this->MandateOnlyForThisTransaction);
        } else {
            $this->MandateOnlyForThisTransaction = $mandateOnlyForThisTransaction;
        }
        return $this;
    }
    /**
     * Get MandateTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateTypeId()
    {
        return isset($this->MandateTypeId) ? $this->MandateTypeId : null;
    }
    /**
     * Set MandateTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateTypeId
     * @return \patest\StructType\Payment_AddDirectDebitPaymentToBasketRequest
     */
    public function setMandateTypeId($mandateTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($mandateTypeId) && !is_string($mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateTypeId, true), gettype($mandateTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($mandateTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $mandateTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($mandateTypeId, true)), __LINE__);
        }
        if (is_null($mandateTypeId) || (is_array($mandateTypeId) && empty($mandateTypeId))) {
            unset($this->MandateTypeId);
        } else {
            $this->MandateTypeId = $mandateTypeId;
        }
        return $this;
    }
}
