<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentPlanPaymentItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaymentPlanPaymentItem
 * @subpackage Structs
 */
class PaymentPlanPaymentItem extends SettlementPaymentItem
{
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInstallmentItem
     */
    public $InstallmentItems;
    /**
     * The InstallmentPaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentPaymentDetails;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentPaymentProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentProviderSpecificTokenId;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The InstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentsScheduleId;
    /**
     * The IsExistingSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExistingSchedule;
    /**
     * The ExistingSchedulePaymentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExistingSchedulePaymentId;
    /**
     * Constructor method for PaymentPlanPaymentItem
     * @uses PaymentPlanPaymentItem::setDateOfFirstInstallment()
     * @uses PaymentPlanPaymentItem::setInstallmentItems()
     * @uses PaymentPlanPaymentItem::setInstallmentPaymentDetails()
     * @uses PaymentPlanPaymentItem::setInstallmentPaymentMethodId()
     * @uses PaymentPlanPaymentItem::setInstallmentPaymentProviderSpecificTokenId()
     * @uses PaymentPlanPaymentItem::setInstallmentSchedule()
     * @uses PaymentPlanPaymentItem::setNumberOfInstallments()
     * @uses PaymentPlanPaymentItem::setInstallmentsScheduleId()
     * @uses PaymentPlanPaymentItem::setIsExistingSchedule()
     * @uses PaymentPlanPaymentItem::setExistingSchedulePaymentId()
     * @param string $dateOfFirstInstallment
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @param string $installmentPaymentDetails
     * @param string $installmentPaymentMethodId
     * @param string $installmentPaymentProviderSpecificTokenId
     * @param string $installmentSchedule
     * @param int $numberOfInstallments
     * @param string $installmentsScheduleId
     * @param bool $isExistingSchedule
     * @param string $existingSchedulePaymentId
     */
    public function __construct($dateOfFirstInstallment = null, \patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null, $installmentPaymentDetails = null, $installmentPaymentMethodId = null, $installmentPaymentProviderSpecificTokenId = null, $installmentSchedule = null, $numberOfInstallments = null, $installmentsScheduleId = null, $isExistingSchedule = null, $existingSchedulePaymentId = null)
    {
        $this
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setInstallmentItems($installmentItems)
            ->setInstallmentPaymentDetails($installmentPaymentDetails)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentPaymentProviderSpecificTokenId($installmentPaymentProviderSpecificTokenId)
            ->setInstallmentSchedule($installmentSchedule)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setInstallmentsScheduleId($installmentsScheduleId)
            ->setIsExistingSchedule($isExistingSchedule)
            ->setExistingSchedulePaymentId($existingSchedulePaymentId);
    }
    /**
     * Get DateOfFirstInstallment value
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return $this->DateOfFirstInstallment;
    }
    /**
     * Set DateOfFirstInstallment value
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        return $this;
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInstallmentItem|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInstallmentItem $installmentItems
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentItems(\patest\ArrayType\ArrayOfInstallmentItem $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentDetails()
    {
        return isset($this->InstallmentPaymentDetails) ? $this->InstallmentPaymentDetails : null;
    }
    /**
     * Set InstallmentPaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentDetails
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentPaymentDetails($installmentPaymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentDetails) && !is_string($installmentPaymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentDetails, true), gettype($installmentPaymentDetails)), __LINE__);
        }
        if (is_null($installmentPaymentDetails) || (is_array($installmentPaymentDetails) && empty($installmentPaymentDetails))) {
            unset($this->InstallmentPaymentDetails);
        } else {
            $this->InstallmentPaymentDetails = $installmentPaymentDetails;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return $this->InstallmentPaymentMethodId;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        return $this;
    }
    /**
     * Get InstallmentPaymentProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentProviderSpecificTokenId()
    {
        return isset($this->InstallmentPaymentProviderSpecificTokenId) ? $this->InstallmentPaymentProviderSpecificTokenId : null;
    }
    /**
     * Set InstallmentPaymentProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentProviderSpecificTokenId
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentPaymentProviderSpecificTokenId($installmentPaymentProviderSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentProviderSpecificTokenId) && !is_string($installmentPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentProviderSpecificTokenId, true), gettype($installmentPaymentProviderSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentProviderSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentProviderSpecificTokenId, true)), __LINE__);
        }
        if (is_null($installmentPaymentProviderSpecificTokenId) || (is_array($installmentPaymentProviderSpecificTokenId) && empty($installmentPaymentProviderSpecificTokenId))) {
            unset($this->InstallmentPaymentProviderSpecificTokenId);
        } else {
            $this->InstallmentPaymentProviderSpecificTokenId = $installmentPaymentProviderSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return $this->InstallmentSchedule;
    }
    /**
     * Set InstallmentSchedule value
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentSchedule
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentSchedule) ? implode(', ', $installmentSchedule) : var_export($installmentSchedule, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        $this->InstallmentSchedule = $installmentSchedule;
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return $this->NumberOfInstallments;
    }
    /**
     * Set NumberOfInstallments value
     * @param int $numberOfInstallments
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        $this->NumberOfInstallments = $numberOfInstallments;
        return $this;
    }
    /**
     * Get InstallmentsScheduleId value
     * @return string|null
     */
    public function getInstallmentsScheduleId()
    {
        return $this->InstallmentsScheduleId;
    }
    /**
     * Set InstallmentsScheduleId value
     * @param string $installmentsScheduleId
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setInstallmentsScheduleId($installmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentsScheduleId) && !is_string($installmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentsScheduleId, true), gettype($installmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentsScheduleId, true)), __LINE__);
        }
        $this->InstallmentsScheduleId = $installmentsScheduleId;
        return $this;
    }
    /**
     * Get IsExistingSchedule value
     * @return bool|null
     */
    public function getIsExistingSchedule()
    {
        return $this->IsExistingSchedule;
    }
    /**
     * Set IsExistingSchedule value
     * @param bool $isExistingSchedule
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setIsExistingSchedule($isExistingSchedule = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExistingSchedule) && !is_bool($isExistingSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExistingSchedule, true), gettype($isExistingSchedule)), __LINE__);
        }
        $this->IsExistingSchedule = $isExistingSchedule;
        return $this;
    }
    /**
     * Get ExistingSchedulePaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExistingSchedulePaymentId()
    {
        return isset($this->ExistingSchedulePaymentId) ? $this->ExistingSchedulePaymentId : null;
    }
    /**
     * Set ExistingSchedulePaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $existingSchedulePaymentId
     * @return \patest\StructType\PaymentPlanPaymentItem
     */
    public function setExistingSchedulePaymentId($existingSchedulePaymentId = null)
    {
        // validation for constraint: string
        if (!is_null($existingSchedulePaymentId) && !is_string($existingSchedulePaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existingSchedulePaymentId, true), gettype($existingSchedulePaymentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($existingSchedulePaymentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $existingSchedulePaymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($existingSchedulePaymentId, true)), __LINE__);
        }
        if (is_null($existingSchedulePaymentId) || (is_array($existingSchedulePaymentId) && empty($existingSchedulePaymentId))) {
            unset($this->ExistingSchedulePaymentId);
        } else {
            $this->ExistingSchedulePaymentId = $existingSchedulePaymentId;
        }
        return $this;
    }
}
