<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PauseTraceRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PauseTraceRequest
 * @subpackage Structs
 */
class PauseTraceRequest extends AbstractStructBase
{
    /**
     * The ShouldDumpCurrentWorkItemsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldDumpCurrentWorkItemsInfo;
    /**
     * The ShouldEnsureAllPendingTracesPublished
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldEnsureAllPendingTracesPublished;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * Constructor method for PauseTraceRequest
     * @uses PauseTraceRequest::setShouldDumpCurrentWorkItemsInfo()
     * @uses PauseTraceRequest::setShouldEnsureAllPendingTracesPublished()
     * @uses PauseTraceRequest::setSubscriptionId()
     * @param bool $shouldDumpCurrentWorkItemsInfo
     * @param bool $shouldEnsureAllPendingTracesPublished
     * @param string $subscriptionId
     */
    public function __construct($shouldDumpCurrentWorkItemsInfo = null, $shouldEnsureAllPendingTracesPublished = null, $subscriptionId = null)
    {
        $this
            ->setShouldDumpCurrentWorkItemsInfo($shouldDumpCurrentWorkItemsInfo)
            ->setShouldEnsureAllPendingTracesPublished($shouldEnsureAllPendingTracesPublished)
            ->setSubscriptionId($subscriptionId);
    }
    /**
     * Get ShouldDumpCurrentWorkItemsInfo value
     * @return bool|null
     */
    public function getShouldDumpCurrentWorkItemsInfo()
    {
        return $this->ShouldDumpCurrentWorkItemsInfo;
    }
    /**
     * Set ShouldDumpCurrentWorkItemsInfo value
     * @param bool $shouldDumpCurrentWorkItemsInfo
     * @return \patest\StructType\PauseTraceRequest
     */
    public function setShouldDumpCurrentWorkItemsInfo($shouldDumpCurrentWorkItemsInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldDumpCurrentWorkItemsInfo) && !is_bool($shouldDumpCurrentWorkItemsInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldDumpCurrentWorkItemsInfo, true), gettype($shouldDumpCurrentWorkItemsInfo)), __LINE__);
        }
        $this->ShouldDumpCurrentWorkItemsInfo = $shouldDumpCurrentWorkItemsInfo;
        return $this;
    }
    /**
     * Get ShouldEnsureAllPendingTracesPublished value
     * @return bool|null
     */
    public function getShouldEnsureAllPendingTracesPublished()
    {
        return $this->ShouldEnsureAllPendingTracesPublished;
    }
    /**
     * Set ShouldEnsureAllPendingTracesPublished value
     * @param bool $shouldEnsureAllPendingTracesPublished
     * @return \patest\StructType\PauseTraceRequest
     */
    public function setShouldEnsureAllPendingTracesPublished($shouldEnsureAllPendingTracesPublished = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldEnsureAllPendingTracesPublished) && !is_bool($shouldEnsureAllPendingTracesPublished)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldEnsureAllPendingTracesPublished, true), gettype($shouldEnsureAllPendingTracesPublished)), __LINE__);
        }
        $this->ShouldEnsureAllPendingTracesPublished = $shouldEnsureAllPendingTracesPublished;
        return $this;
    }
    /**
     * Get SubscriptionId value
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return $this->SubscriptionId;
    }
    /**
     * Set SubscriptionId value
     * @param string $subscriptionId
     * @return \patest\StructType\PauseTraceRequest
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        $this->SubscriptionId = $subscriptionId;
        return $this;
    }
}
