<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PartyClaim-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PartyClaim-Request
 * @subpackage Structs
 */
class PartyClaim_Request extends ExtensibleDataContract
{
    /**
     * The ClaimTickets
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPartyTicketAssignment
     */
    public $ClaimTickets;
    /**
     * The ActingClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ActingClientId;
    /**
     * The PartyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PartyId;
    /**
     * The PartyLinkGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartyLinkGuid;
    /**
     * The CurrentPartyState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfPartyTicketAssignment
     */
    public $CurrentPartyState;
    /**
     * The IsAdminAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAdminAction;
    /**
     * Constructor method for PartyClaim-Request
     * @uses PartyClaim_Request::setClaimTickets()
     * @uses PartyClaim_Request::setActingClientId()
     * @uses PartyClaim_Request::setPartyId()
     * @uses PartyClaim_Request::setPartyLinkGuid()
     * @uses PartyClaim_Request::setCurrentPartyState()
     * @uses PartyClaim_Request::setIsAdminAction()
     * @param \patest\ArrayType\ArrayOfPartyTicketAssignment $claimTickets
     * @param string $actingClientId
     * @param int $partyId
     * @param string $partyLinkGuid
     * @param \patest\ArrayType\ArrayOfPartyTicketAssignment $currentPartyState
     * @param bool $isAdminAction
     */
    public function __construct(\patest\ArrayType\ArrayOfPartyTicketAssignment $claimTickets = null, $actingClientId = null, $partyId = null, $partyLinkGuid = null, \patest\ArrayType\ArrayOfPartyTicketAssignment $currentPartyState = null, $isAdminAction = null)
    {
        $this
            ->setClaimTickets($claimTickets)
            ->setActingClientId($actingClientId)
            ->setPartyId($partyId)
            ->setPartyLinkGuid($partyLinkGuid)
            ->setCurrentPartyState($currentPartyState)
            ->setIsAdminAction($isAdminAction);
    }
    /**
     * Get ClaimTickets value
     * @return \patest\ArrayType\ArrayOfPartyTicketAssignment|null
     */
    public function getClaimTickets()
    {
        return $this->ClaimTickets;
    }
    /**
     * Set ClaimTickets value
     * @param \patest\ArrayType\ArrayOfPartyTicketAssignment $claimTickets
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setClaimTickets(\patest\ArrayType\ArrayOfPartyTicketAssignment $claimTickets = null)
    {
        $this->ClaimTickets = $claimTickets;
        return $this;
    }
    /**
     * Get ActingClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActingClientId()
    {
        return isset($this->ActingClientId) ? $this->ActingClientId : null;
    }
    /**
     * Set ActingClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actingClientId
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setActingClientId($actingClientId = null)
    {
        // validation for constraint: string
        if (!is_null($actingClientId) && !is_string($actingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actingClientId, true), gettype($actingClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($actingClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $actingClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($actingClientId, true)), __LINE__);
        }
        if (is_null($actingClientId) || (is_array($actingClientId) && empty($actingClientId))) {
            unset($this->ActingClientId);
        } else {
            $this->ActingClientId = $actingClientId;
        }
        return $this;
    }
    /**
     * Get PartyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPartyId()
    {
        return isset($this->PartyId) ? $this->PartyId : null;
    }
    /**
     * Set PartyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $partyId
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setPartyId($partyId = null)
    {
        // validation for constraint: int
        if (!is_null($partyId) && !(is_int($partyId) || ctype_digit($partyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($partyId, true), gettype($partyId)), __LINE__);
        }
        if (is_null($partyId) || (is_array($partyId) && empty($partyId))) {
            unset($this->PartyId);
        } else {
            $this->PartyId = $partyId;
        }
        return $this;
    }
    /**
     * Get PartyLinkGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyLinkGuid()
    {
        return isset($this->PartyLinkGuid) ? $this->PartyLinkGuid : null;
    }
    /**
     * Set PartyLinkGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyLinkGuid
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setPartyLinkGuid($partyLinkGuid = null)
    {
        // validation for constraint: string
        if (!is_null($partyLinkGuid) && !is_string($partyLinkGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyLinkGuid, true), gettype($partyLinkGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partyLinkGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partyLinkGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partyLinkGuid, true)), __LINE__);
        }
        if (is_null($partyLinkGuid) || (is_array($partyLinkGuid) && empty($partyLinkGuid))) {
            unset($this->PartyLinkGuid);
        } else {
            $this->PartyLinkGuid = $partyLinkGuid;
        }
        return $this;
    }
    /**
     * Get CurrentPartyState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfPartyTicketAssignment|null
     */
    public function getCurrentPartyState()
    {
        return isset($this->CurrentPartyState) ? $this->CurrentPartyState : null;
    }
    /**
     * Set CurrentPartyState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfPartyTicketAssignment $currentPartyState
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setCurrentPartyState(\patest\ArrayType\ArrayOfPartyTicketAssignment $currentPartyState = null)
    {
        if (is_null($currentPartyState) || (is_array($currentPartyState) && empty($currentPartyState))) {
            unset($this->CurrentPartyState);
        } else {
            $this->CurrentPartyState = $currentPartyState;
        }
        return $this;
    }
    /**
     * Get IsAdminAction value
     * @return bool|null
     */
    public function getIsAdminAction()
    {
        return $this->IsAdminAction;
    }
    /**
     * Set IsAdminAction value
     * @param bool $isAdminAction
     * @return \patest\StructType\PartyClaim_Request
     */
    public function setIsAdminAction($isAdminAction = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAdminAction) && !is_bool($isAdminAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAdminAction, true), gettype($isAdminAction)), __LINE__);
        }
        $this->IsAdminAction = $isAdminAction;
        return $this;
    }
}
