<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveSubscriptionReservedSeatSelectionResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveSubscriptionReservedSeatSelectionResponse
 * @subpackage Structs
 */
class MoveSubscriptionReservedSeatSelectionResponse extends ExtensibleDataContract
{
    /**
     * The SeatUnavailableAtEventsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatUnavailableAtEventsCount;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for MoveSubscriptionReservedSeatSelectionResponse
     * @uses MoveSubscriptionReservedSeatSelectionResponse::setSeatUnavailableAtEventsCount()
     * @uses MoveSubscriptionReservedSeatSelectionResponse::setTransactionSnapshot()
     * @param int $seatUnavailableAtEventsCount
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct($seatUnavailableAtEventsCount = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setSeatUnavailableAtEventsCount($seatUnavailableAtEventsCount)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get SeatUnavailableAtEventsCount value
     * @return int|null
     */
    public function getSeatUnavailableAtEventsCount()
    {
        return $this->SeatUnavailableAtEventsCount;
    }
    /**
     * Set SeatUnavailableAtEventsCount value
     * @param int $seatUnavailableAtEventsCount
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionResponse
     */
    public function setSeatUnavailableAtEventsCount($seatUnavailableAtEventsCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatUnavailableAtEventsCount) && !(is_int($seatUnavailableAtEventsCount) || ctype_digit($seatUnavailableAtEventsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatUnavailableAtEventsCount, true), gettype($seatUnavailableAtEventsCount)), __LINE__);
        }
        $this->SeatUnavailableAtEventsCount = $seatUnavailableAtEventsCount;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\MoveSubscriptionReservedSeatSelectionResponse
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
