<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoveReservedSeatSelection-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MoveReservedSeatSelection-Request
 * @subpackage Structs
 */
class MoveReservedSeatSelection_Request extends ExtensibleDataContract
{
    /**
     * The Direction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Direction;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Distance;
    /**
     * The ItemIdsToMove
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemIdsToMove;
    /**
     * The StartingDestinationSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartingDestinationSeatId;
    /**
     * The TargetAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetAreaId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The RelatedToSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedToSeriesId;
    /**
     * The SeatsIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfNullableOfint
     */
    public $SeatsIdInAreaMap;
    /**
     * Constructor method for MoveReservedSeatSelection-Request
     * @uses MoveReservedSeatSelection_Request::setDirection()
     * @uses MoveReservedSeatSelection_Request::setDistance()
     * @uses MoveReservedSeatSelection_Request::setItemIdsToMove()
     * @uses MoveReservedSeatSelection_Request::setStartingDestinationSeatId()
     * @uses MoveReservedSeatSelection_Request::setTargetAreaId()
     * @uses MoveReservedSeatSelection_Request::setTransactionGuid()
     * @uses MoveReservedSeatSelection_Request::setTransactionSnapshotType()
     * @uses MoveReservedSeatSelection_Request::setRelatedToSeriesId()
     * @uses MoveReservedSeatSelection_Request::setSeatsIdInAreaMap()
     * @param string $direction
     * @param int $distance
     * @param \patest\ArrayType\ArrayOfint $itemIdsToMove
     * @param int $startingDestinationSeatId
     * @param string $targetAreaId
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param string $relatedToSeriesId
     * @param \patest\ArrayType\ArrayOfNullableOfint $seatsIdInAreaMap
     */
    public function __construct($direction = null, $distance = null, \patest\ArrayType\ArrayOfint $itemIdsToMove = null, $startingDestinationSeatId = null, $targetAreaId = null, $transactionGuid = null, $transactionSnapshotType = null, $relatedToSeriesId = null, \patest\ArrayType\ArrayOfNullableOfint $seatsIdInAreaMap = null)
    {
        $this
            ->setDirection($direction)
            ->setDistance($distance)
            ->setItemIdsToMove($itemIdsToMove)
            ->setStartingDestinationSeatId($startingDestinationSeatId)
            ->setTargetAreaId($targetAreaId)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setRelatedToSeriesId($relatedToSeriesId)
            ->setSeatsIdInAreaMap($seatsIdInAreaMap);
    }
    /**
     * Get Direction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirection()
    {
        return isset($this->Direction) ? $this->Direction : null;
    }
    /**
     * Set Direction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MoveDirection::valueIsValid()
     * @uses \patest\EnumType\MoveDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $direction
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setDirection($direction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MoveDirection::valueIsValid($direction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MoveDirection', is_array($direction) ? implode(', ', $direction) : var_export($direction, true), implode(', ', \patest\EnumType\MoveDirection::getValidValues())), __LINE__);
        }
        if (is_null($direction) || (is_array($direction) && empty($direction))) {
            unset($this->Direction);
        } else {
            $this->Direction = $direction;
        }
        return $this;
    }
    /**
     * Get Distance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDistance()
    {
        return isset($this->Distance) ? $this->Distance : null;
    }
    /**
     * Set Distance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $distance
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setDistance($distance = null)
    {
        // validation for constraint: int
        if (!is_null($distance) && !(is_int($distance) || ctype_digit($distance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($distance, true), gettype($distance)), __LINE__);
        }
        if (is_null($distance) || (is_array($distance) && empty($distance))) {
            unset($this->Distance);
        } else {
            $this->Distance = $distance;
        }
        return $this;
    }
    /**
     * Get ItemIdsToMove value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemIdsToMove()
    {
        return isset($this->ItemIdsToMove) ? $this->ItemIdsToMove : null;
    }
    /**
     * Set ItemIdsToMove value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemIdsToMove
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setItemIdsToMove(\patest\ArrayType\ArrayOfint $itemIdsToMove = null)
    {
        if (is_null($itemIdsToMove) || (is_array($itemIdsToMove) && empty($itemIdsToMove))) {
            unset($this->ItemIdsToMove);
        } else {
            $this->ItemIdsToMove = $itemIdsToMove;
        }
        return $this;
    }
    /**
     * Get StartingDestinationSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartingDestinationSeatId()
    {
        return isset($this->StartingDestinationSeatId) ? $this->StartingDestinationSeatId : null;
    }
    /**
     * Set StartingDestinationSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startingDestinationSeatId
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setStartingDestinationSeatId($startingDestinationSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($startingDestinationSeatId) && !(is_int($startingDestinationSeatId) || ctype_digit($startingDestinationSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingDestinationSeatId, true), gettype($startingDestinationSeatId)), __LINE__);
        }
        if (is_null($startingDestinationSeatId) || (is_array($startingDestinationSeatId) && empty($startingDestinationSeatId))) {
            unset($this->StartingDestinationSeatId);
        } else {
            $this->StartingDestinationSeatId = $startingDestinationSeatId;
        }
        return $this;
    }
    /**
     * Get TargetAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetAreaId()
    {
        return isset($this->TargetAreaId) ? $this->TargetAreaId : null;
    }
    /**
     * Set TargetAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetAreaId
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setTargetAreaId($targetAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($targetAreaId) && !is_string($targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetAreaId, true), gettype($targetAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetAreaId, true)), __LINE__);
        }
        if (is_null($targetAreaId) || (is_array($targetAreaId) && empty($targetAreaId))) {
            unset($this->TargetAreaId);
        } else {
            $this->TargetAreaId = $targetAreaId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get RelatedToSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedToSeriesId()
    {
        return isset($this->RelatedToSeriesId) ? $this->RelatedToSeriesId : null;
    }
    /**
     * Set RelatedToSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedToSeriesId
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setRelatedToSeriesId($relatedToSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedToSeriesId) && !is_string($relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedToSeriesId, true), gettype($relatedToSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedToSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedToSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedToSeriesId, true)), __LINE__);
        }
        if (is_null($relatedToSeriesId) || (is_array($relatedToSeriesId) && empty($relatedToSeriesId))) {
            unset($this->RelatedToSeriesId);
        } else {
            $this->RelatedToSeriesId = $relatedToSeriesId;
        }
        return $this;
    }
    /**
     * Get SeatsIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfNullableOfint|null
     */
    public function getSeatsIdInAreaMap()
    {
        return isset($this->SeatsIdInAreaMap) ? $this->SeatsIdInAreaMap : null;
    }
    /**
     * Set SeatsIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfNullableOfint $seatsIdInAreaMap
     * @return \patest\StructType\MoveReservedSeatSelection_Request
     */
    public function setSeatsIdInAreaMap(\patest\ArrayType\ArrayOfNullableOfint $seatsIdInAreaMap = null)
    {
        if (is_null($seatsIdInAreaMap) || (is_array($seatsIdInAreaMap) && empty($seatsIdInAreaMap))) {
            unset($this->SeatsIdInAreaMap);
        } else {
            $this->SeatsIdInAreaMap = $seatsIdInAreaMap;
        }
        return $this;
    }
}
