<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.UIAddOnsItemInformation StructType
 * @subpackage Structs
 */
class Merchandise_UIAddOnsItemInformation extends AnyEntity
{
    /**
     * The AddOnTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddOnTypeId;
    /**
     * The AddOnTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddOnTypeName;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The YourSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $YourSelection;
    /**
     * Constructor method for Merchandise.UIAddOnsItemInformation
     * @uses Merchandise_UIAddOnsItemInformation::setAddOnTypeId()
     * @uses Merchandise_UIAddOnsItemInformation::setAddOnTypeName()
     * @uses Merchandise_UIAddOnsItemInformation::setPrice()
     * @uses Merchandise_UIAddOnsItemInformation::setYourSelection()
     * @param string $addOnTypeId
     * @param string $addOnTypeName
     * @param \patest\StructType\Money $price
     * @param string $yourSelection
     */
    public function __construct($addOnTypeId = null, $addOnTypeName = null, \patest\StructType\Money $price = null, $yourSelection = null)
    {
        $this
            ->setAddOnTypeId($addOnTypeId)
            ->setAddOnTypeName($addOnTypeName)
            ->setPrice($price)
            ->setYourSelection($yourSelection);
    }
    /**
     * Get AddOnTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnTypeId()
    {
        return isset($this->AddOnTypeId) ? $this->AddOnTypeId : null;
    }
    /**
     * Set AddOnTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnTypeId
     * @return \patest\StructType\Merchandise_UIAddOnsItemInformation
     */
    public function setAddOnTypeId($addOnTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($addOnTypeId) && !is_string($addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnTypeId, true), gettype($addOnTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addOnTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addOnTypeId, true)), __LINE__);
        }
        if (is_null($addOnTypeId) || (is_array($addOnTypeId) && empty($addOnTypeId))) {
            unset($this->AddOnTypeId);
        } else {
            $this->AddOnTypeId = $addOnTypeId;
        }
        return $this;
    }
    /**
     * Get AddOnTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnTypeName()
    {
        return isset($this->AddOnTypeName) ? $this->AddOnTypeName : null;
    }
    /**
     * Set AddOnTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnTypeName
     * @return \patest\StructType\Merchandise_UIAddOnsItemInformation
     */
    public function setAddOnTypeName($addOnTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($addOnTypeName) && !is_string($addOnTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnTypeName, true), gettype($addOnTypeName)), __LINE__);
        }
        if (is_null($addOnTypeName) || (is_array($addOnTypeName) && empty($addOnTypeName))) {
            unset($this->AddOnTypeName);
        } else {
            $this->AddOnTypeName = $addOnTypeName;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Merchandise_UIAddOnsItemInformation
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get YourSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getYourSelection()
    {
        return isset($this->YourSelection) ? $this->YourSelection : null;
    }
    /**
     * Set YourSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $yourSelection
     * @return \patest\StructType\Merchandise_UIAddOnsItemInformation
     */
    public function setYourSelection($yourSelection = null)
    {
        // validation for constraint: string
        if (!is_null($yourSelection) && !is_string($yourSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($yourSelection, true), gettype($yourSelection)), __LINE__);
        }
        if (is_null($yourSelection) || (is_array($yourSelection) && empty($yourSelection))) {
            unset($this->YourSelection);
        } else {
            $this->YourSelection = $yourSelection;
        }
        return $this;
    }
}
