<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.StockTakeLineFilter StructType
 * @subpackage Structs
 */
class Merchandise_StockTakeLineFilter extends FilterEntity
{
    /**
     * The CheckedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CheckedByUserId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The LineCheckStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineCheckStatus;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationId;
    /**
     * The MerchandiseItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseItemId;
    /**
     * The StockTakeHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockTakeHeaderId;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for Merchandise.StockTakeLineFilter
     * @uses Merchandise_StockTakeLineFilter::setCheckedByUserId()
     * @uses Merchandise_StockTakeLineFilter::setFromDate()
     * @uses Merchandise_StockTakeLineFilter::setLineCheckStatus()
     * @uses Merchandise_StockTakeLineFilter::setLocationId()
     * @uses Merchandise_StockTakeLineFilter::setMerchandiseItemId()
     * @uses Merchandise_StockTakeLineFilter::setStockTakeHeaderId()
     * @uses Merchandise_StockTakeLineFilter::setToDate()
     * @param string $checkedByUserId
     * @param string $fromDate
     * @param string $lineCheckStatus
     * @param string $locationId
     * @param string $merchandiseItemId
     * @param string $stockTakeHeaderId
     * @param string $toDate
     */
    public function __construct($checkedByUserId = null, $fromDate = null, $lineCheckStatus = null, $locationId = null, $merchandiseItemId = null, $stockTakeHeaderId = null, $toDate = null)
    {
        $this
            ->setCheckedByUserId($checkedByUserId)
            ->setFromDate($fromDate)
            ->setLineCheckStatus($lineCheckStatus)
            ->setLocationId($locationId)
            ->setMerchandiseItemId($merchandiseItemId)
            ->setStockTakeHeaderId($stockTakeHeaderId)
            ->setToDate($toDate);
    }
    /**
     * Get CheckedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckedByUserId()
    {
        return isset($this->CheckedByUserId) ? $this->CheckedByUserId : null;
    }
    /**
     * Set CheckedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkedByUserId
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setCheckedByUserId($checkedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($checkedByUserId) && !is_string($checkedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkedByUserId, true), gettype($checkedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checkedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checkedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checkedByUserId, true)), __LINE__);
        }
        if (is_null($checkedByUserId) || (is_array($checkedByUserId) && empty($checkedByUserId))) {
            unset($this->CheckedByUserId);
        } else {
            $this->CheckedByUserId = $checkedByUserId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get LineCheckStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineCheckStatus()
    {
        return isset($this->LineCheckStatus) ? $this->LineCheckStatus : null;
    }
    /**
     * Set LineCheckStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockTakeLineCheckStatus::valueIsValid()
     * @uses \patest\EnumType\StockTakeLineCheckStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lineCheckStatus
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setLineCheckStatus($lineCheckStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockTakeLineCheckStatus::valueIsValid($lineCheckStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockTakeLineCheckStatus', is_array($lineCheckStatus) ? implode(', ', $lineCheckStatus) : var_export($lineCheckStatus, true), implode(', ', \patest\EnumType\StockTakeLineCheckStatus::getValidValues())), __LINE__);
        }
        if (is_null($lineCheckStatus) || (is_array($lineCheckStatus) && empty($lineCheckStatus))) {
            unset($this->LineCheckStatus);
        } else {
            $this->LineCheckStatus = $lineCheckStatus;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationId
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($locationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($locationId, true)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get MerchandiseItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseItemId()
    {
        return isset($this->MerchandiseItemId) ? $this->MerchandiseItemId : null;
    }
    /**
     * Set MerchandiseItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseItemId
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setMerchandiseItemId($merchandiseItemId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseItemId) && !is_string($merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseItemId, true), gettype($merchandiseItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseItemId, true)), __LINE__);
        }
        if (is_null($merchandiseItemId) || (is_array($merchandiseItemId) && empty($merchandiseItemId))) {
            unset($this->MerchandiseItemId);
        } else {
            $this->MerchandiseItemId = $merchandiseItemId;
        }
        return $this;
    }
    /**
     * Get StockTakeHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockTakeHeaderId()
    {
        return isset($this->StockTakeHeaderId) ? $this->StockTakeHeaderId : null;
    }
    /**
     * Set StockTakeHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockTakeHeaderId
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setStockTakeHeaderId($stockTakeHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($stockTakeHeaderId) && !is_string($stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockTakeHeaderId, true), gettype($stockTakeHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockTakeHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockTakeHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockTakeHeaderId, true)), __LINE__);
        }
        if (is_null($stockTakeHeaderId) || (is_array($stockTakeHeaderId) && empty($stockTakeHeaderId))) {
            unset($this->StockTakeHeaderId);
        } else {
            $this->StockTakeHeaderId = $stockTakeHeaderId;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Merchandise_StockTakeLineFilter
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
