<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.StockItemTransaction StructType
 * @subpackage Structs
 */
class Merchandise_StockItemTransaction extends PersistableEntity
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The CostAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CostAfter;
    /**
     * The CostPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CostPrice;
    /**
     * The CreatedByAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreatedByAuditId;
    /**
     * The CreatedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedOn;
    /**
     * The CrossOrgUnitsAclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CrossOrgUnitsAclSchemeId;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrencyId;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrencyRate;
    /**
     * The EsvAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EsvAfter;
    /**
     * The FormHeaderFormNo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormHeaderFormNo;
    /**
     * The FormHeaderFormType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FormHeaderFormType;
    /**
     * The FormHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormHeaderId;
    /**
     * The FormLineId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormLineId;
    /**
     * The InventoryItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InventoryItemId;
    /**
     * The IsConsignmentIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConsignmentIn;
    /**
     * The LastUpdatedByAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastUpdatedByAuditId;
    /**
     * The LastUpdatedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUpdatedOn;
    /**
     * The LocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LocationId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The QuantityAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityAfter;
    /**
     * The QuantityIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityIn;
    /**
     * The QuantityOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityOut;
    /**
     * The StockAdjReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockAdjReasonId;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The TotalCostAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCostAfter;
    /**
     * The TotalCostIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCostIn;
    /**
     * The TotalCostOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCostOut;
    /**
     * The TotalEsvAfter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsvAfter;
    /**
     * The TotalEsvIn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsvIn;
    /**
     * The TotalEsvOut
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsvOut;
    /**
     * The TransactionTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionTypeId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Merchandise.StockItemTransaction
     * @uses Merchandise_StockItemTransaction::setAccountId()
     * @uses Merchandise_StockItemTransaction::setAclSchemeId()
     * @uses Merchandise_StockItemTransaction::setComments()
     * @uses Merchandise_StockItemTransaction::setCostAfter()
     * @uses Merchandise_StockItemTransaction::setCostPrice()
     * @uses Merchandise_StockItemTransaction::setCreatedByAuditId()
     * @uses Merchandise_StockItemTransaction::setCreatedOn()
     * @uses Merchandise_StockItemTransaction::setCrossOrgUnitsAclSchemeId()
     * @uses Merchandise_StockItemTransaction::setCurrencyId()
     * @uses Merchandise_StockItemTransaction::setCurrencyRate()
     * @uses Merchandise_StockItemTransaction::setEsvAfter()
     * @uses Merchandise_StockItemTransaction::setFormHeaderFormNo()
     * @uses Merchandise_StockItemTransaction::setFormHeaderFormType()
     * @uses Merchandise_StockItemTransaction::setFormHeaderId()
     * @uses Merchandise_StockItemTransaction::setFormLineId()
     * @uses Merchandise_StockItemTransaction::setInventoryItemId()
     * @uses Merchandise_StockItemTransaction::setIsConsignmentIn()
     * @uses Merchandise_StockItemTransaction::setLastUpdatedByAuditId()
     * @uses Merchandise_StockItemTransaction::setLastUpdatedOn()
     * @uses Merchandise_StockItemTransaction::setLocationId()
     * @uses Merchandise_StockItemTransaction::setMerchandiseId()
     * @uses Merchandise_StockItemTransaction::setOrganizationUnitId()
     * @uses Merchandise_StockItemTransaction::setQuantityAfter()
     * @uses Merchandise_StockItemTransaction::setQuantityIn()
     * @uses Merchandise_StockItemTransaction::setQuantityOut()
     * @uses Merchandise_StockItemTransaction::setStockAdjReasonId()
     * @uses Merchandise_StockItemTransaction::setSystemName()
     * @uses Merchandise_StockItemTransaction::setTotalCostAfter()
     * @uses Merchandise_StockItemTransaction::setTotalCostIn()
     * @uses Merchandise_StockItemTransaction::setTotalCostOut()
     * @uses Merchandise_StockItemTransaction::setTotalEsvAfter()
     * @uses Merchandise_StockItemTransaction::setTotalEsvIn()
     * @uses Merchandise_StockItemTransaction::setTotalEsvOut()
     * @uses Merchandise_StockItemTransaction::setTransactionTypeId()
     * @uses Merchandise_StockItemTransaction::setVisibleBySubordinates()
     * @param string $accountId
     * @param int $aclSchemeId
     * @param string $comments
     * @param \patest\StructType\Money $costAfter
     * @param \patest\StructType\Money $costPrice
     * @param int $createdByAuditId
     * @param string $createdOn
     * @param int $crossOrgUnitsAclSchemeId
     * @param string $currencyId
     * @param float $currencyRate
     * @param \patest\StructType\Money $esvAfter
     * @param string $formHeaderFormNo
     * @param \patest\StructType\GlobalString $formHeaderFormType
     * @param string $formHeaderId
     * @param string $formLineId
     * @param string $inventoryItemId
     * @param bool $isConsignmentIn
     * @param int $lastUpdatedByAuditId
     * @param string $lastUpdatedOn
     * @param string $locationId
     * @param string $merchandiseId
     * @param string $organizationUnitId
     * @param float $quantityAfter
     * @param float $quantityIn
     * @param float $quantityOut
     * @param string $stockAdjReasonId
     * @param string $systemName
     * @param \patest\StructType\Money $totalCostAfter
     * @param \patest\StructType\Money $totalCostIn
     * @param \patest\StructType\Money $totalCostOut
     * @param \patest\StructType\Money $totalEsvAfter
     * @param \patest\StructType\Money $totalEsvIn
     * @param \patest\StructType\Money $totalEsvOut
     * @param string $transactionTypeId
     * @param bool $visibleBySubordinates
     */
    public function __construct($accountId = null, $aclSchemeId = null, $comments = null, \patest\StructType\Money $costAfter = null, \patest\StructType\Money $costPrice = null, $createdByAuditId = null, $createdOn = null, $crossOrgUnitsAclSchemeId = null, $currencyId = null, $currencyRate = null, \patest\StructType\Money $esvAfter = null, $formHeaderFormNo = null, \patest\StructType\GlobalString $formHeaderFormType = null, $formHeaderId = null, $formLineId = null, $inventoryItemId = null, $isConsignmentIn = null, $lastUpdatedByAuditId = null, $lastUpdatedOn = null, $locationId = null, $merchandiseId = null, $organizationUnitId = null, $quantityAfter = null, $quantityIn = null, $quantityOut = null, $stockAdjReasonId = null, $systemName = null, \patest\StructType\Money $totalCostAfter = null, \patest\StructType\Money $totalCostIn = null, \patest\StructType\Money $totalCostOut = null, \patest\StructType\Money $totalEsvAfter = null, \patest\StructType\Money $totalEsvIn = null, \patest\StructType\Money $totalEsvOut = null, $transactionTypeId = null, $visibleBySubordinates = null)
    {
        $this
            ->setAccountId($accountId)
            ->setAclSchemeId($aclSchemeId)
            ->setComments($comments)
            ->setCostAfter($costAfter)
            ->setCostPrice($costPrice)
            ->setCreatedByAuditId($createdByAuditId)
            ->setCreatedOn($createdOn)
            ->setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId)
            ->setCurrencyId($currencyId)
            ->setCurrencyRate($currencyRate)
            ->setEsvAfter($esvAfter)
            ->setFormHeaderFormNo($formHeaderFormNo)
            ->setFormHeaderFormType($formHeaderFormType)
            ->setFormHeaderId($formHeaderId)
            ->setFormLineId($formLineId)
            ->setInventoryItemId($inventoryItemId)
            ->setIsConsignmentIn($isConsignmentIn)
            ->setLastUpdatedByAuditId($lastUpdatedByAuditId)
            ->setLastUpdatedOn($lastUpdatedOn)
            ->setLocationId($locationId)
            ->setMerchandiseId($merchandiseId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setQuantityAfter($quantityAfter)
            ->setQuantityIn($quantityIn)
            ->setQuantityOut($quantityOut)
            ->setStockAdjReasonId($stockAdjReasonId)
            ->setSystemName($systemName)
            ->setTotalCostAfter($totalCostAfter)
            ->setTotalCostIn($totalCostIn)
            ->setTotalCostOut($totalCostOut)
            ->setTotalEsvAfter($totalEsvAfter)
            ->setTotalEsvIn($totalEsvIn)
            ->setTotalEsvOut($totalEsvOut)
            ->setTransactionTypeId($transactionTypeId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get CostAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCostAfter()
    {
        return isset($this->CostAfter) ? $this->CostAfter : null;
    }
    /**
     * Set CostAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $costAfter
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCostAfter(\patest\StructType\Money $costAfter = null)
    {
        if (is_null($costAfter) || (is_array($costAfter) && empty($costAfter))) {
            unset($this->CostAfter);
        } else {
            $this->CostAfter = $costAfter;
        }
        return $this;
    }
    /**
     * Get CostPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCostPrice()
    {
        return isset($this->CostPrice) ? $this->CostPrice : null;
    }
    /**
     * Set CostPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $costPrice
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCostPrice(\patest\StructType\Money $costPrice = null)
    {
        if (is_null($costPrice) || (is_array($costPrice) && empty($costPrice))) {
            unset($this->CostPrice);
        } else {
            $this->CostPrice = $costPrice;
        }
        return $this;
    }
    /**
     * Get CreatedByAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreatedByAuditId()
    {
        return isset($this->CreatedByAuditId) ? $this->CreatedByAuditId : null;
    }
    /**
     * Set CreatedByAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $createdByAuditId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCreatedByAuditId($createdByAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($createdByAuditId) && !(is_int($createdByAuditId) || ctype_digit($createdByAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($createdByAuditId, true), gettype($createdByAuditId)), __LINE__);
        }
        if (is_null($createdByAuditId) || (is_array($createdByAuditId) && empty($createdByAuditId))) {
            unset($this->CreatedByAuditId);
        } else {
            $this->CreatedByAuditId = $createdByAuditId;
        }
        return $this;
    }
    /**
     * Get CreatedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedOn()
    {
        return isset($this->CreatedOn) ? $this->CreatedOn : null;
    }
    /**
     * Set CreatedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdOn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCreatedOn($createdOn = null)
    {
        // validation for constraint: string
        if (!is_null($createdOn) && !is_string($createdOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdOn, true), gettype($createdOn)), __LINE__);
        }
        if (is_null($createdOn) || (is_array($createdOn) && empty($createdOn))) {
            unset($this->CreatedOn);
        } else {
            $this->CreatedOn = $createdOn;
        }
        return $this;
    }
    /**
     * Get CrossOrgUnitsAclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCrossOrgUnitsAclSchemeId()
    {
        return isset($this->CrossOrgUnitsAclSchemeId) ? $this->CrossOrgUnitsAclSchemeId : null;
    }
    /**
     * Set CrossOrgUnitsAclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $crossOrgUnitsAclSchemeId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCrossOrgUnitsAclSchemeId($crossOrgUnitsAclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($crossOrgUnitsAclSchemeId) && !(is_int($crossOrgUnitsAclSchemeId) || ctype_digit($crossOrgUnitsAclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($crossOrgUnitsAclSchemeId, true), gettype($crossOrgUnitsAclSchemeId)), __LINE__);
        }
        if (is_null($crossOrgUnitsAclSchemeId) || (is_array($crossOrgUnitsAclSchemeId) && empty($crossOrgUnitsAclSchemeId))) {
            unset($this->CrossOrgUnitsAclSchemeId);
        } else {
            $this->CrossOrgUnitsAclSchemeId = $crossOrgUnitsAclSchemeId;
        }
        return $this;
    }
    /**
     * Get CurrencyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyId()
    {
        return isset($this->CurrencyId) ? $this->CurrencyId : null;
    }
    /**
     * Set CurrencyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currencyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currencyId, true)), __LINE__);
        }
        if (is_null($currencyId) || (is_array($currencyId) && empty($currencyId))) {
            unset($this->CurrencyId);
        } else {
            $this->CurrencyId = $currencyId;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currencyRate
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyRate) && !(is_float($currencyRate) || is_numeric($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get EsvAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEsvAfter()
    {
        return isset($this->EsvAfter) ? $this->EsvAfter : null;
    }
    /**
     * Set EsvAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $esvAfter
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setEsvAfter(\patest\StructType\Money $esvAfter = null)
    {
        if (is_null($esvAfter) || (is_array($esvAfter) && empty($esvAfter))) {
            unset($this->EsvAfter);
        } else {
            $this->EsvAfter = $esvAfter;
        }
        return $this;
    }
    /**
     * Get FormHeaderFormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormHeaderFormNo()
    {
        return isset($this->FormHeaderFormNo) ? $this->FormHeaderFormNo : null;
    }
    /**
     * Set FormHeaderFormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formHeaderFormNo
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setFormHeaderFormNo($formHeaderFormNo = null)
    {
        // validation for constraint: string
        if (!is_null($formHeaderFormNo) && !is_string($formHeaderFormNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formHeaderFormNo, true), gettype($formHeaderFormNo)), __LINE__);
        }
        if (is_null($formHeaderFormNo) || (is_array($formHeaderFormNo) && empty($formHeaderFormNo))) {
            unset($this->FormHeaderFormNo);
        } else {
            $this->FormHeaderFormNo = $formHeaderFormNo;
        }
        return $this;
    }
    /**
     * Get FormHeaderFormType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFormHeaderFormType()
    {
        return isset($this->FormHeaderFormType) ? $this->FormHeaderFormType : null;
    }
    /**
     * Set FormHeaderFormType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $formHeaderFormType
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setFormHeaderFormType(\patest\StructType\GlobalString $formHeaderFormType = null)
    {
        if (is_null($formHeaderFormType) || (is_array($formHeaderFormType) && empty($formHeaderFormType))) {
            unset($this->FormHeaderFormType);
        } else {
            $this->FormHeaderFormType = $formHeaderFormType;
        }
        return $this;
    }
    /**
     * Get FormHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormHeaderId()
    {
        return isset($this->FormHeaderId) ? $this->FormHeaderId : null;
    }
    /**
     * Set FormHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formHeaderId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setFormHeaderId($formHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($formHeaderId) && !is_string($formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formHeaderId, true), gettype($formHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formHeaderId, true)), __LINE__);
        }
        if (is_null($formHeaderId) || (is_array($formHeaderId) && empty($formHeaderId))) {
            unset($this->FormHeaderId);
        } else {
            $this->FormHeaderId = $formHeaderId;
        }
        return $this;
    }
    /**
     * Get FormLineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormLineId()
    {
        return isset($this->FormLineId) ? $this->FormLineId : null;
    }
    /**
     * Set FormLineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formLineId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setFormLineId($formLineId = null)
    {
        // validation for constraint: string
        if (!is_null($formLineId) && !is_string($formLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formLineId, true), gettype($formLineId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formLineId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formLineId, true)), __LINE__);
        }
        if (is_null($formLineId) || (is_array($formLineId) && empty($formLineId))) {
            unset($this->FormLineId);
        } else {
            $this->FormLineId = $formLineId;
        }
        return $this;
    }
    /**
     * Get InventoryItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInventoryItemId()
    {
        return isset($this->InventoryItemId) ? $this->InventoryItemId : null;
    }
    /**
     * Set InventoryItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inventoryItemId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setInventoryItemId($inventoryItemId = null)
    {
        // validation for constraint: string
        if (!is_null($inventoryItemId) && !is_string($inventoryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inventoryItemId, true), gettype($inventoryItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($inventoryItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $inventoryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($inventoryItemId, true)), __LINE__);
        }
        if (is_null($inventoryItemId) || (is_array($inventoryItemId) && empty($inventoryItemId))) {
            unset($this->InventoryItemId);
        } else {
            $this->InventoryItemId = $inventoryItemId;
        }
        return $this;
    }
    /**
     * Get IsConsignmentIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConsignmentIn()
    {
        return isset($this->IsConsignmentIn) ? $this->IsConsignmentIn : null;
    }
    /**
     * Set IsConsignmentIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConsignmentIn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setIsConsignmentIn($isConsignmentIn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConsignmentIn) && !is_bool($isConsignmentIn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConsignmentIn, true), gettype($isConsignmentIn)), __LINE__);
        }
        if (is_null($isConsignmentIn) || (is_array($isConsignmentIn) && empty($isConsignmentIn))) {
            unset($this->IsConsignmentIn);
        } else {
            $this->IsConsignmentIn = $isConsignmentIn;
        }
        return $this;
    }
    /**
     * Get LastUpdatedByAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastUpdatedByAuditId()
    {
        return isset($this->LastUpdatedByAuditId) ? $this->LastUpdatedByAuditId : null;
    }
    /**
     * Set LastUpdatedByAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastUpdatedByAuditId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setLastUpdatedByAuditId($lastUpdatedByAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastUpdatedByAuditId) && !(is_int($lastUpdatedByAuditId) || ctype_digit($lastUpdatedByAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastUpdatedByAuditId, true), gettype($lastUpdatedByAuditId)), __LINE__);
        }
        if (is_null($lastUpdatedByAuditId) || (is_array($lastUpdatedByAuditId) && empty($lastUpdatedByAuditId))) {
            unset($this->LastUpdatedByAuditId);
        } else {
            $this->LastUpdatedByAuditId = $lastUpdatedByAuditId;
        }
        return $this;
    }
    /**
     * Get LastUpdatedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUpdatedOn()
    {
        return isset($this->LastUpdatedOn) ? $this->LastUpdatedOn : null;
    }
    /**
     * Set LastUpdatedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUpdatedOn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setLastUpdatedOn($lastUpdatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($lastUpdatedOn) && !is_string($lastUpdatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUpdatedOn, true), gettype($lastUpdatedOn)), __LINE__);
        }
        if (is_null($lastUpdatedOn) || (is_array($lastUpdatedOn) && empty($lastUpdatedOn))) {
            unset($this->LastUpdatedOn);
        } else {
            $this->LastUpdatedOn = $lastUpdatedOn;
        }
        return $this;
    }
    /**
     * Get LocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocationId()
    {
        return isset($this->LocationId) ? $this->LocationId : null;
    }
    /**
     * Set LocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $locationId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setLocationId($locationId = null)
    {
        // validation for constraint: string
        if (!is_null($locationId) && !is_string($locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($locationId, true), gettype($locationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($locationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $locationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($locationId, true)), __LINE__);
        }
        if (is_null($locationId) || (is_array($locationId) && empty($locationId))) {
            unset($this->LocationId);
        } else {
            $this->LocationId = $locationId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get QuantityAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityAfter()
    {
        return isset($this->QuantityAfter) ? $this->QuantityAfter : null;
    }
    /**
     * Set QuantityAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityAfter
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setQuantityAfter($quantityAfter = null)
    {
        // validation for constraint: float
        if (!is_null($quantityAfter) && !(is_float($quantityAfter) || is_numeric($quantityAfter))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityAfter, true), gettype($quantityAfter)), __LINE__);
        }
        if (is_null($quantityAfter) || (is_array($quantityAfter) && empty($quantityAfter))) {
            unset($this->QuantityAfter);
        } else {
            $this->QuantityAfter = $quantityAfter;
        }
        return $this;
    }
    /**
     * Get QuantityIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityIn()
    {
        return isset($this->QuantityIn) ? $this->QuantityIn : null;
    }
    /**
     * Set QuantityIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityIn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setQuantityIn($quantityIn = null)
    {
        // validation for constraint: float
        if (!is_null($quantityIn) && !(is_float($quantityIn) || is_numeric($quantityIn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityIn, true), gettype($quantityIn)), __LINE__);
        }
        if (is_null($quantityIn) || (is_array($quantityIn) && empty($quantityIn))) {
            unset($this->QuantityIn);
        } else {
            $this->QuantityIn = $quantityIn;
        }
        return $this;
    }
    /**
     * Get QuantityOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityOut()
    {
        return isset($this->QuantityOut) ? $this->QuantityOut : null;
    }
    /**
     * Set QuantityOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityOut
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setQuantityOut($quantityOut = null)
    {
        // validation for constraint: float
        if (!is_null($quantityOut) && !(is_float($quantityOut) || is_numeric($quantityOut))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityOut, true), gettype($quantityOut)), __LINE__);
        }
        if (is_null($quantityOut) || (is_array($quantityOut) && empty($quantityOut))) {
            unset($this->QuantityOut);
        } else {
            $this->QuantityOut = $quantityOut;
        }
        return $this;
    }
    /**
     * Get StockAdjReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockAdjReasonId()
    {
        return isset($this->StockAdjReasonId) ? $this->StockAdjReasonId : null;
    }
    /**
     * Set StockAdjReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockAdjReasonId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setStockAdjReasonId($stockAdjReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($stockAdjReasonId) && !is_string($stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockAdjReasonId, true), gettype($stockAdjReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockAdjReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockAdjReasonId, true)), __LINE__);
        }
        if (is_null($stockAdjReasonId) || (is_array($stockAdjReasonId) && empty($stockAdjReasonId))) {
            unset($this->StockAdjReasonId);
        } else {
            $this->StockAdjReasonId = $stockAdjReasonId;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get TotalCostAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCostAfter()
    {
        return isset($this->TotalCostAfter) ? $this->TotalCostAfter : null;
    }
    /**
     * Set TotalCostAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCostAfter
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalCostAfter(\patest\StructType\Money $totalCostAfter = null)
    {
        if (is_null($totalCostAfter) || (is_array($totalCostAfter) && empty($totalCostAfter))) {
            unset($this->TotalCostAfter);
        } else {
            $this->TotalCostAfter = $totalCostAfter;
        }
        return $this;
    }
    /**
     * Get TotalCostIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCostIn()
    {
        return isset($this->TotalCostIn) ? $this->TotalCostIn : null;
    }
    /**
     * Set TotalCostIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCostIn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalCostIn(\patest\StructType\Money $totalCostIn = null)
    {
        if (is_null($totalCostIn) || (is_array($totalCostIn) && empty($totalCostIn))) {
            unset($this->TotalCostIn);
        } else {
            $this->TotalCostIn = $totalCostIn;
        }
        return $this;
    }
    /**
     * Get TotalCostOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCostOut()
    {
        return isset($this->TotalCostOut) ? $this->TotalCostOut : null;
    }
    /**
     * Set TotalCostOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCostOut
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalCostOut(\patest\StructType\Money $totalCostOut = null)
    {
        if (is_null($totalCostOut) || (is_array($totalCostOut) && empty($totalCostOut))) {
            unset($this->TotalCostOut);
        } else {
            $this->TotalCostOut = $totalCostOut;
        }
        return $this;
    }
    /**
     * Get TotalEsvAfter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsvAfter()
    {
        return isset($this->TotalEsvAfter) ? $this->TotalEsvAfter : null;
    }
    /**
     * Set TotalEsvAfter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsvAfter
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalEsvAfter(\patest\StructType\Money $totalEsvAfter = null)
    {
        if (is_null($totalEsvAfter) || (is_array($totalEsvAfter) && empty($totalEsvAfter))) {
            unset($this->TotalEsvAfter);
        } else {
            $this->TotalEsvAfter = $totalEsvAfter;
        }
        return $this;
    }
    /**
     * Get TotalEsvIn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsvIn()
    {
        return isset($this->TotalEsvIn) ? $this->TotalEsvIn : null;
    }
    /**
     * Set TotalEsvIn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsvIn
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalEsvIn(\patest\StructType\Money $totalEsvIn = null)
    {
        if (is_null($totalEsvIn) || (is_array($totalEsvIn) && empty($totalEsvIn))) {
            unset($this->TotalEsvIn);
        } else {
            $this->TotalEsvIn = $totalEsvIn;
        }
        return $this;
    }
    /**
     * Get TotalEsvOut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsvOut()
    {
        return isset($this->TotalEsvOut) ? $this->TotalEsvOut : null;
    }
    /**
     * Set TotalEsvOut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsvOut
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTotalEsvOut(\patest\StructType\Money $totalEsvOut = null)
    {
        if (is_null($totalEsvOut) || (is_array($totalEsvOut) && empty($totalEsvOut))) {
            unset($this->TotalEsvOut);
        } else {
            $this->TotalEsvOut = $totalEsvOut;
        }
        return $this;
    }
    /**
     * Get TransactionTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionTypeId()
    {
        return isset($this->TransactionTypeId) ? $this->TransactionTypeId : null;
    }
    /**
     * Set TransactionTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionTypeId
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setTransactionTypeId($transactionTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionTypeId) && !is_string($transactionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionTypeId, true), gettype($transactionTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionTypeId, true)), __LINE__);
        }
        if (is_null($transactionTypeId) || (is_array($transactionTypeId) && empty($transactionTypeId))) {
            unset($this->TransactionTypeId);
        } else {
            $this->TransactionTypeId = $transactionTypeId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Merchandise_StockItemTransaction
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
