<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.FormLine StructType
 * @subpackage Structs
 */
class Merchandise_FormLine extends Merchandise_MerchandiseBase
{
    /**
     * The AddOnsDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AddOnsDetails;
    /**
     * The BackwardContinuationItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BackwardContinuationItemId;
    /**
     * The BarCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarCode;
    /**
     * The CompanyCostPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyCostPrice;
    /**
     * The CompanyEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyEsv;
    /**
     * The CompanyTotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalCost;
    /**
     * The CompanyTotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalEsv;
    /**
     * The CostPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CostPrice;
    /**
     * The CurrencyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrencyId;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrencyRate;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The Esv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Esv;
    /**
     * The FormHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormHeaderId;
    /**
     * The FormQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FormQuantity;
    /**
     * The FromLocationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FromLocationId;
    /**
     * The IsInFormLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInFormLine;
    /**
     * The IsOrderLine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOrderLine;
    /**
     * The LineNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LineNo;
    /**
     * The MainUomLabel
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MainUomLabel;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityInStock
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityInStock;
    /**
     * The QuantityMultiplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityMultiplier;
    /**
     * The QuantityText
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuantityText;
    /**
     * The RemainQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainQuantity;
    /**
     * The SourceLineId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SourceLineId;
    /**
     * The StockAdjReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockAdjReasonId;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCost;
    /**
     * The TotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsv;
    /**
     * The UomId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UomId;
    /**
     * Constructor method for Merchandise.FormLine
     * @uses Merchandise_FormLine::setAddOnsDetails()
     * @uses Merchandise_FormLine::setBackwardContinuationItemId()
     * @uses Merchandise_FormLine::setBarCode()
     * @uses Merchandise_FormLine::setCompanyCostPrice()
     * @uses Merchandise_FormLine::setCompanyEsv()
     * @uses Merchandise_FormLine::setCompanyTotalCost()
     * @uses Merchandise_FormLine::setCompanyTotalEsv()
     * @uses Merchandise_FormLine::setCostPrice()
     * @uses Merchandise_FormLine::setCurrencyId()
     * @uses Merchandise_FormLine::setCurrencyRate()
     * @uses Merchandise_FormLine::setDueDate()
     * @uses Merchandise_FormLine::setEsv()
     * @uses Merchandise_FormLine::setFormHeaderId()
     * @uses Merchandise_FormLine::setFormQuantity()
     * @uses Merchandise_FormLine::setFromLocationId()
     * @uses Merchandise_FormLine::setIsInFormLine()
     * @uses Merchandise_FormLine::setIsOrderLine()
     * @uses Merchandise_FormLine::setLineNo()
     * @uses Merchandise_FormLine::setMainUomLabel()
     * @uses Merchandise_FormLine::setMerchandiseId()
     * @uses Merchandise_FormLine::setProductId()
     * @uses Merchandise_FormLine::setQuantity()
     * @uses Merchandise_FormLine::setQuantityInStock()
     * @uses Merchandise_FormLine::setQuantityMultiplier()
     * @uses Merchandise_FormLine::setQuantityText()
     * @uses Merchandise_FormLine::setRemainQuantity()
     * @uses Merchandise_FormLine::setSourceLineId()
     * @uses Merchandise_FormLine::setStockAdjReasonId()
     * @uses Merchandise_FormLine::setTotalCost()
     * @uses Merchandise_FormLine::setTotalEsv()
     * @uses Merchandise_FormLine::setUomId()
     * @param string $addOnsDetails
     * @param int $backwardContinuationItemId
     * @param string $barCode
     * @param \patest\StructType\Money $companyCostPrice
     * @param \patest\StructType\Money $companyEsv
     * @param \patest\StructType\Money $companyTotalCost
     * @param \patest\StructType\Money $companyTotalEsv
     * @param \patest\StructType\Money $costPrice
     * @param string $currencyId
     * @param float $currencyRate
     * @param string $dueDate
     * @param \patest\StructType\Money $esv
     * @param string $formHeaderId
     * @param float $formQuantity
     * @param string $fromLocationId
     * @param bool $isInFormLine
     * @param bool $isOrderLine
     * @param int $lineNo
     * @param string $mainUomLabel
     * @param string $merchandiseId
     * @param string $productId
     * @param float $quantity
     * @param float $quantityInStock
     * @param float $quantityMultiplier
     * @param string $quantityText
     * @param float $remainQuantity
     * @param string $sourceLineId
     * @param string $stockAdjReasonId
     * @param \patest\StructType\Money $totalCost
     * @param \patest\StructType\Money $totalEsv
     * @param string $uomId
     */
    public function __construct($addOnsDetails = null, $backwardContinuationItemId = null, $barCode = null, \patest\StructType\Money $companyCostPrice = null, \patest\StructType\Money $companyEsv = null, \patest\StructType\Money $companyTotalCost = null, \patest\StructType\Money $companyTotalEsv = null, \patest\StructType\Money $costPrice = null, $currencyId = null, $currencyRate = null, $dueDate = null, \patest\StructType\Money $esv = null, $formHeaderId = null, $formQuantity = null, $fromLocationId = null, $isInFormLine = null, $isOrderLine = null, $lineNo = null, $mainUomLabel = null, $merchandiseId = null, $productId = null, $quantity = null, $quantityInStock = null, $quantityMultiplier = null, $quantityText = null, $remainQuantity = null, $sourceLineId = null, $stockAdjReasonId = null, \patest\StructType\Money $totalCost = null, \patest\StructType\Money $totalEsv = null, $uomId = null)
    {
        $this
            ->setAddOnsDetails($addOnsDetails)
            ->setBackwardContinuationItemId($backwardContinuationItemId)
            ->setBarCode($barCode)
            ->setCompanyCostPrice($companyCostPrice)
            ->setCompanyEsv($companyEsv)
            ->setCompanyTotalCost($companyTotalCost)
            ->setCompanyTotalEsv($companyTotalEsv)
            ->setCostPrice($costPrice)
            ->setCurrencyId($currencyId)
            ->setCurrencyRate($currencyRate)
            ->setDueDate($dueDate)
            ->setEsv($esv)
            ->setFormHeaderId($formHeaderId)
            ->setFormQuantity($formQuantity)
            ->setFromLocationId($fromLocationId)
            ->setIsInFormLine($isInFormLine)
            ->setIsOrderLine($isOrderLine)
            ->setLineNo($lineNo)
            ->setMainUomLabel($mainUomLabel)
            ->setMerchandiseId($merchandiseId)
            ->setProductId($productId)
            ->setQuantity($quantity)
            ->setQuantityInStock($quantityInStock)
            ->setQuantityMultiplier($quantityMultiplier)
            ->setQuantityText($quantityText)
            ->setRemainQuantity($remainQuantity)
            ->setSourceLineId($sourceLineId)
            ->setStockAdjReasonId($stockAdjReasonId)
            ->setTotalCost($totalCost)
            ->setTotalEsv($totalEsv)
            ->setUomId($uomId);
    }
    /**
     * Get AddOnsDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnsDetails()
    {
        return isset($this->AddOnsDetails) ? $this->AddOnsDetails : null;
    }
    /**
     * Set AddOnsDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnsDetails
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setAddOnsDetails($addOnsDetails = null)
    {
        // validation for constraint: string
        if (!is_null($addOnsDetails) && !is_string($addOnsDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnsDetails, true), gettype($addOnsDetails)), __LINE__);
        }
        if (is_null($addOnsDetails) || (is_array($addOnsDetails) && empty($addOnsDetails))) {
            unset($this->AddOnsDetails);
        } else {
            $this->AddOnsDetails = $addOnsDetails;
        }
        return $this;
    }
    /**
     * Get BackwardContinuationItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBackwardContinuationItemId()
    {
        return isset($this->BackwardContinuationItemId) ? $this->BackwardContinuationItemId : null;
    }
    /**
     * Set BackwardContinuationItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $backwardContinuationItemId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setBackwardContinuationItemId($backwardContinuationItemId = null)
    {
        // validation for constraint: int
        if (!is_null($backwardContinuationItemId) && !(is_int($backwardContinuationItemId) || ctype_digit($backwardContinuationItemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($backwardContinuationItemId, true), gettype($backwardContinuationItemId)), __LINE__);
        }
        if (is_null($backwardContinuationItemId) || (is_array($backwardContinuationItemId) && empty($backwardContinuationItemId))) {
            unset($this->BackwardContinuationItemId);
        } else {
            $this->BackwardContinuationItemId = $backwardContinuationItemId;
        }
        return $this;
    }
    /**
     * Get BarCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarCode()
    {
        return isset($this->BarCode) ? $this->BarCode : null;
    }
    /**
     * Set BarCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barCode
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setBarCode($barCode = null)
    {
        // validation for constraint: string
        if (!is_null($barCode) && !is_string($barCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barCode, true), gettype($barCode)), __LINE__);
        }
        if (is_null($barCode) || (is_array($barCode) && empty($barCode))) {
            unset($this->BarCode);
        } else {
            $this->BarCode = $barCode;
        }
        return $this;
    }
    /**
     * Get CompanyCostPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyCostPrice()
    {
        return isset($this->CompanyCostPrice) ? $this->CompanyCostPrice : null;
    }
    /**
     * Set CompanyCostPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyCostPrice
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCompanyCostPrice(\patest\StructType\Money $companyCostPrice = null)
    {
        if (is_null($companyCostPrice) || (is_array($companyCostPrice) && empty($companyCostPrice))) {
            unset($this->CompanyCostPrice);
        } else {
            $this->CompanyCostPrice = $companyCostPrice;
        }
        return $this;
    }
    /**
     * Get CompanyEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyEsv()
    {
        return isset($this->CompanyEsv) ? $this->CompanyEsv : null;
    }
    /**
     * Set CompanyEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyEsv
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCompanyEsv(\patest\StructType\Money $companyEsv = null)
    {
        if (is_null($companyEsv) || (is_array($companyEsv) && empty($companyEsv))) {
            unset($this->CompanyEsv);
        } else {
            $this->CompanyEsv = $companyEsv;
        }
        return $this;
    }
    /**
     * Get CompanyTotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalCost()
    {
        return isset($this->CompanyTotalCost) ? $this->CompanyTotalCost : null;
    }
    /**
     * Set CompanyTotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalCost
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCompanyTotalCost(\patest\StructType\Money $companyTotalCost = null)
    {
        if (is_null($companyTotalCost) || (is_array($companyTotalCost) && empty($companyTotalCost))) {
            unset($this->CompanyTotalCost);
        } else {
            $this->CompanyTotalCost = $companyTotalCost;
        }
        return $this;
    }
    /**
     * Get CompanyTotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalEsv()
    {
        return isset($this->CompanyTotalEsv) ? $this->CompanyTotalEsv : null;
    }
    /**
     * Set CompanyTotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalEsv
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCompanyTotalEsv(\patest\StructType\Money $companyTotalEsv = null)
    {
        if (is_null($companyTotalEsv) || (is_array($companyTotalEsv) && empty($companyTotalEsv))) {
            unset($this->CompanyTotalEsv);
        } else {
            $this->CompanyTotalEsv = $companyTotalEsv;
        }
        return $this;
    }
    /**
     * Get CostPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCostPrice()
    {
        return isset($this->CostPrice) ? $this->CostPrice : null;
    }
    /**
     * Set CostPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $costPrice
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCostPrice(\patest\StructType\Money $costPrice = null)
    {
        if (is_null($costPrice) || (is_array($costPrice) && empty($costPrice))) {
            unset($this->CostPrice);
        } else {
            $this->CostPrice = $costPrice;
        }
        return $this;
    }
    /**
     * Get CurrencyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyId()
    {
        return isset($this->CurrencyId) ? $this->CurrencyId : null;
    }
    /**
     * Set CurrencyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCurrencyId($currencyId = null)
    {
        // validation for constraint: string
        if (!is_null($currencyId) && !is_string($currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyId, true), gettype($currencyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currencyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currencyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currencyId, true)), __LINE__);
        }
        if (is_null($currencyId) || (is_array($currencyId) && empty($currencyId))) {
            unset($this->CurrencyId);
        } else {
            $this->CurrencyId = $currencyId;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currencyRate
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyRate) && !(is_float($currencyRate) || is_numeric($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get Esv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEsv()
    {
        return isset($this->Esv) ? $this->Esv : null;
    }
    /**
     * Set Esv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $esv
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setEsv(\patest\StructType\Money $esv = null)
    {
        if (is_null($esv) || (is_array($esv) && empty($esv))) {
            unset($this->Esv);
        } else {
            $this->Esv = $esv;
        }
        return $this;
    }
    /**
     * Get FormHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormHeaderId()
    {
        return isset($this->FormHeaderId) ? $this->FormHeaderId : null;
    }
    /**
     * Set FormHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formHeaderId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setFormHeaderId($formHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($formHeaderId) && !is_string($formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formHeaderId, true), gettype($formHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formHeaderId, true)), __LINE__);
        }
        if (is_null($formHeaderId) || (is_array($formHeaderId) && empty($formHeaderId))) {
            unset($this->FormHeaderId);
        } else {
            $this->FormHeaderId = $formHeaderId;
        }
        return $this;
    }
    /**
     * Get FormQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFormQuantity()
    {
        return isset($this->FormQuantity) ? $this->FormQuantity : null;
    }
    /**
     * Set FormQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $formQuantity
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setFormQuantity($formQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($formQuantity) && !(is_float($formQuantity) || is_numeric($formQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formQuantity, true), gettype($formQuantity)), __LINE__);
        }
        if (is_null($formQuantity) || (is_array($formQuantity) && empty($formQuantity))) {
            unset($this->FormQuantity);
        } else {
            $this->FormQuantity = $formQuantity;
        }
        return $this;
    }
    /**
     * Get FromLocationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromLocationId()
    {
        return isset($this->FromLocationId) ? $this->FromLocationId : null;
    }
    /**
     * Set FromLocationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromLocationId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setFromLocationId($fromLocationId = null)
    {
        // validation for constraint: string
        if (!is_null($fromLocationId) && !is_string($fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromLocationId, true), gettype($fromLocationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fromLocationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fromLocationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fromLocationId, true)), __LINE__);
        }
        if (is_null($fromLocationId) || (is_array($fromLocationId) && empty($fromLocationId))) {
            unset($this->FromLocationId);
        } else {
            $this->FromLocationId = $fromLocationId;
        }
        return $this;
    }
    /**
     * Get IsInFormLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInFormLine()
    {
        return isset($this->IsInFormLine) ? $this->IsInFormLine : null;
    }
    /**
     * Set IsInFormLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInFormLine
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setIsInFormLine($isInFormLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInFormLine) && !is_bool($isInFormLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInFormLine, true), gettype($isInFormLine)), __LINE__);
        }
        if (is_null($isInFormLine) || (is_array($isInFormLine) && empty($isInFormLine))) {
            unset($this->IsInFormLine);
        } else {
            $this->IsInFormLine = $isInFormLine;
        }
        return $this;
    }
    /**
     * Get IsOrderLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOrderLine()
    {
        return isset($this->IsOrderLine) ? $this->IsOrderLine : null;
    }
    /**
     * Set IsOrderLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOrderLine
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setIsOrderLine($isOrderLine = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOrderLine) && !is_bool($isOrderLine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOrderLine, true), gettype($isOrderLine)), __LINE__);
        }
        if (is_null($isOrderLine) || (is_array($isOrderLine) && empty($isOrderLine))) {
            unset($this->IsOrderLine);
        } else {
            $this->IsOrderLine = $isOrderLine;
        }
        return $this;
    }
    /**
     * Get LineNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLineNo()
    {
        return isset($this->LineNo) ? $this->LineNo : null;
    }
    /**
     * Set LineNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lineNo
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setLineNo($lineNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !(is_int($lineNo) || ctype_digit($lineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNo, true), gettype($lineNo)), __LINE__);
        }
        if (is_null($lineNo) || (is_array($lineNo) && empty($lineNo))) {
            unset($this->LineNo);
        } else {
            $this->LineNo = $lineNo;
        }
        return $this;
    }
    /**
     * Get MainUomLabel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMainUomLabel()
    {
        return isset($this->MainUomLabel) ? $this->MainUomLabel : null;
    }
    /**
     * Set MainUomLabel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mainUomLabel
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setMainUomLabel($mainUomLabel = null)
    {
        // validation for constraint: string
        if (!is_null($mainUomLabel) && !is_string($mainUomLabel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mainUomLabel, true), gettype($mainUomLabel)), __LINE__);
        }
        if (is_null($mainUomLabel) || (is_array($mainUomLabel) && empty($mainUomLabel))) {
            unset($this->MainUomLabel);
        } else {
            $this->MainUomLabel = $mainUomLabel;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityInStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityInStock()
    {
        return isset($this->QuantityInStock) ? $this->QuantityInStock : null;
    }
    /**
     * Set QuantityInStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityInStock
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setQuantityInStock($quantityInStock = null)
    {
        // validation for constraint: float
        if (!is_null($quantityInStock) && !(is_float($quantityInStock) || is_numeric($quantityInStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityInStock, true), gettype($quantityInStock)), __LINE__);
        }
        if (is_null($quantityInStock) || (is_array($quantityInStock) && empty($quantityInStock))) {
            unset($this->QuantityInStock);
        } else {
            $this->QuantityInStock = $quantityInStock;
        }
        return $this;
    }
    /**
     * Get QuantityMultiplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityMultiplier()
    {
        return isset($this->QuantityMultiplier) ? $this->QuantityMultiplier : null;
    }
    /**
     * Set QuantityMultiplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityMultiplier
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setQuantityMultiplier($quantityMultiplier = null)
    {
        // validation for constraint: float
        if (!is_null($quantityMultiplier) && !(is_float($quantityMultiplier) || is_numeric($quantityMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityMultiplier, true), gettype($quantityMultiplier)), __LINE__);
        }
        if (is_null($quantityMultiplier) || (is_array($quantityMultiplier) && empty($quantityMultiplier))) {
            unset($this->QuantityMultiplier);
        } else {
            $this->QuantityMultiplier = $quantityMultiplier;
        }
        return $this;
    }
    /**
     * Get QuantityText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuantityText()
    {
        return isset($this->QuantityText) ? $this->QuantityText : null;
    }
    /**
     * Set QuantityText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quantityText
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setQuantityText($quantityText = null)
    {
        // validation for constraint: string
        if (!is_null($quantityText) && !is_string($quantityText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityText, true), gettype($quantityText)), __LINE__);
        }
        if (is_null($quantityText) || (is_array($quantityText) && empty($quantityText))) {
            unset($this->QuantityText);
        } else {
            $this->QuantityText = $quantityText;
        }
        return $this;
    }
    /**
     * Get RemainQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainQuantity()
    {
        return isset($this->RemainQuantity) ? $this->RemainQuantity : null;
    }
    /**
     * Set RemainQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainQuantity
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setRemainQuantity($remainQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($remainQuantity) && !(is_float($remainQuantity) || is_numeric($remainQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainQuantity, true), gettype($remainQuantity)), __LINE__);
        }
        if (is_null($remainQuantity) || (is_array($remainQuantity) && empty($remainQuantity))) {
            unset($this->RemainQuantity);
        } else {
            $this->RemainQuantity = $remainQuantity;
        }
        return $this;
    }
    /**
     * Get SourceLineId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceLineId()
    {
        return isset($this->SourceLineId) ? $this->SourceLineId : null;
    }
    /**
     * Set SourceLineId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceLineId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setSourceLineId($sourceLineId = null)
    {
        // validation for constraint: string
        if (!is_null($sourceLineId) && !is_string($sourceLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceLineId, true), gettype($sourceLineId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sourceLineId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sourceLineId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sourceLineId, true)), __LINE__);
        }
        if (is_null($sourceLineId) || (is_array($sourceLineId) && empty($sourceLineId))) {
            unset($this->SourceLineId);
        } else {
            $this->SourceLineId = $sourceLineId;
        }
        return $this;
    }
    /**
     * Get StockAdjReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockAdjReasonId()
    {
        return isset($this->StockAdjReasonId) ? $this->StockAdjReasonId : null;
    }
    /**
     * Set StockAdjReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockAdjReasonId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setStockAdjReasonId($stockAdjReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($stockAdjReasonId) && !is_string($stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockAdjReasonId, true), gettype($stockAdjReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockAdjReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockAdjReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockAdjReasonId, true)), __LINE__);
        }
        if (is_null($stockAdjReasonId) || (is_array($stockAdjReasonId) && empty($stockAdjReasonId))) {
            unset($this->StockAdjReasonId);
        } else {
            $this->StockAdjReasonId = $stockAdjReasonId;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCost
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setTotalCost(\patest\StructType\Money $totalCost = null)
    {
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
    /**
     * Get TotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsv()
    {
        return isset($this->TotalEsv) ? $this->TotalEsv : null;
    }
    /**
     * Set TotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsv
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setTotalEsv(\patest\StructType\Money $totalEsv = null)
    {
        if (is_null($totalEsv) || (is_array($totalEsv) && empty($totalEsv))) {
            unset($this->TotalEsv);
        } else {
            $this->TotalEsv = $totalEsv;
        }
        return $this;
    }
    /**
     * Get UomId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUomId()
    {
        return isset($this->UomId) ? $this->UomId : null;
    }
    /**
     * Set UomId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uomId
     * @return \patest\StructType\Merchandise_FormLine
     */
    public function setUomId($uomId = null)
    {
        // validation for constraint: string
        if (!is_null($uomId) && !is_string($uomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uomId, true), gettype($uomId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uomId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uomId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uomId, true)), __LINE__);
        }
        if (is_null($uomId) || (is_array($uomId) && empty($uomId))) {
            unset($this->UomId);
        } else {
            $this->UomId = $uomId;
        }
        return $this;
    }
}
