<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.ClientMerchandiseExtendedSummaryGroup
 * StructType
 * @subpackage Structs
 */
class Merchandise_ClientMerchandiseExtendedSummaryGroup extends AnyEntity
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The ItemTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemTypeId;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The MerchandiseName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MerchandiseName;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ProductName;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedAction;
    /**
     * The SaleStatusExtended
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatusExtended;
    /**
     * Constructor method for Merchandise.ClientMerchandiseExtendedSummaryGroup
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setBarcode()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setCategoryId()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setInsertionMode()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setIsComplimentary()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setItemTypeId()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setMerchandiseId()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setMerchandiseName()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setProductName()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setQuantity()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setRequestedAction()
     * @uses Merchandise_ClientMerchandiseExtendedSummaryGroup::setSaleStatusExtended()
     * @param string $barcode
     * @param string $categoryId
     * @param string $insertionMode
     * @param bool $isComplimentary
     * @param string $itemTypeId
     * @param string $merchandiseId
     * @param \patest\StructType\GlobalString $merchandiseName
     * @param \patest\StructType\GlobalString $productName
     * @param int $quantity
     * @param string $requestedAction
     * @param string $saleStatusExtended
     */
    public function __construct($barcode = null, $categoryId = null, $insertionMode = null, $isComplimentary = null, $itemTypeId = null, $merchandiseId = null, \patest\StructType\GlobalString $merchandiseName = null, \patest\StructType\GlobalString $productName = null, $quantity = null, $requestedAction = null, $saleStatusExtended = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCategoryId($categoryId)
            ->setInsertionMode($insertionMode)
            ->setIsComplimentary($isComplimentary)
            ->setItemTypeId($itemTypeId)
            ->setMerchandiseId($merchandiseId)
            ->setMerchandiseName($merchandiseName)
            ->setProductName($productName)
            ->setQuantity($quantity)
            ->setRequestedAction($requestedAction)
            ->setSaleStatusExtended($saleStatusExtended);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemTypeId()
    {
        return isset($this->ItemTypeId) ? $this->ItemTypeId : null;
    }
    /**
     * Set ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemTypeId
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($itemTypeId) && !is_string($itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemTypeId, true)), __LINE__);
        }
        if (is_null($itemTypeId) || (is_array($itemTypeId) && empty($itemTypeId))) {
            unset($this->ItemTypeId);
        } else {
            $this->ItemTypeId = $itemTypeId;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get MerchandiseName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandiseName()
    {
        return isset($this->MerchandiseName) ? $this->MerchandiseName : null;
    }
    /**
     * Set MerchandiseName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandiseName
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setMerchandiseName(\patest\StructType\GlobalString $merchandiseName = null)
    {
        if (is_null($merchandiseName) || (is_array($merchandiseName) && empty($merchandiseName))) {
            unset($this->MerchandiseName);
        } else {
            $this->MerchandiseName = $merchandiseName;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $productName
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setProductName(\patest\StructType\GlobalString $productName = null)
    {
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RequestedAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedAction()
    {
        return isset($this->RequestedAction) ? $this->RequestedAction : null;
    }
    /**
     * Set RequestedAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        if (is_null($requestedAction) || (is_array($requestedAction) && empty($requestedAction))) {
            unset($this->RequestedAction);
        } else {
            $this->RequestedAction = $requestedAction;
        }
        return $this;
    }
    /**
     * Get SaleStatusExtended value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatusExtended()
    {
        return isset($this->SaleStatusExtended) ? $this->SaleStatusExtended : null;
    }
    /**
     * Set SaleStatusExtended value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SaleStatusExtended::valueIsValid()
     * @uses \patest\EnumType\SaleStatusExtended::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatusExtended
     * @return \patest\StructType\Merchandise_ClientMerchandiseExtendedSummaryGroup
     */
    public function setSaleStatusExtended($saleStatusExtended = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SaleStatusExtended::valueIsValid($saleStatusExtended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SaleStatusExtended', is_array($saleStatusExtended) ? implode(', ', $saleStatusExtended) : var_export($saleStatusExtended, true), implode(', ', \patest\EnumType\SaleStatusExtended::getValidValues())), __LINE__);
        }
        if (is_null($saleStatusExtended) || (is_array($saleStatusExtended) && empty($saleStatusExtended))) {
            unset($this->SaleStatusExtended);
        } else {
            $this->SaleStatusExtended = $saleStatusExtended;
        }
        return $this;
    }
}
