<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.AddOnOption StructType
 * @subpackage Structs
 */
class Merchandise_AddOnOption extends Merchandise_MerchandiseBase
{
    /**
     * The AdditionalDefinitions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalDefinitions;
    /**
     * The AddOnComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddOnComponentId;
    /**
     * The ExtraCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ExtraCharge;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The RelatedMerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedMerchandiseId;
    /**
     * The UOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UOMId;
    /**
     * Constructor method for Merchandise.AddOnOption
     * @uses Merchandise_AddOnOption::setAdditionalDefinitions()
     * @uses Merchandise_AddOnOption::setAddOnComponentId()
     * @uses Merchandise_AddOnOption::setExtraCharge()
     * @uses Merchandise_AddOnOption::setIsActive()
     * @uses Merchandise_AddOnOption::setMedia()
     * @uses Merchandise_AddOnOption::setName()
     * @uses Merchandise_AddOnOption::setQuantity()
     * @uses Merchandise_AddOnOption::setRelatedMerchandiseId()
     * @uses Merchandise_AddOnOption::setUOMId()
     * @param string $additionalDefinitions
     * @param string $addOnComponentId
     * @param \patest\StructType\Money $extraCharge
     * @param bool $isActive
     * @param \patest\StructType\Merchandise_Media $media
     * @param \patest\StructType\GlobalString $name
     * @param float $quantity
     * @param string $relatedMerchandiseId
     * @param string $uOMId
     */
    public function __construct($additionalDefinitions = null, $addOnComponentId = null, \patest\StructType\Money $extraCharge = null, $isActive = null, \patest\StructType\Merchandise_Media $media = null, \patest\StructType\GlobalString $name = null, $quantity = null, $relatedMerchandiseId = null, $uOMId = null)
    {
        $this
            ->setAdditionalDefinitions($additionalDefinitions)
            ->setAddOnComponentId($addOnComponentId)
            ->setExtraCharge($extraCharge)
            ->setIsActive($isActive)
            ->setMedia($media)
            ->setName($name)
            ->setQuantity($quantity)
            ->setRelatedMerchandiseId($relatedMerchandiseId)
            ->setUOMId($uOMId);
    }
    /**
     * Get AdditionalDefinitions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalDefinitions()
    {
        return isset($this->AdditionalDefinitions) ? $this->AdditionalDefinitions : null;
    }
    /**
     * Set AdditionalDefinitions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalDefinitions
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setAdditionalDefinitions($additionalDefinitions = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDefinitions) && !is_string($additionalDefinitions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDefinitions, true), gettype($additionalDefinitions)), __LINE__);
        }
        if (is_null($additionalDefinitions) || (is_array($additionalDefinitions) && empty($additionalDefinitions))) {
            unset($this->AdditionalDefinitions);
        } else {
            $this->AdditionalDefinitions = $additionalDefinitions;
        }
        return $this;
    }
    /**
     * Get AddOnComponentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnComponentId()
    {
        return isset($this->AddOnComponentId) ? $this->AddOnComponentId : null;
    }
    /**
     * Set AddOnComponentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnComponentId
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setAddOnComponentId($addOnComponentId = null)
    {
        // validation for constraint: string
        if (!is_null($addOnComponentId) && !is_string($addOnComponentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnComponentId, true), gettype($addOnComponentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addOnComponentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addOnComponentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addOnComponentId, true)), __LINE__);
        }
        if (is_null($addOnComponentId) || (is_array($addOnComponentId) && empty($addOnComponentId))) {
            unset($this->AddOnComponentId);
        } else {
            $this->AddOnComponentId = $addOnComponentId;
        }
        return $this;
    }
    /**
     * Get ExtraCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getExtraCharge()
    {
        return isset($this->ExtraCharge) ? $this->ExtraCharge : null;
    }
    /**
     * Set ExtraCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $extraCharge
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setExtraCharge(\patest\StructType\Money $extraCharge = null)
    {
        if (is_null($extraCharge) || (is_array($extraCharge) && empty($extraCharge))) {
            unset($this->ExtraCharge);
        } else {
            $this->ExtraCharge = $extraCharge;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RelatedMerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedMerchandiseId()
    {
        return isset($this->RelatedMerchandiseId) ? $this->RelatedMerchandiseId : null;
    }
    /**
     * Set RelatedMerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedMerchandiseId
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setRelatedMerchandiseId($relatedMerchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedMerchandiseId) && !is_string($relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedMerchandiseId, true), gettype($relatedMerchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedMerchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedMerchandiseId, true)), __LINE__);
        }
        if (is_null($relatedMerchandiseId) || (is_array($relatedMerchandiseId) && empty($relatedMerchandiseId))) {
            unset($this->RelatedMerchandiseId);
        } else {
            $this->RelatedMerchandiseId = $relatedMerchandiseId;
        }
        return $this;
    }
    /**
     * Get UOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMId()
    {
        return isset($this->UOMId) ? $this->UOMId : null;
    }
    /**
     * Set UOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMId
     * @return \patest\StructType\Merchandise_AddOnOption
     */
    public function setUOMId($uOMId = null)
    {
        // validation for constraint: string
        if (!is_null($uOMId) && !is_string($uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMId, true), gettype($uOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uOMId, true)), __LINE__);
        }
        if (is_null($uOMId) || (is_array($uOMId) && empty($uOMId))) {
            unset($this->UOMId);
        } else {
            $this->UOMId = $uOMId;
        }
        return $this;
    }
}
