<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Merchandise.AddOnComponent StructType
 * @subpackage Structs
 */
class Merchandise_AddOnComponent extends Merchandise_MerchandiseBase
{
    /**
     * The AdditionalDefinitions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdditionalDefinitions;
    /**
     * The AddOnOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMerchandise_AddOnOption
     */
    public $AddOnOptions;
    /**
     * The AddOnTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AddOnTypeId;
    /**
     * The DataType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataType;
    /**
     * The ExtraCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ExtraCharge;
    /**
     * The MaximumNoOfCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaximumNoOfCharacters;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Merchandise_Media
     */
    public $Media;
    /**
     * The MinimumNoOfCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinimumNoOfCharacters;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The RelatedMerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedMerchandiseId;
    /**
     * The UOMId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UOMId;
    /**
     * Constructor method for Merchandise.AddOnComponent
     * @uses Merchandise_AddOnComponent::setAdditionalDefinitions()
     * @uses Merchandise_AddOnComponent::setAddOnOptions()
     * @uses Merchandise_AddOnComponent::setAddOnTypeId()
     * @uses Merchandise_AddOnComponent::setDataType()
     * @uses Merchandise_AddOnComponent::setExtraCharge()
     * @uses Merchandise_AddOnComponent::setMaximumNoOfCharacters()
     * @uses Merchandise_AddOnComponent::setMedia()
     * @uses Merchandise_AddOnComponent::setMinimumNoOfCharacters()
     * @uses Merchandise_AddOnComponent::setName()
     * @uses Merchandise_AddOnComponent::setQuantity()
     * @uses Merchandise_AddOnComponent::setRelatedMerchandiseId()
     * @uses Merchandise_AddOnComponent::setUOMId()
     * @param string $additionalDefinitions
     * @param \patest\StructType\RecordSetOfMerchandise_AddOnOption $addOnOptions
     * @param string $addOnTypeId
     * @param string $dataType
     * @param \patest\StructType\Money $extraCharge
     * @param int $maximumNoOfCharacters
     * @param \patest\StructType\Merchandise_Media $media
     * @param int $minimumNoOfCharacters
     * @param \patest\StructType\GlobalString $name
     * @param float $quantity
     * @param string $relatedMerchandiseId
     * @param string $uOMId
     */
    public function __construct($additionalDefinitions = null, \patest\StructType\RecordSetOfMerchandise_AddOnOption $addOnOptions = null, $addOnTypeId = null, $dataType = null, \patest\StructType\Money $extraCharge = null, $maximumNoOfCharacters = null, \patest\StructType\Merchandise_Media $media = null, $minimumNoOfCharacters = null, \patest\StructType\GlobalString $name = null, $quantity = null, $relatedMerchandiseId = null, $uOMId = null)
    {
        $this
            ->setAdditionalDefinitions($additionalDefinitions)
            ->setAddOnOptions($addOnOptions)
            ->setAddOnTypeId($addOnTypeId)
            ->setDataType($dataType)
            ->setExtraCharge($extraCharge)
            ->setMaximumNoOfCharacters($maximumNoOfCharacters)
            ->setMedia($media)
            ->setMinimumNoOfCharacters($minimumNoOfCharacters)
            ->setName($name)
            ->setQuantity($quantity)
            ->setRelatedMerchandiseId($relatedMerchandiseId)
            ->setUOMId($uOMId);
    }
    /**
     * Get AdditionalDefinitions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdditionalDefinitions()
    {
        return isset($this->AdditionalDefinitions) ? $this->AdditionalDefinitions : null;
    }
    /**
     * Set AdditionalDefinitions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $additionalDefinitions
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setAdditionalDefinitions($additionalDefinitions = null)
    {
        // validation for constraint: string
        if (!is_null($additionalDefinitions) && !is_string($additionalDefinitions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($additionalDefinitions, true), gettype($additionalDefinitions)), __LINE__);
        }
        if (is_null($additionalDefinitions) || (is_array($additionalDefinitions) && empty($additionalDefinitions))) {
            unset($this->AdditionalDefinitions);
        } else {
            $this->AdditionalDefinitions = $additionalDefinitions;
        }
        return $this;
    }
    /**
     * Get AddOnOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMerchandise_AddOnOption|null
     */
    public function getAddOnOptions()
    {
        return isset($this->AddOnOptions) ? $this->AddOnOptions : null;
    }
    /**
     * Set AddOnOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMerchandise_AddOnOption $addOnOptions
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setAddOnOptions(\patest\StructType\RecordSetOfMerchandise_AddOnOption $addOnOptions = null)
    {
        if (is_null($addOnOptions) || (is_array($addOnOptions) && empty($addOnOptions))) {
            unset($this->AddOnOptions);
        } else {
            $this->AddOnOptions = $addOnOptions;
        }
        return $this;
    }
    /**
     * Get AddOnTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAddOnTypeId()
    {
        return isset($this->AddOnTypeId) ? $this->AddOnTypeId : null;
    }
    /**
     * Set AddOnTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $addOnTypeId
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setAddOnTypeId($addOnTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($addOnTypeId) && !is_string($addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addOnTypeId, true), gettype($addOnTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($addOnTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $addOnTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($addOnTypeId, true)), __LINE__);
        }
        if (is_null($addOnTypeId) || (is_array($addOnTypeId) && empty($addOnTypeId))) {
            unset($this->AddOnTypeId);
        } else {
            $this->AddOnTypeId = $addOnTypeId;
        }
        return $this;
    }
    /**
     * Get DataType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataType()
    {
        return isset($this->DataType) ? $this->DataType : null;
    }
    /**
     * Set DataType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AddOnDataType::valueIsValid()
     * @uses \patest\EnumType\AddOnDataType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dataType
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setDataType($dataType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AddOnDataType::valueIsValid($dataType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AddOnDataType', is_array($dataType) ? implode(', ', $dataType) : var_export($dataType, true), implode(', ', \patest\EnumType\AddOnDataType::getValidValues())), __LINE__);
        }
        if (is_null($dataType) || (is_array($dataType) && empty($dataType))) {
            unset($this->DataType);
        } else {
            $this->DataType = $dataType;
        }
        return $this;
    }
    /**
     * Get ExtraCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getExtraCharge()
    {
        return isset($this->ExtraCharge) ? $this->ExtraCharge : null;
    }
    /**
     * Set ExtraCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $extraCharge
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setExtraCharge(\patest\StructType\Money $extraCharge = null)
    {
        if (is_null($extraCharge) || (is_array($extraCharge) && empty($extraCharge))) {
            unset($this->ExtraCharge);
        } else {
            $this->ExtraCharge = $extraCharge;
        }
        return $this;
    }
    /**
     * Get MaximumNoOfCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaximumNoOfCharacters()
    {
        return isset($this->MaximumNoOfCharacters) ? $this->MaximumNoOfCharacters : null;
    }
    /**
     * Set MaximumNoOfCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maximumNoOfCharacters
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setMaximumNoOfCharacters($maximumNoOfCharacters = null)
    {
        // validation for constraint: int
        if (!is_null($maximumNoOfCharacters) && !(is_int($maximumNoOfCharacters) || ctype_digit($maximumNoOfCharacters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maximumNoOfCharacters, true), gettype($maximumNoOfCharacters)), __LINE__);
        }
        if (is_null($maximumNoOfCharacters) || (is_array($maximumNoOfCharacters) && empty($maximumNoOfCharacters))) {
            unset($this->MaximumNoOfCharacters);
        } else {
            $this->MaximumNoOfCharacters = $maximumNoOfCharacters;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Merchandise_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Merchandise_Media $media
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setMedia(\patest\StructType\Merchandise_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinimumNoOfCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinimumNoOfCharacters()
    {
        return isset($this->MinimumNoOfCharacters) ? $this->MinimumNoOfCharacters : null;
    }
    /**
     * Set MinimumNoOfCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minimumNoOfCharacters
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setMinimumNoOfCharacters($minimumNoOfCharacters = null)
    {
        // validation for constraint: int
        if (!is_null($minimumNoOfCharacters) && !(is_int($minimumNoOfCharacters) || ctype_digit($minimumNoOfCharacters))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minimumNoOfCharacters, true), gettype($minimumNoOfCharacters)), __LINE__);
        }
        if (is_null($minimumNoOfCharacters) || (is_array($minimumNoOfCharacters) && empty($minimumNoOfCharacters))) {
            unset($this->MinimumNoOfCharacters);
        } else {
            $this->MinimumNoOfCharacters = $minimumNoOfCharacters;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get RelatedMerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedMerchandiseId()
    {
        return isset($this->RelatedMerchandiseId) ? $this->RelatedMerchandiseId : null;
    }
    /**
     * Set RelatedMerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedMerchandiseId
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setRelatedMerchandiseId($relatedMerchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedMerchandiseId) && !is_string($relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedMerchandiseId, true), gettype($relatedMerchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedMerchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedMerchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedMerchandiseId, true)), __LINE__);
        }
        if (is_null($relatedMerchandiseId) || (is_array($relatedMerchandiseId) && empty($relatedMerchandiseId))) {
            unset($this->RelatedMerchandiseId);
        } else {
            $this->RelatedMerchandiseId = $relatedMerchandiseId;
        }
        return $this;
    }
    /**
     * Get UOMId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUOMId()
    {
        return isset($this->UOMId) ? $this->UOMId : null;
    }
    /**
     * Set UOMId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uOMId
     * @return \patest\StructType\Merchandise_AddOnComponent
     */
    public function setUOMId($uOMId = null)
    {
        // validation for constraint: string
        if (!is_null($uOMId) && !is_string($uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uOMId, true), gettype($uOMId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uOMId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uOMId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uOMId, true)), __LINE__);
        }
        if (is_null($uOMId) || (is_array($uOMId) && empty($uOMId))) {
            unset($this->UOMId);
        } else {
            $this->UOMId = $uOMId;
        }
        return $this;
    }
}
