<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.Printing.MembershipDefinition StructType
 * @subpackage Structs
 */
class Membership_Printing_MembershipDefinition extends Printing_Item_ComplexProperty_Base
{
    /**
     * The AllianceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AllianceName;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The JointMembershipPrintingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $JointMembershipPrintingOption;
    /**
     * The MaxEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MaxEndDate;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_Printing_Media
     */
    public $Media;
    /**
     * The MinStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The SchemeLevelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SchemeLevelName;
    /**
     * The SchemeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SchemeName;
    /**
     * Constructor method for Membership.Printing.MembershipDefinition
     * @uses Membership_Printing_MembershipDefinition::setAllianceName()
     * @uses Membership_Printing_MembershipDefinition::setDescription()
     * @uses Membership_Printing_MembershipDefinition::setJointMembershipPrintingOption()
     * @uses Membership_Printing_MembershipDefinition::setMaxEndDate()
     * @uses Membership_Printing_MembershipDefinition::setMedia()
     * @uses Membership_Printing_MembershipDefinition::setMinStartDate()
     * @uses Membership_Printing_MembershipDefinition::setName()
     * @uses Membership_Printing_MembershipDefinition::setSchemeLevelName()
     * @uses Membership_Printing_MembershipDefinition::setSchemeName()
     * @param \patest\StructType\GlobalString $allianceName
     * @param \patest\StructType\GlobalString $description
     * @param string $jointMembershipPrintingOption
     * @param string $maxEndDate
     * @param \patest\StructType\Membership_Printing_Media $media
     * @param string $minStartDate
     * @param \patest\StructType\GlobalString $name
     * @param \patest\StructType\GlobalString $schemeLevelName
     * @param \patest\StructType\GlobalString $schemeName
     */
    public function __construct(\patest\StructType\GlobalString $allianceName = null, \patest\StructType\GlobalString $description = null, $jointMembershipPrintingOption = null, $maxEndDate = null, \patest\StructType\Membership_Printing_Media $media = null, $minStartDate = null, \patest\StructType\GlobalString $name = null, \patest\StructType\GlobalString $schemeLevelName = null, \patest\StructType\GlobalString $schemeName = null)
    {
        $this
            ->setAllianceName($allianceName)
            ->setDescription($description)
            ->setJointMembershipPrintingOption($jointMembershipPrintingOption)
            ->setMaxEndDate($maxEndDate)
            ->setMedia($media)
            ->setMinStartDate($minStartDate)
            ->setName($name)
            ->setSchemeLevelName($schemeLevelName)
            ->setSchemeName($schemeName);
    }
    /**
     * Get AllianceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAllianceName()
    {
        return isset($this->AllianceName) ? $this->AllianceName : null;
    }
    /**
     * Set AllianceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $allianceName
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setAllianceName(\patest\StructType\GlobalString $allianceName = null)
    {
        if (is_null($allianceName) || (is_array($allianceName) && empty($allianceName))) {
            unset($this->AllianceName);
        } else {
            $this->AllianceName = $allianceName;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get JointMembershipPrintingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getJointMembershipPrintingOption()
    {
        return isset($this->JointMembershipPrintingOption) ? $this->JointMembershipPrintingOption : null;
    }
    /**
     * Set JointMembershipPrintingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\JointMembershipPrintingOption::valueIsValid()
     * @uses \patest\EnumType\JointMembershipPrintingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $jointMembershipPrintingOption
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setJointMembershipPrintingOption($jointMembershipPrintingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\JointMembershipPrintingOption::valueIsValid($jointMembershipPrintingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\JointMembershipPrintingOption', is_array($jointMembershipPrintingOption) ? implode(', ', $jointMembershipPrintingOption) : var_export($jointMembershipPrintingOption, true), implode(', ', \patest\EnumType\JointMembershipPrintingOption::getValidValues())), __LINE__);
        }
        if (is_null($jointMembershipPrintingOption) || (is_array($jointMembershipPrintingOption) && empty($jointMembershipPrintingOption))) {
            unset($this->JointMembershipPrintingOption);
        } else {
            $this->JointMembershipPrintingOption = $jointMembershipPrintingOption;
        }
        return $this;
    }
    /**
     * Get MaxEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMaxEndDate()
    {
        return isset($this->MaxEndDate) ? $this->MaxEndDate : null;
    }
    /**
     * Set MaxEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $maxEndDate
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setMaxEndDate($maxEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($maxEndDate) && !is_string($maxEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxEndDate, true), gettype($maxEndDate)), __LINE__);
        }
        if (is_null($maxEndDate) || (is_array($maxEndDate) && empty($maxEndDate))) {
            unset($this->MaxEndDate);
        } else {
            $this->MaxEndDate = $maxEndDate;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_Printing_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_Printing_Media $media
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setMedia(\patest\StructType\Membership_Printing_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get MinStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartDate()
    {
        return isset($this->MinStartDate) ? $this->MinStartDate : null;
    }
    /**
     * Set MinStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartDate
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setMinStartDate($minStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($minStartDate) && !is_string($minStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartDate, true), gettype($minStartDate)), __LINE__);
        }
        if (is_null($minStartDate) || (is_array($minStartDate) && empty($minStartDate))) {
            unset($this->MinStartDate);
        } else {
            $this->MinStartDate = $minStartDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SchemeLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSchemeLevelName()
    {
        return isset($this->SchemeLevelName) ? $this->SchemeLevelName : null;
    }
    /**
     * Set SchemeLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $schemeLevelName
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setSchemeLevelName(\patest\StructType\GlobalString $schemeLevelName = null)
    {
        if (is_null($schemeLevelName) || (is_array($schemeLevelName) && empty($schemeLevelName))) {
            unset($this->SchemeLevelName);
        } else {
            $this->SchemeLevelName = $schemeLevelName;
        }
        return $this;
    }
    /**
     * Get SchemeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSchemeName()
    {
        return isset($this->SchemeName) ? $this->SchemeName : null;
    }
    /**
     * Set SchemeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $schemeName
     * @return \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public function setSchemeName(\patest\StructType\GlobalString $schemeName = null)
    {
        if (is_null($schemeName) || (is_array($schemeName) && empty($schemeName))) {
            unset($this->SchemeName);
        } else {
            $this->SchemeName = $schemeName;
        }
        return $this;
    }
}
