<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipLinkPaymentLog StructType
 * @subpackage Structs
 */
class Membership_MembershipLinkPaymentLog extends Any_BaseLinkPaymentLog
{
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * Constructor method for Membership.MembershipLinkPaymentLog
     * @uses Membership_MembershipLinkPaymentLog::setMembershipDefinitionId()
     * @uses Membership_MembershipLinkPaymentLog::setPaymentMethodId()
     * @param string $membershipDefinitionId
     * @param string $paymentMethodId
     */
    public function __construct($membershipDefinitionId = null, $paymentMethodId = null)
    {
        $this
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setPaymentMethodId($paymentMethodId);
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Membership_MembershipLinkPaymentLog
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Membership_MembershipLinkPaymentLog
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
}
