<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipAutoRenewFulfillmentBatch StructType
 * @subpackage Structs
 */
class Membership_MembershipAutoRenewFulfillmentBatch extends PersistableEntity
{
    /**
     * The EnrollmentsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EnrollmentsCount;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedCount;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The FulfilledCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FulfilledCount;
    /**
     * The IsFromScheduledAutoRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFromScheduledAutoRenewal;
    /**
     * The LastFulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastFulfillmentDate;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The ProcessedByUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessedByUserId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The WaivedCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $WaivedCount;
    /**
     * The WorkItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $WorkItemId;
    /**
     * Constructor method for Membership.MembershipAutoRenewFulfillmentBatch
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setEnrollmentsCount()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setFailedCount()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setFromDate()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setFulfilledCount()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setIsFromScheduledAutoRenewal()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setLastFulfillmentDate()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setMembershipDefinitionId()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setPendingCount()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setProcessedByUserId()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setState()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setToDate()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setWaivedCount()
     * @uses Membership_MembershipAutoRenewFulfillmentBatch::setWorkItemId()
     * @param int $enrollmentsCount
     * @param int $failedCount
     * @param string $fromDate
     * @param int $fulfilledCount
     * @param bool $isFromScheduledAutoRenewal
     * @param string $lastFulfillmentDate
     * @param string $membershipDefinitionId
     * @param int $pendingCount
     * @param string $processedByUserId
     * @param string $state
     * @param string $toDate
     * @param int $waivedCount
     * @param string $workItemId
     */
    public function __construct($enrollmentsCount = null, $failedCount = null, $fromDate = null, $fulfilledCount = null, $isFromScheduledAutoRenewal = null, $lastFulfillmentDate = null, $membershipDefinitionId = null, $pendingCount = null, $processedByUserId = null, $state = null, $toDate = null, $waivedCount = null, $workItemId = null)
    {
        $this
            ->setEnrollmentsCount($enrollmentsCount)
            ->setFailedCount($failedCount)
            ->setFromDate($fromDate)
            ->setFulfilledCount($fulfilledCount)
            ->setIsFromScheduledAutoRenewal($isFromScheduledAutoRenewal)
            ->setLastFulfillmentDate($lastFulfillmentDate)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setPendingCount($pendingCount)
            ->setProcessedByUserId($processedByUserId)
            ->setState($state)
            ->setToDate($toDate)
            ->setWaivedCount($waivedCount)
            ->setWorkItemId($workItemId);
    }
    /**
     * Get EnrollmentsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollmentsCount()
    {
        return isset($this->EnrollmentsCount) ? $this->EnrollmentsCount : null;
    }
    /**
     * Set EnrollmentsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollmentsCount
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setEnrollmentsCount($enrollmentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($enrollmentsCount) && !(is_int($enrollmentsCount) || ctype_digit($enrollmentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enrollmentsCount, true), gettype($enrollmentsCount)), __LINE__);
        }
        if (is_null($enrollmentsCount) || (is_array($enrollmentsCount) && empty($enrollmentsCount))) {
            unset($this->EnrollmentsCount);
        } else {
            $this->EnrollmentsCount = $enrollmentsCount;
        }
        return $this;
    }
    /**
     * Get FailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedCount()
    {
        return isset($this->FailedCount) ? $this->FailedCount : null;
    }
    /**
     * Set FailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedCount
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        if (is_null($failedCount) || (is_array($failedCount) && empty($failedCount))) {
            unset($this->FailedCount);
        } else {
            $this->FailedCount = $failedCount;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get FulfilledCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFulfilledCount()
    {
        return isset($this->FulfilledCount) ? $this->FulfilledCount : null;
    }
    /**
     * Set FulfilledCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fulfilledCount
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setFulfilledCount($fulfilledCount = null)
    {
        // validation for constraint: int
        if (!is_null($fulfilledCount) && !(is_int($fulfilledCount) || ctype_digit($fulfilledCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fulfilledCount, true), gettype($fulfilledCount)), __LINE__);
        }
        if (is_null($fulfilledCount) || (is_array($fulfilledCount) && empty($fulfilledCount))) {
            unset($this->FulfilledCount);
        } else {
            $this->FulfilledCount = $fulfilledCount;
        }
        return $this;
    }
    /**
     * Get IsFromScheduledAutoRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFromScheduledAutoRenewal()
    {
        return isset($this->IsFromScheduledAutoRenewal) ? $this->IsFromScheduledAutoRenewal : null;
    }
    /**
     * Set IsFromScheduledAutoRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFromScheduledAutoRenewal
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setIsFromScheduledAutoRenewal($isFromScheduledAutoRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFromScheduledAutoRenewal) && !is_bool($isFromScheduledAutoRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFromScheduledAutoRenewal, true), gettype($isFromScheduledAutoRenewal)), __LINE__);
        }
        if (is_null($isFromScheduledAutoRenewal) || (is_array($isFromScheduledAutoRenewal) && empty($isFromScheduledAutoRenewal))) {
            unset($this->IsFromScheduledAutoRenewal);
        } else {
            $this->IsFromScheduledAutoRenewal = $isFromScheduledAutoRenewal;
        }
        return $this;
    }
    /**
     * Get LastFulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastFulfillmentDate()
    {
        return isset($this->LastFulfillmentDate) ? $this->LastFulfillmentDate : null;
    }
    /**
     * Set LastFulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastFulfillmentDate
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setLastFulfillmentDate($lastFulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastFulfillmentDate) && !is_string($lastFulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastFulfillmentDate, true), gettype($lastFulfillmentDate)), __LINE__);
        }
        if (is_null($lastFulfillmentDate) || (is_array($lastFulfillmentDate) && empty($lastFulfillmentDate))) {
            unset($this->LastFulfillmentDate);
        } else {
            $this->LastFulfillmentDate = $lastFulfillmentDate;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get ProcessedByUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessedByUserId()
    {
        return isset($this->ProcessedByUserId) ? $this->ProcessedByUserId : null;
    }
    /**
     * Set ProcessedByUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processedByUserId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setProcessedByUserId($processedByUserId = null)
    {
        // validation for constraint: string
        if (!is_null($processedByUserId) && !is_string($processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processedByUserId, true), gettype($processedByUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processedByUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processedByUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processedByUserId, true)), __LINE__);
        }
        if (is_null($processedByUserId) || (is_array($processedByUserId) && empty($processedByUserId))) {
            unset($this->ProcessedByUserId);
        } else {
            $this->ProcessedByUserId = $processedByUserId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\FulfillmentState::valueIsValid()
     * @uses \patest\EnumType\FulfillmentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\FulfillmentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\FulfillmentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\FulfillmentState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get WaivedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getWaivedCount()
    {
        return isset($this->WaivedCount) ? $this->WaivedCount : null;
    }
    /**
     * Set WaivedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $waivedCount
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setWaivedCount($waivedCount = null)
    {
        // validation for constraint: int
        if (!is_null($waivedCount) && !(is_int($waivedCount) || ctype_digit($waivedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($waivedCount, true), gettype($waivedCount)), __LINE__);
        }
        if (is_null($waivedCount) || (is_array($waivedCount) && empty($waivedCount))) {
            unset($this->WaivedCount);
        } else {
            $this->WaivedCount = $waivedCount;
        }
        return $this;
    }
    /**
     * Get WorkItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWorkItemId()
    {
        return isset($this->WorkItemId) ? $this->WorkItemId : null;
    }
    /**
     * Set WorkItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $workItemId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillmentBatch
     */
    public function setWorkItemId($workItemId = null)
    {
        // validation for constraint: string
        if (!is_null($workItemId) && !is_string($workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($workItemId, true), gettype($workItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($workItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $workItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($workItemId, true)), __LINE__);
        }
        if (is_null($workItemId) || (is_array($workItemId) && empty($workItemId))) {
            unset($this->WorkItemId);
        } else {
            $this->WorkItemId = $workItemId;
        }
        return $this;
    }
}
