<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Membership.MembershipAutoRenewFulfillment StructType
 * @subpackage Structs
 */
class Membership_MembershipAutoRenewFulfillment extends PersistableEntity
{
    /**
     * The ClientEnrollmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientEnrollmentId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CurrentMembershipStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentMembershipStatus;
    /**
     * The FulfillmentBatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FulfillmentBatchId;
    /**
     * The FulfillmentDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FulfillmentDate;
    /**
     * The IsEnrollmentActive
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnrollmentActive;
    /**
     * The IsJointMembership
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJointMembership;
    /**
     * The IsMembershipRenewed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMembershipRenewed;
    /**
     * The MandateExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateExpirationDate;
    /**
     * The MandateIsActive
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MandateIsActive;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MandateNumber;
    /**
     * The MembershipExpiry
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipExpiry;
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipInstanceClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipInstanceClientId;
    /**
     * The MembershipInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipInstanceId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The OnlineTokenExpiryMonth
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineTokenExpiryMonth;
    /**
     * The OnlineTokenExpiryYear
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnlineTokenExpiryYear;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentPlanPaymentDay
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PaymentPlanPaymentDay;
    /**
     * The PaymentPlanPaymentMethodId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanPaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Remark;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for Membership.MembershipAutoRenewFulfillment
     * @uses Membership_MembershipAutoRenewFulfillment::setClientEnrollmentId()
     * @uses Membership_MembershipAutoRenewFulfillment::setClientId()
     * @uses Membership_MembershipAutoRenewFulfillment::setCurrentMembershipStatus()
     * @uses Membership_MembershipAutoRenewFulfillment::setFulfillmentBatchId()
     * @uses Membership_MembershipAutoRenewFulfillment::setFulfillmentDate()
     * @uses Membership_MembershipAutoRenewFulfillment::setIsEnrollmentActive()
     * @uses Membership_MembershipAutoRenewFulfillment::setIsJointMembership()
     * @uses Membership_MembershipAutoRenewFulfillment::setIsMembershipRenewed()
     * @uses Membership_MembershipAutoRenewFulfillment::setMandateExpirationDate()
     * @uses Membership_MembershipAutoRenewFulfillment::setMandateIsActive()
     * @uses Membership_MembershipAutoRenewFulfillment::setMandateNumber()
     * @uses Membership_MembershipAutoRenewFulfillment::setMembershipExpiry()
     * @uses Membership_MembershipAutoRenewFulfillment::setMembershipId()
     * @uses Membership_MembershipAutoRenewFulfillment::setMembershipInstanceClientId()
     * @uses Membership_MembershipAutoRenewFulfillment::setMembershipInstanceId()
     * @uses Membership_MembershipAutoRenewFulfillment::setMembershipNumber()
     * @uses Membership_MembershipAutoRenewFulfillment::setOnlineTokenExpiryMonth()
     * @uses Membership_MembershipAutoRenewFulfillment::setOnlineTokenExpiryYear()
     * @uses Membership_MembershipAutoRenewFulfillment::setPaymentMethodId()
     * @uses Membership_MembershipAutoRenewFulfillment::setPaymentPlanPaymentDay()
     * @uses Membership_MembershipAutoRenewFulfillment::setPaymentPlanPaymentMethodId()
     * @uses Membership_MembershipAutoRenewFulfillment::setPaymentTokenId()
     * @uses Membership_MembershipAutoRenewFulfillment::setPriceTypeId()
     * @uses Membership_MembershipAutoRenewFulfillment::setRemark()
     * @uses Membership_MembershipAutoRenewFulfillment::setState()
     * @uses Membership_MembershipAutoRenewFulfillment::setTransactionId()
     * @param string $clientEnrollmentId
     * @param string $clientId
     * @param string $currentMembershipStatus
     * @param string $fulfillmentBatchId
     * @param string $fulfillmentDate
     * @param bool $isEnrollmentActive
     * @param bool $isJointMembership
     * @param bool $isMembershipRenewed
     * @param string $mandateExpirationDate
     * @param bool $mandateIsActive
     * @param int $mandateNumber
     * @param string $membershipExpiry
     * @param string $membershipId
     * @param string $membershipInstanceClientId
     * @param string $membershipInstanceId
     * @param string $membershipNumber
     * @param string $onlineTokenExpiryMonth
     * @param string $onlineTokenExpiryYear
     * @param string $paymentMethodId
     * @param int $paymentPlanPaymentDay
     * @param string $paymentPlanPaymentMethodId
     * @param string $paymentTokenId
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $remark
     * @param string $state
     * @param string $transactionId
     */
    public function __construct($clientEnrollmentId = null, $clientId = null, $currentMembershipStatus = null, $fulfillmentBatchId = null, $fulfillmentDate = null, $isEnrollmentActive = null, $isJointMembership = null, $isMembershipRenewed = null, $mandateExpirationDate = null, $mandateIsActive = null, $mandateNumber = null, $membershipExpiry = null, $membershipId = null, $membershipInstanceClientId = null, $membershipInstanceId = null, $membershipNumber = null, $onlineTokenExpiryMonth = null, $onlineTokenExpiryYear = null, $paymentMethodId = null, $paymentPlanPaymentDay = null, $paymentPlanPaymentMethodId = null, $paymentTokenId = null, $priceTypeId = null, \patest\StructType\GlobalString $remark = null, $state = null, $transactionId = null)
    {
        $this
            ->setClientEnrollmentId($clientEnrollmentId)
            ->setClientId($clientId)
            ->setCurrentMembershipStatus($currentMembershipStatus)
            ->setFulfillmentBatchId($fulfillmentBatchId)
            ->setFulfillmentDate($fulfillmentDate)
            ->setIsEnrollmentActive($isEnrollmentActive)
            ->setIsJointMembership($isJointMembership)
            ->setIsMembershipRenewed($isMembershipRenewed)
            ->setMandateExpirationDate($mandateExpirationDate)
            ->setMandateIsActive($mandateIsActive)
            ->setMandateNumber($mandateNumber)
            ->setMembershipExpiry($membershipExpiry)
            ->setMembershipId($membershipId)
            ->setMembershipInstanceClientId($membershipInstanceClientId)
            ->setMembershipInstanceId($membershipInstanceId)
            ->setMembershipNumber($membershipNumber)
            ->setOnlineTokenExpiryMonth($onlineTokenExpiryMonth)
            ->setOnlineTokenExpiryYear($onlineTokenExpiryYear)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentPlanPaymentDay($paymentPlanPaymentDay)
            ->setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setPriceTypeId($priceTypeId)
            ->setRemark($remark)
            ->setState($state)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ClientEnrollmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEnrollmentId()
    {
        return isset($this->ClientEnrollmentId) ? $this->ClientEnrollmentId : null;
    }
    /**
     * Set ClientEnrollmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEnrollmentId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setClientEnrollmentId($clientEnrollmentId = null)
    {
        // validation for constraint: string
        if (!is_null($clientEnrollmentId) && !is_string($clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEnrollmentId, true), gettype($clientEnrollmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientEnrollmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientEnrollmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientEnrollmentId, true)), __LINE__);
        }
        if (is_null($clientEnrollmentId) || (is_array($clientEnrollmentId) && empty($clientEnrollmentId))) {
            unset($this->ClientEnrollmentId);
        } else {
            $this->ClientEnrollmentId = $clientEnrollmentId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CurrentMembershipStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentMembershipStatus()
    {
        return isset($this->CurrentMembershipStatus) ? $this->CurrentMembershipStatus : null;
    }
    /**
     * Set CurrentMembershipStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentMembershipStatus
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setCurrentMembershipStatus($currentMembershipStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($currentMembershipStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($currentMembershipStatus) ? implode(', ', $currentMembershipStatus) : var_export($currentMembershipStatus, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentMembershipStatus) || (is_array($currentMembershipStatus) && empty($currentMembershipStatus))) {
            unset($this->CurrentMembershipStatus);
        } else {
            $this->CurrentMembershipStatus = $currentMembershipStatus;
        }
        return $this;
    }
    /**
     * Get FulfillmentBatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFulfillmentBatchId()
    {
        return isset($this->FulfillmentBatchId) ? $this->FulfillmentBatchId : null;
    }
    /**
     * Set FulfillmentBatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fulfillmentBatchId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setFulfillmentBatchId($fulfillmentBatchId = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentBatchId) && !is_string($fulfillmentBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentBatchId, true), gettype($fulfillmentBatchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fulfillmentBatchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fulfillmentBatchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fulfillmentBatchId, true)), __LINE__);
        }
        if (is_null($fulfillmentBatchId) || (is_array($fulfillmentBatchId) && empty($fulfillmentBatchId))) {
            unset($this->FulfillmentBatchId);
        } else {
            $this->FulfillmentBatchId = $fulfillmentBatchId;
        }
        return $this;
    }
    /**
     * Get FulfillmentDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFulfillmentDate()
    {
        return isset($this->FulfillmentDate) ? $this->FulfillmentDate : null;
    }
    /**
     * Set FulfillmentDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fulfillmentDate
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setFulfillmentDate($fulfillmentDate = null)
    {
        // validation for constraint: string
        if (!is_null($fulfillmentDate) && !is_string($fulfillmentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fulfillmentDate, true), gettype($fulfillmentDate)), __LINE__);
        }
        if (is_null($fulfillmentDate) || (is_array($fulfillmentDate) && empty($fulfillmentDate))) {
            unset($this->FulfillmentDate);
        } else {
            $this->FulfillmentDate = $fulfillmentDate;
        }
        return $this;
    }
    /**
     * Get IsEnrollmentActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnrollmentActive()
    {
        return isset($this->IsEnrollmentActive) ? $this->IsEnrollmentActive : null;
    }
    /**
     * Set IsEnrollmentActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnrollmentActive
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setIsEnrollmentActive($isEnrollmentActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnrollmentActive) && !is_bool($isEnrollmentActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnrollmentActive, true), gettype($isEnrollmentActive)), __LINE__);
        }
        if (is_null($isEnrollmentActive) || (is_array($isEnrollmentActive) && empty($isEnrollmentActive))) {
            unset($this->IsEnrollmentActive);
        } else {
            $this->IsEnrollmentActive = $isEnrollmentActive;
        }
        return $this;
    }
    /**
     * Get IsJointMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJointMembership()
    {
        return isset($this->IsJointMembership) ? $this->IsJointMembership : null;
    }
    /**
     * Set IsJointMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJointMembership
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setIsJointMembership($isJointMembership = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJointMembership) && !is_bool($isJointMembership)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJointMembership, true), gettype($isJointMembership)), __LINE__);
        }
        if (is_null($isJointMembership) || (is_array($isJointMembership) && empty($isJointMembership))) {
            unset($this->IsJointMembership);
        } else {
            $this->IsJointMembership = $isJointMembership;
        }
        return $this;
    }
    /**
     * Get IsMembershipRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMembershipRenewed()
    {
        return isset($this->IsMembershipRenewed) ? $this->IsMembershipRenewed : null;
    }
    /**
     * Set IsMembershipRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMembershipRenewed
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setIsMembershipRenewed($isMembershipRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMembershipRenewed) && !is_bool($isMembershipRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMembershipRenewed, true), gettype($isMembershipRenewed)), __LINE__);
        }
        if (is_null($isMembershipRenewed) || (is_array($isMembershipRenewed) && empty($isMembershipRenewed))) {
            unset($this->IsMembershipRenewed);
        } else {
            $this->IsMembershipRenewed = $isMembershipRenewed;
        }
        return $this;
    }
    /**
     * Get MandateExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateExpirationDate()
    {
        return isset($this->MandateExpirationDate) ? $this->MandateExpirationDate : null;
    }
    /**
     * Set MandateExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateExpirationDate
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMandateExpirationDate($mandateExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($mandateExpirationDate) && !is_string($mandateExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateExpirationDate, true), gettype($mandateExpirationDate)), __LINE__);
        }
        if (is_null($mandateExpirationDate) || (is_array($mandateExpirationDate) && empty($mandateExpirationDate))) {
            unset($this->MandateExpirationDate);
        } else {
            $this->MandateExpirationDate = $mandateExpirationDate;
        }
        return $this;
    }
    /**
     * Get MandateIsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMandateIsActive()
    {
        return isset($this->MandateIsActive) ? $this->MandateIsActive : null;
    }
    /**
     * Set MandateIsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mandateIsActive
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMandateIsActive($mandateIsActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandateIsActive) && !is_bool($mandateIsActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandateIsActive, true), gettype($mandateIsActive)), __LINE__);
        }
        if (is_null($mandateIsActive) || (is_array($mandateIsActive) && empty($mandateIsActive))) {
            unset($this->MandateIsActive);
        } else {
            $this->MandateIsActive = $mandateIsActive;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $mandateNumber
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: int
        if (!is_null($mandateNumber) && !(is_int($mandateNumber) || ctype_digit($mandateNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
    /**
     * Get MembershipExpiry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipExpiry()
    {
        return isset($this->MembershipExpiry) ? $this->MembershipExpiry : null;
    }
    /**
     * Set MembershipExpiry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipExpiry
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMembershipExpiry($membershipExpiry = null)
    {
        // validation for constraint: string
        if (!is_null($membershipExpiry) && !is_string($membershipExpiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipExpiry, true), gettype($membershipExpiry)), __LINE__);
        }
        if (is_null($membershipExpiry) || (is_array($membershipExpiry) && empty($membershipExpiry))) {
            unset($this->MembershipExpiry);
        } else {
            $this->MembershipExpiry = $membershipExpiry;
        }
        return $this;
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipInstanceClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipInstanceClientId()
    {
        return isset($this->MembershipInstanceClientId) ? $this->MembershipInstanceClientId : null;
    }
    /**
     * Set MembershipInstanceClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipInstanceClientId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMembershipInstanceClientId($membershipInstanceClientId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipInstanceClientId) && !is_string($membershipInstanceClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipInstanceClientId, true), gettype($membershipInstanceClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipInstanceClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipInstanceClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipInstanceClientId, true)), __LINE__);
        }
        if (is_null($membershipInstanceClientId) || (is_array($membershipInstanceClientId) && empty($membershipInstanceClientId))) {
            unset($this->MembershipInstanceClientId);
        } else {
            $this->MembershipInstanceClientId = $membershipInstanceClientId;
        }
        return $this;
    }
    /**
     * Get MembershipInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipInstanceId()
    {
        return isset($this->MembershipInstanceId) ? $this->MembershipInstanceId : null;
    }
    /**
     * Set MembershipInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipInstanceId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMembershipInstanceId($membershipInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipInstanceId) && !is_string($membershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipInstanceId, true), gettype($membershipInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipInstanceId, true)), __LINE__);
        }
        if (is_null($membershipInstanceId) || (is_array($membershipInstanceId) && empty($membershipInstanceId))) {
            unset($this->MembershipInstanceId);
        } else {
            $this->MembershipInstanceId = $membershipInstanceId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get OnlineTokenExpiryMonth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineTokenExpiryMonth()
    {
        return isset($this->OnlineTokenExpiryMonth) ? $this->OnlineTokenExpiryMonth : null;
    }
    /**
     * Set OnlineTokenExpiryMonth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineTokenExpiryMonth
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setOnlineTokenExpiryMonth($onlineTokenExpiryMonth = null)
    {
        // validation for constraint: string
        if (!is_null($onlineTokenExpiryMonth) && !is_string($onlineTokenExpiryMonth)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineTokenExpiryMonth, true), gettype($onlineTokenExpiryMonth)), __LINE__);
        }
        if (is_null($onlineTokenExpiryMonth) || (is_array($onlineTokenExpiryMonth) && empty($onlineTokenExpiryMonth))) {
            unset($this->OnlineTokenExpiryMonth);
        } else {
            $this->OnlineTokenExpiryMonth = $onlineTokenExpiryMonth;
        }
        return $this;
    }
    /**
     * Get OnlineTokenExpiryYear value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnlineTokenExpiryYear()
    {
        return isset($this->OnlineTokenExpiryYear) ? $this->OnlineTokenExpiryYear : null;
    }
    /**
     * Set OnlineTokenExpiryYear value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onlineTokenExpiryYear
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setOnlineTokenExpiryYear($onlineTokenExpiryYear = null)
    {
        // validation for constraint: string
        if (!is_null($onlineTokenExpiryYear) && !is_string($onlineTokenExpiryYear)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onlineTokenExpiryYear, true), gettype($onlineTokenExpiryYear)), __LINE__);
        }
        if (is_null($onlineTokenExpiryYear) || (is_array($onlineTokenExpiryYear) && empty($onlineTokenExpiryYear))) {
            unset($this->OnlineTokenExpiryYear);
        } else {
            $this->OnlineTokenExpiryYear = $onlineTokenExpiryYear;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentDay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPaymentPlanPaymentDay()
    {
        return isset($this->PaymentPlanPaymentDay) ? $this->PaymentPlanPaymentDay : null;
    }
    /**
     * Set PaymentPlanPaymentDay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $paymentPlanPaymentDay
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setPaymentPlanPaymentDay($paymentPlanPaymentDay = null)
    {
        // validation for constraint: int
        if (!is_null($paymentPlanPaymentDay) && !(is_int($paymentPlanPaymentDay) || ctype_digit($paymentPlanPaymentDay))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paymentPlanPaymentDay, true), gettype($paymentPlanPaymentDay)), __LINE__);
        }
        if (is_null($paymentPlanPaymentDay) || (is_array($paymentPlanPaymentDay) && empty($paymentPlanPaymentDay))) {
            unset($this->PaymentPlanPaymentDay);
        } else {
            $this->PaymentPlanPaymentDay = $paymentPlanPaymentDay;
        }
        return $this;
    }
    /**
     * Get PaymentPlanPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanPaymentMethodId()
    {
        return isset($this->PaymentPlanPaymentMethodId) ? $this->PaymentPlanPaymentMethodId : null;
    }
    /**
     * Set PaymentPlanPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanPaymentMethodId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setPaymentPlanPaymentMethodId($paymentPlanPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanPaymentMethodId) && !is_string($paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanPaymentMethodId, true), gettype($paymentPlanPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanPaymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentPlanPaymentMethodId) || (is_array($paymentPlanPaymentMethodId) && empty($paymentPlanPaymentMethodId))) {
            unset($this->PaymentPlanPaymentMethodId);
        } else {
            $this->PaymentPlanPaymentMethodId = $paymentPlanPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $remark
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setRemark(\patest\StructType\GlobalString $remark = null)
    {
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EnrollmentFulfillmentState::valueIsValid()
     * @uses \patest\EnumType\EnrollmentFulfillmentState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EnrollmentFulfillmentState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EnrollmentFulfillmentState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\EnrollmentFulfillmentState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\Membership_MembershipAutoRenewFulfillment
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
