<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchingGiftOptionRelationshipDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MatchingGiftOptionRelationshipDetail
 * @subpackage Structs
 */
class MatchingGiftOptionRelationshipDetail extends AbstractStructBase
{
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * The RelationshipTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipTypeName;
    /**
     * The RoleIdOfMatcher
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleIdOfMatcher;
    /**
     * The RoleIdOfReceiver
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RoleIdOfReceiver;
    /**
     * The RoleNameOfMatcher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleNameOfMatcher;
    /**
     * The RoleNameOfReceiver
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RoleNameOfReceiver;
    /**
     * Constructor method for MatchingGiftOptionRelationshipDetail
     * @uses MatchingGiftOptionRelationshipDetail::setRelationshipTypeId()
     * @uses MatchingGiftOptionRelationshipDetail::setRelationshipTypeName()
     * @uses MatchingGiftOptionRelationshipDetail::setRoleIdOfMatcher()
     * @uses MatchingGiftOptionRelationshipDetail::setRoleIdOfReceiver()
     * @uses MatchingGiftOptionRelationshipDetail::setRoleNameOfMatcher()
     * @uses MatchingGiftOptionRelationshipDetail::setRoleNameOfReceiver()
     * @param string $relationshipTypeId
     * @param string $relationshipTypeName
     * @param string $roleIdOfMatcher
     * @param string $roleIdOfReceiver
     * @param string $roleNameOfMatcher
     * @param string $roleNameOfReceiver
     */
    public function __construct($relationshipTypeId = null, $relationshipTypeName = null, $roleIdOfMatcher = null, $roleIdOfReceiver = null, $roleNameOfMatcher = null, $roleNameOfReceiver = null)
    {
        $this
            ->setRelationshipTypeId($relationshipTypeId)
            ->setRelationshipTypeName($relationshipTypeName)
            ->setRoleIdOfMatcher($roleIdOfMatcher)
            ->setRoleIdOfReceiver($roleIdOfReceiver)
            ->setRoleNameOfMatcher($roleNameOfMatcher)
            ->setRoleNameOfReceiver($roleNameOfReceiver);
    }
    /**
     * Get RelationshipTypeId value
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return $this->RelationshipTypeId;
    }
    /**
     * Set RelationshipTypeId value
     * @param string $relationshipTypeId
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        $this->RelationshipTypeId = $relationshipTypeId;
        return $this;
    }
    /**
     * Get RelationshipTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeName()
    {
        return isset($this->RelationshipTypeName) ? $this->RelationshipTypeName : null;
    }
    /**
     * Set RelationshipTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeName
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRelationshipTypeName($relationshipTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeName) && !is_string($relationshipTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeName, true), gettype($relationshipTypeName)), __LINE__);
        }
        if (is_null($relationshipTypeName) || (is_array($relationshipTypeName) && empty($relationshipTypeName))) {
            unset($this->RelationshipTypeName);
        } else {
            $this->RelationshipTypeName = $relationshipTypeName;
        }
        return $this;
    }
    /**
     * Get RoleIdOfMatcher value
     * @return string|null
     */
    public function getRoleIdOfMatcher()
    {
        return $this->RoleIdOfMatcher;
    }
    /**
     * Set RoleIdOfMatcher value
     * @param string $roleIdOfMatcher
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRoleIdOfMatcher($roleIdOfMatcher = null)
    {
        // validation for constraint: string
        if (!is_null($roleIdOfMatcher) && !is_string($roleIdOfMatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleIdOfMatcher, true), gettype($roleIdOfMatcher)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roleIdOfMatcher) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roleIdOfMatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roleIdOfMatcher, true)), __LINE__);
        }
        $this->RoleIdOfMatcher = $roleIdOfMatcher;
        return $this;
    }
    /**
     * Get RoleIdOfReceiver value
     * @return string|null
     */
    public function getRoleIdOfReceiver()
    {
        return $this->RoleIdOfReceiver;
    }
    /**
     * Set RoleIdOfReceiver value
     * @param string $roleIdOfReceiver
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRoleIdOfReceiver($roleIdOfReceiver = null)
    {
        // validation for constraint: string
        if (!is_null($roleIdOfReceiver) && !is_string($roleIdOfReceiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleIdOfReceiver, true), gettype($roleIdOfReceiver)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($roleIdOfReceiver) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $roleIdOfReceiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($roleIdOfReceiver, true)), __LINE__);
        }
        $this->RoleIdOfReceiver = $roleIdOfReceiver;
        return $this;
    }
    /**
     * Get RoleNameOfMatcher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleNameOfMatcher()
    {
        return isset($this->RoleNameOfMatcher) ? $this->RoleNameOfMatcher : null;
    }
    /**
     * Set RoleNameOfMatcher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleNameOfMatcher
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRoleNameOfMatcher($roleNameOfMatcher = null)
    {
        // validation for constraint: string
        if (!is_null($roleNameOfMatcher) && !is_string($roleNameOfMatcher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleNameOfMatcher, true), gettype($roleNameOfMatcher)), __LINE__);
        }
        if (is_null($roleNameOfMatcher) || (is_array($roleNameOfMatcher) && empty($roleNameOfMatcher))) {
            unset($this->RoleNameOfMatcher);
        } else {
            $this->RoleNameOfMatcher = $roleNameOfMatcher;
        }
        return $this;
    }
    /**
     * Get RoleNameOfReceiver value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoleNameOfReceiver()
    {
        return isset($this->RoleNameOfReceiver) ? $this->RoleNameOfReceiver : null;
    }
    /**
     * Set RoleNameOfReceiver value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $roleNameOfReceiver
     * @return \patest\StructType\MatchingGiftOptionRelationshipDetail
     */
    public function setRoleNameOfReceiver($roleNameOfReceiver = null)
    {
        // validation for constraint: string
        if (!is_null($roleNameOfReceiver) && !is_string($roleNameOfReceiver)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleNameOfReceiver, true), gettype($roleNameOfReceiver)), __LINE__);
        }
        if (is_null($roleNameOfReceiver) || (is_array($roleNameOfReceiver) && empty($roleNameOfReceiver))) {
            unset($this->RoleNameOfReceiver);
        } else {
            $this->RoleNameOfReceiver = $roleNameOfReceiver;
        }
        return $this;
    }
}
