<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.ExternallyProcessedAppeal StructType
 * @subpackage Structs
 */
class Marketing_ExternallyProcessedAppeal extends Marketing_ExecutableAppeal
{
    /**
     * The EmailResultsTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailResultsTo;
    /**
     * Constructor method for Marketing.ExternallyProcessedAppeal
     * @uses Marketing_ExternallyProcessedAppeal::setEmailResultsTo()
     * @param string $emailResultsTo
     */
    public function __construct($emailResultsTo = null)
    {
        $this
            ->setEmailResultsTo($emailResultsTo);
    }
    /**
     * Get EmailResultsTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailResultsTo()
    {
        return isset($this->EmailResultsTo) ? $this->EmailResultsTo : null;
    }
    /**
     * Set EmailResultsTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailResultsTo
     * @return \patest\StructType\Marketing_ExternallyProcessedAppeal
     */
    public function setEmailResultsTo($emailResultsTo = null)
    {
        // validation for constraint: string
        if (!is_null($emailResultsTo) && !is_string($emailResultsTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailResultsTo, true), gettype($emailResultsTo)), __LINE__);
        }
        if (is_null($emailResultsTo) || (is_array($emailResultsTo) && empty($emailResultsTo))) {
            unset($this->EmailResultsTo);
        } else {
            $this->EmailResultsTo = $emailResultsTo;
        }
        return $this;
    }
}
