<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Marketing.Appeal StructType
 * @subpackage Structs
 */
class Marketing_Appeal extends DistributableEntity
{
    /**
     * The AppealTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealTypeId;
    /**
     * The AppealTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AppealTypeName;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The Channels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMarketing_AppealChannels
     */
    public $Channels;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DynamicAttributeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DynamicAttributeAction;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The ElementTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElementTypeName;
    /**
     * The ExecutedAppealInProcess
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExecutedAppealInProcess;
    /**
     * The GoalRevenue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $GoalRevenue;
    /**
     * The IncludeManuallyAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeManuallyAttributes;
    /**
     * The LedgerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LedgerId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessDefinitionId;
    /**
     * The ProjectIdentifierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProjectIdentifierId;
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Provider;
    /**
     * The ProviderSetup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderSetup;
    /**
     * The ProviderTitle
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderTitle;
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Schedule;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalCost;
    /**
     * Constructor method for Marketing.Appeal
     * @uses Marketing_Appeal::setAppealTypeId()
     * @uses Marketing_Appeal::setAppealTypeName()
     * @uses Marketing_Appeal::setCampaignId()
     * @uses Marketing_Appeal::setChannels()
     * @uses Marketing_Appeal::setDescription()
     * @uses Marketing_Appeal::setDynamicAttributeAction()
     * @uses Marketing_Appeal::setDynamicClientTypeId()
     * @uses Marketing_Appeal::setDynamicPreferenceId()
     * @uses Marketing_Appeal::setElementTypeName()
     * @uses Marketing_Appeal::setExecutedAppealInProcess()
     * @uses Marketing_Appeal::setGoalRevenue()
     * @uses Marketing_Appeal::setIncludeManuallyAttributes()
     * @uses Marketing_Appeal::setLedgerId()
     * @uses Marketing_Appeal::setName()
     * @uses Marketing_Appeal::setOrganizationUnitId()
     * @uses Marketing_Appeal::setProcessDefinitionId()
     * @uses Marketing_Appeal::setProjectIdentifierId()
     * @uses Marketing_Appeal::setProvider()
     * @uses Marketing_Appeal::setProviderSetup()
     * @uses Marketing_Appeal::setProviderTitle()
     * @uses Marketing_Appeal::setSchedule()
     * @uses Marketing_Appeal::setTotalCost()
     * @param string $appealTypeId
     * @param \patest\StructType\GlobalString $appealTypeName
     * @param string $campaignId
     * @param \patest\StructType\RecordSetOfMarketing_AppealChannels $channels
     * @param \patest\StructType\GlobalString $description
     * @param string $dynamicAttributeAction
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param string $elementTypeName
     * @param string $executedAppealInProcess
     * @param float $goalRevenue
     * @param bool $includeManuallyAttributes
     * @param string $ledgerId
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $processDefinitionId
     * @param string $projectIdentifierId
     * @param string $provider
     * @param string $providerSetup
     * @param string $providerTitle
     * @param string $schedule
     * @param float $totalCost
     */
    public function __construct($appealTypeId = null, \patest\StructType\GlobalString $appealTypeName = null, $campaignId = null, \patest\StructType\RecordSetOfMarketing_AppealChannels $channels = null, \patest\StructType\GlobalString $description = null, $dynamicAttributeAction = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $elementTypeName = null, $executedAppealInProcess = null, $goalRevenue = null, $includeManuallyAttributes = null, $ledgerId = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $processDefinitionId = null, $projectIdentifierId = null, $provider = null, $providerSetup = null, $providerTitle = null, $schedule = null, $totalCost = null)
    {
        $this
            ->setAppealTypeId($appealTypeId)
            ->setAppealTypeName($appealTypeName)
            ->setCampaignId($campaignId)
            ->setChannels($channels)
            ->setDescription($description)
            ->setDynamicAttributeAction($dynamicAttributeAction)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setElementTypeName($elementTypeName)
            ->setExecutedAppealInProcess($executedAppealInProcess)
            ->setGoalRevenue($goalRevenue)
            ->setIncludeManuallyAttributes($includeManuallyAttributes)
            ->setLedgerId($ledgerId)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessDefinitionId($processDefinitionId)
            ->setProjectIdentifierId($projectIdentifierId)
            ->setProvider($provider)
            ->setProviderSetup($providerSetup)
            ->setProviderTitle($providerTitle)
            ->setSchedule($schedule)
            ->setTotalCost($totalCost);
    }
    /**
     * Get AppealTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealTypeId()
    {
        return isset($this->AppealTypeId) ? $this->AppealTypeId : null;
    }
    /**
     * Set AppealTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealTypeId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setAppealTypeId($appealTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($appealTypeId) && !is_string($appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealTypeId, true), gettype($appealTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealTypeId, true)), __LINE__);
        }
        if (is_null($appealTypeId) || (is_array($appealTypeId) && empty($appealTypeId))) {
            unset($this->AppealTypeId);
        } else {
            $this->AppealTypeId = $appealTypeId;
        }
        return $this;
    }
    /**
     * Get AppealTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAppealTypeName()
    {
        return isset($this->AppealTypeName) ? $this->AppealTypeName : null;
    }
    /**
     * Set AppealTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $appealTypeName
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setAppealTypeName(\patest\StructType\GlobalString $appealTypeName = null)
    {
        if (is_null($appealTypeName) || (is_array($appealTypeName) && empty($appealTypeName))) {
            unset($this->AppealTypeName);
        } else {
            $this->AppealTypeName = $appealTypeName;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get Channels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMarketing_AppealChannels|null
     */
    public function getChannels()
    {
        return isset($this->Channels) ? $this->Channels : null;
    }
    /**
     * Set Channels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMarketing_AppealChannels $channels
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setChannels(\patest\StructType\RecordSetOfMarketing_AppealChannels $channels = null)
    {
        if (is_null($channels) || (is_array($channels) && empty($channels))) {
            unset($this->Channels);
        } else {
            $this->Channels = $channels;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DynamicAttributeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAttributeAction()
    {
        return isset($this->DynamicAttributeAction) ? $this->DynamicAttributeAction : null;
    }
    /**
     * Set DynamicAttributeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DynamicAttributeAction::valueIsValid()
     * @uses \patest\EnumType\DynamicAttributeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicAttributeAction
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setDynamicAttributeAction($dynamicAttributeAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DynamicAttributeAction::valueIsValid($dynamicAttributeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DynamicAttributeAction', is_array($dynamicAttributeAction) ? implode(', ', $dynamicAttributeAction) : var_export($dynamicAttributeAction, true), implode(', ', \patest\EnumType\DynamicAttributeAction::getValidValues())), __LINE__);
        }
        if (is_null($dynamicAttributeAction) || (is_array($dynamicAttributeAction) && empty($dynamicAttributeAction))) {
            unset($this->DynamicAttributeAction);
        } else {
            $this->DynamicAttributeAction = $dynamicAttributeAction;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get ElementTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElementTypeName()
    {
        return isset($this->ElementTypeName) ? $this->ElementTypeName : null;
    }
    /**
     * Set ElementTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $elementTypeName
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setElementTypeName($elementTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($elementTypeName) && !is_string($elementTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($elementTypeName, true), gettype($elementTypeName)), __LINE__);
        }
        if (is_null($elementTypeName) || (is_array($elementTypeName) && empty($elementTypeName))) {
            unset($this->ElementTypeName);
        } else {
            $this->ElementTypeName = $elementTypeName;
        }
        return $this;
    }
    /**
     * Get ExecutedAppealInProcess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutedAppealInProcess()
    {
        return isset($this->ExecutedAppealInProcess) ? $this->ExecutedAppealInProcess : null;
    }
    /**
     * Set ExecutedAppealInProcess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executedAppealInProcess
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setExecutedAppealInProcess($executedAppealInProcess = null)
    {
        // validation for constraint: string
        if (!is_null($executedAppealInProcess) && !is_string($executedAppealInProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executedAppealInProcess, true), gettype($executedAppealInProcess)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($executedAppealInProcess) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $executedAppealInProcess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($executedAppealInProcess, true)), __LINE__);
        }
        if (is_null($executedAppealInProcess) || (is_array($executedAppealInProcess) && empty($executedAppealInProcess))) {
            unset($this->ExecutedAppealInProcess);
        } else {
            $this->ExecutedAppealInProcess = $executedAppealInProcess;
        }
        return $this;
    }
    /**
     * Get GoalRevenue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getGoalRevenue()
    {
        return isset($this->GoalRevenue) ? $this->GoalRevenue : null;
    }
    /**
     * Set GoalRevenue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $goalRevenue
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setGoalRevenue($goalRevenue = null)
    {
        // validation for constraint: float
        if (!is_null($goalRevenue) && !(is_float($goalRevenue) || is_numeric($goalRevenue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($goalRevenue, true), gettype($goalRevenue)), __LINE__);
        }
        if (is_null($goalRevenue) || (is_array($goalRevenue) && empty($goalRevenue))) {
            unset($this->GoalRevenue);
        } else {
            $this->GoalRevenue = $goalRevenue;
        }
        return $this;
    }
    /**
     * Get IncludeManuallyAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeManuallyAttributes()
    {
        return isset($this->IncludeManuallyAttributes) ? $this->IncludeManuallyAttributes : null;
    }
    /**
     * Set IncludeManuallyAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeManuallyAttributes
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setIncludeManuallyAttributes($includeManuallyAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeManuallyAttributes) && !is_bool($includeManuallyAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeManuallyAttributes, true), gettype($includeManuallyAttributes)), __LINE__);
        }
        if (is_null($includeManuallyAttributes) || (is_array($includeManuallyAttributes) && empty($includeManuallyAttributes))) {
            unset($this->IncludeManuallyAttributes);
        } else {
            $this->IncludeManuallyAttributes = $includeManuallyAttributes;
        }
        return $this;
    }
    /**
     * Get LedgerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLedgerId()
    {
        return isset($this->LedgerId) ? $this->LedgerId : null;
    }
    /**
     * Set LedgerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ledgerId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setLedgerId($ledgerId = null)
    {
        // validation for constraint: string
        if (!is_null($ledgerId) && !is_string($ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ledgerId, true), gettype($ledgerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ledgerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ledgerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ledgerId, true)), __LINE__);
        }
        if (is_null($ledgerId) || (is_array($ledgerId) && empty($ledgerId))) {
            unset($this->LedgerId);
        } else {
            $this->LedgerId = $ledgerId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDefinitionId()
    {
        return isset($this->ProcessDefinitionId) ? $this->ProcessDefinitionId : null;
    }
    /**
     * Set ProcessDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDefinitionId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setProcessDefinitionId($processDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($processDefinitionId) && !is_string($processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDefinitionId, true), gettype($processDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processDefinitionId, true)), __LINE__);
        }
        if (is_null($processDefinitionId) || (is_array($processDefinitionId) && empty($processDefinitionId))) {
            unset($this->ProcessDefinitionId);
        } else {
            $this->ProcessDefinitionId = $processDefinitionId;
        }
        return $this;
    }
    /**
     * Get ProjectIdentifierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProjectIdentifierId()
    {
        return isset($this->ProjectIdentifierId) ? $this->ProjectIdentifierId : null;
    }
    /**
     * Set ProjectIdentifierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $projectIdentifierId
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setProjectIdentifierId($projectIdentifierId = null)
    {
        // validation for constraint: string
        if (!is_null($projectIdentifierId) && !is_string($projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($projectIdentifierId, true), gettype($projectIdentifierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($projectIdentifierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $projectIdentifierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($projectIdentifierId, true)), __LINE__);
        }
        if (is_null($projectIdentifierId) || (is_array($projectIdentifierId) && empty($projectIdentifierId))) {
            unset($this->ProjectIdentifierId);
        } else {
            $this->ProjectIdentifierId = $projectIdentifierId;
        }
        return $this;
    }
    /**
     * Get Provider value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProvider()
    {
        return isset($this->Provider) ? $this->Provider : null;
    }
    /**
     * Set Provider value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $provider
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        if (is_null($provider) || (is_array($provider) && empty($provider))) {
            unset($this->Provider);
        } else {
            $this->Provider = $provider;
        }
        return $this;
    }
    /**
     * Get ProviderSetup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSetup()
    {
        return isset($this->ProviderSetup) ? $this->ProviderSetup : null;
    }
    /**
     * Set ProviderSetup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSetup
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setProviderSetup($providerSetup = null)
    {
        // validation for constraint: string
        if (!is_null($providerSetup) && !is_string($providerSetup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSetup, true), gettype($providerSetup)), __LINE__);
        }
        if (is_null($providerSetup) || (is_array($providerSetup) && empty($providerSetup))) {
            unset($this->ProviderSetup);
        } else {
            $this->ProviderSetup = $providerSetup;
        }
        return $this;
    }
    /**
     * Get ProviderTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderTitle()
    {
        return isset($this->ProviderTitle) ? $this->ProviderTitle : null;
    }
    /**
     * Set ProviderTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerTitle
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setProviderTitle($providerTitle = null)
    {
        // validation for constraint: string
        if (!is_null($providerTitle) && !is_string($providerTitle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerTitle, true), gettype($providerTitle)), __LINE__);
        }
        if (is_null($providerTitle) || (is_array($providerTitle) && empty($providerTitle))) {
            unset($this->ProviderTitle);
        } else {
            $this->ProviderTitle = $providerTitle;
        }
        return $this;
    }
    /**
     * Get Schedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchedule()
    {
        return isset($this->Schedule) ? $this->Schedule : null;
    }
    /**
     * Set Schedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schedule
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setSchedule($schedule = null)
    {
        // validation for constraint: string
        if (!is_null($schedule) && !is_string($schedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schedule, true), gettype($schedule)), __LINE__);
        }
        if (is_null($schedule) || (is_array($schedule) && empty($schedule))) {
            unset($this->Schedule);
        } else {
            $this->Schedule = $schedule;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalCost
     * @return \patest\StructType\Marketing_Appeal
     */
    public function setTotalCost($totalCost = null)
    {
        // validation for constraint: float
        if (!is_null($totalCost) && !(is_float($totalCost) || is_numeric($totalCost))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCost, true), gettype($totalCost)), __LINE__);
        }
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
}
