<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LookupExternalAuthenticationDataByUser-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LookupExternalAuthenticationDataByUser-Request
 * @subpackage Structs
 */
class LookupExternalAuthenticationDataByUser_Request extends ExtensibleDataContract
{
    /**
     * The ExternalService
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalService;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for LookupExternalAuthenticationDataByUser-Request
     * @uses LookupExternalAuthenticationDataByUser_Request::setExternalService()
     * @uses LookupExternalAuthenticationDataByUser_Request::setUserId()
     * @param string $externalService
     * @param string $userId
     */
    public function __construct($externalService = null, $userId = null)
    {
        $this
            ->setExternalService($externalService)
            ->setUserId($userId);
    }
    /**
     * Get ExternalService value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalService()
    {
        return isset($this->ExternalService) ? $this->ExternalService : null;
    }
    /**
     * Set ExternalService value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalService
     * @return \patest\StructType\LookupExternalAuthenticationDataByUser_Request
     */
    public function setExternalService($externalService = null)
    {
        // validation for constraint: string
        if (!is_null($externalService) && !is_string($externalService)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalService, true), gettype($externalService)), __LINE__);
        }
        if (is_null($externalService) || (is_array($externalService) && empty($externalService))) {
            unset($this->ExternalService);
        } else {
            $this->ExternalService = $externalService;
        }
        return $this;
    }
    /**
     * Get UserId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->UserId;
    }
    /**
     * Set UserId value
     * @param string $userId
     * @return \patest\StructType\LookupExternalAuthenticationDataByUser_Request
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        $this->UserId = $userId;
        return $this;
    }
}
