<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LegacyFault StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LegacyFault
 * @subpackage Structs
 */
class LegacyFault extends BasicFault
{
    /**
     * The LegacyFaultCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegacyFaultCode;
    /**
     * The LegacyFaultDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegacyFaultDescription;
    /**
     * The LegacyFaultDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegacyFaultDetails;
    /**
     * The LegacyStackTrace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LegacyStackTrace;
    /**
     * Constructor method for LegacyFault
     * @uses LegacyFault::setLegacyFaultCode()
     * @uses LegacyFault::setLegacyFaultDescription()
     * @uses LegacyFault::setLegacyFaultDetails()
     * @uses LegacyFault::setLegacyStackTrace()
     * @param string $legacyFaultCode
     * @param string $legacyFaultDescription
     * @param string $legacyFaultDetails
     * @param string $legacyStackTrace
     */
    public function __construct($legacyFaultCode = null, $legacyFaultDescription = null, $legacyFaultDetails = null, $legacyStackTrace = null)
    {
        $this
            ->setLegacyFaultCode($legacyFaultCode)
            ->setLegacyFaultDescription($legacyFaultDescription)
            ->setLegacyFaultDetails($legacyFaultDetails)
            ->setLegacyStackTrace($legacyStackTrace);
    }
    /**
     * Get LegacyFaultCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegacyFaultCode()
    {
        return isset($this->LegacyFaultCode) ? $this->LegacyFaultCode : null;
    }
    /**
     * Set LegacyFaultCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legacyFaultCode
     * @return \patest\StructType\LegacyFault
     */
    public function setLegacyFaultCode($legacyFaultCode = null)
    {
        // validation for constraint: string
        if (!is_null($legacyFaultCode) && !is_string($legacyFaultCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legacyFaultCode, true), gettype($legacyFaultCode)), __LINE__);
        }
        if (is_null($legacyFaultCode) || (is_array($legacyFaultCode) && empty($legacyFaultCode))) {
            unset($this->LegacyFaultCode);
        } else {
            $this->LegacyFaultCode = $legacyFaultCode;
        }
        return $this;
    }
    /**
     * Get LegacyFaultDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegacyFaultDescription()
    {
        return isset($this->LegacyFaultDescription) ? $this->LegacyFaultDescription : null;
    }
    /**
     * Set LegacyFaultDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legacyFaultDescription
     * @return \patest\StructType\LegacyFault
     */
    public function setLegacyFaultDescription($legacyFaultDescription = null)
    {
        // validation for constraint: string
        if (!is_null($legacyFaultDescription) && !is_string($legacyFaultDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legacyFaultDescription, true), gettype($legacyFaultDescription)), __LINE__);
        }
        if (is_null($legacyFaultDescription) || (is_array($legacyFaultDescription) && empty($legacyFaultDescription))) {
            unset($this->LegacyFaultDescription);
        } else {
            $this->LegacyFaultDescription = $legacyFaultDescription;
        }
        return $this;
    }
    /**
     * Get LegacyFaultDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegacyFaultDetails()
    {
        return isset($this->LegacyFaultDetails) ? $this->LegacyFaultDetails : null;
    }
    /**
     * Set LegacyFaultDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legacyFaultDetails
     * @return \patest\StructType\LegacyFault
     */
    public function setLegacyFaultDetails($legacyFaultDetails = null)
    {
        // validation for constraint: string
        if (!is_null($legacyFaultDetails) && !is_string($legacyFaultDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legacyFaultDetails, true), gettype($legacyFaultDetails)), __LINE__);
        }
        if (is_null($legacyFaultDetails) || (is_array($legacyFaultDetails) && empty($legacyFaultDetails))) {
            unset($this->LegacyFaultDetails);
        } else {
            $this->LegacyFaultDetails = $legacyFaultDetails;
        }
        return $this;
    }
    /**
     * Get LegacyStackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLegacyStackTrace()
    {
        return isset($this->LegacyStackTrace) ? $this->LegacyStackTrace : null;
    }
    /**
     * Set LegacyStackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $legacyStackTrace
     * @return \patest\StructType\LegacyFault
     */
    public function setLegacyStackTrace($legacyStackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($legacyStackTrace) && !is_string($legacyStackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($legacyStackTrace, true), gettype($legacyStackTrace)), __LINE__);
        }
        if (is_null($legacyStackTrace) || (is_array($legacyStackTrace) && empty($legacyStackTrace))) {
            unset($this->LegacyStackTrace);
        } else {
            $this->LegacyStackTrace = $legacyStackTrace;
        }
        return $this;
    }
}
