<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InventoryPriceModifierDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InventoryPriceModifierDetails
 * @subpackage Structs
 */
class InventoryPriceModifierDetails extends AbstractStructBase
{
    /**
     * The CalculationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CalculationLevel;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValueType;
    /**
     * Constructor method for InventoryPriceModifierDetails
     * @uses InventoryPriceModifierDetails::setCalculationLevel()
     * @uses InventoryPriceModifierDetails::setType()
     * @uses InventoryPriceModifierDetails::setValueType()
     * @param string $calculationLevel
     * @param string $type
     * @param string $valueType
     */
    public function __construct($calculationLevel = null, $type = null, $valueType = null)
    {
        $this
            ->setCalculationLevel($calculationLevel)
            ->setType($type)
            ->setValueType($valueType);
    }
    /**
     * Get CalculationLevel value
     * @return string|null
     */
    public function getCalculationLevel()
    {
        return $this->CalculationLevel;
    }
    /**
     * Set CalculationLevel value
     * @uses \patest\EnumType\PriceModifierCalculationLevel::valueIsValid()
     * @uses \patest\EnumType\PriceModifierCalculationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $calculationLevel
     * @return \patest\StructType\InventoryPriceModifierDetails
     */
    public function setCalculationLevel($calculationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierCalculationLevel::valueIsValid($calculationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierCalculationLevel', is_array($calculationLevel) ? implode(', ', $calculationLevel) : var_export($calculationLevel, true), implode(', ', \patest\EnumType\PriceModifierCalculationLevel::getValidValues())), __LINE__);
        }
        $this->CalculationLevel = $calculationLevel;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\PriceModifierType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\InventoryPriceModifierDetails
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\PriceModifierType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get ValueType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValueType()
    {
        return isset($this->ValueType) ? $this->ValueType : null;
    }
    /**
     * Set ValueType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierValueType::valueIsValid()
     * @uses \patest\EnumType\PriceModifierValueType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $valueType
     * @return \patest\StructType\InventoryPriceModifierDetails
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierValueType::valueIsValid($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierValueType', is_array($valueType) ? implode(', ', $valueType) : var_export($valueType, true), implode(', ', \patest\EnumType\PriceModifierValueType::getValidValues())), __LINE__);
        }
        if (is_null($valueType) || (is_array($valueType) && empty($valueType))) {
            unset($this->ValueType);
        } else {
            $this->ValueType = $valueType;
        }
        return $this;
    }
}
