<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InstallmentDateInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InstallmentDateInfo
 * @subpackage Structs
 */
class InstallmentDateInfo extends AbstractStructBase
{
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DueDate;
    /**
     * The PastDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PastDue;
    /**
     * The PastDueMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PastDueMessage;
    /**
     * Constructor method for InstallmentDateInfo
     * @uses InstallmentDateInfo::setDueDate()
     * @uses InstallmentDateInfo::setPastDue()
     * @uses InstallmentDateInfo::setPastDueMessage()
     * @param string $dueDate
     * @param bool $pastDue
     * @param string $pastDueMessage
     */
    public function __construct($dueDate = null, $pastDue = null, $pastDueMessage = null)
    {
        $this
            ->setDueDate($dueDate)
            ->setPastDue($pastDue)
            ->setPastDueMessage($pastDueMessage);
    }
    /**
     * Get DueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \patest\StructType\InstallmentDateInfo
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get PastDue value
     * @return bool|null
     */
    public function getPastDue()
    {
        return $this->PastDue;
    }
    /**
     * Set PastDue value
     * @param bool $pastDue
     * @return \patest\StructType\InstallmentDateInfo
     */
    public function setPastDue($pastDue = null)
    {
        // validation for constraint: boolean
        if (!is_null($pastDue) && !is_bool($pastDue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pastDue, true), gettype($pastDue)), __LINE__);
        }
        $this->PastDue = $pastDue;
        return $this;
    }
    /**
     * Get PastDueMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPastDueMessage()
    {
        return isset($this->PastDueMessage) ? $this->PastDueMessage : null;
    }
    /**
     * Set PastDueMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pastDueMessage
     * @return \patest\StructType\InstallmentDateInfo
     */
    public function setPastDueMessage($pastDueMessage = null)
    {
        // validation for constraint: string
        if (!is_null($pastDueMessage) && !is_string($pastDueMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pastDueMessage, true), gettype($pastDueMessage)), __LINE__);
        }
        if (is_null($pastDueMessage) || (is_array($pastDueMessage) && empty($pastDueMessage))) {
            unset($this->PastDueMessage);
        } else {
            $this->PastDueMessage = $pastDueMessage;
        }
        return $this;
    }
}
