<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.NolockTranslationLog StructType
 * @subpackage Structs
 */
class Infra_NolockTranslationLog extends TenantIndependentPersistableEntity
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The InstallVersionsLogId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InstallVersionsLogId;
    /**
     * The IsRemoveNolock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRemoveNolock;
    /**
     * The IsSuccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSuccess;
    /**
     * The NewVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewVersion;
    /**
     * The ObjectName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectName;
    /**
     * The ObjectSchemaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectSchemaName;
    /**
     * The ObjectType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjectType;
    /**
     * The OldVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldVersion;
    /**
     * The TransformationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransformationDateTime;
    /**
     * Constructor method for Infra.NolockTranslationLog
     * @uses Infra_NolockTranslationLog::setError()
     * @uses Infra_NolockTranslationLog::setInstallVersionsLogId()
     * @uses Infra_NolockTranslationLog::setIsRemoveNolock()
     * @uses Infra_NolockTranslationLog::setIsSuccess()
     * @uses Infra_NolockTranslationLog::setNewVersion()
     * @uses Infra_NolockTranslationLog::setObjectName()
     * @uses Infra_NolockTranslationLog::setObjectSchemaName()
     * @uses Infra_NolockTranslationLog::setObjectType()
     * @uses Infra_NolockTranslationLog::setOldVersion()
     * @uses Infra_NolockTranslationLog::setTransformationDateTime()
     * @param string $error
     * @param int $installVersionsLogId
     * @param bool $isRemoveNolock
     * @param bool $isSuccess
     * @param string $newVersion
     * @param string $objectName
     * @param string $objectSchemaName
     * @param string $objectType
     * @param string $oldVersion
     * @param string $transformationDateTime
     */
    public function __construct($error = null, $installVersionsLogId = null, $isRemoveNolock = null, $isSuccess = null, $newVersion = null, $objectName = null, $objectSchemaName = null, $objectType = null, $oldVersion = null, $transformationDateTime = null)
    {
        $this
            ->setError($error)
            ->setInstallVersionsLogId($installVersionsLogId)
            ->setIsRemoveNolock($isRemoveNolock)
            ->setIsSuccess($isSuccess)
            ->setNewVersion($newVersion)
            ->setObjectName($objectName)
            ->setObjectSchemaName($objectSchemaName)
            ->setObjectType($objectType)
            ->setOldVersion($oldVersion)
            ->setTransformationDateTime($transformationDateTime);
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get InstallVersionsLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallVersionsLogId()
    {
        return isset($this->InstallVersionsLogId) ? $this->InstallVersionsLogId : null;
    }
    /**
     * Set InstallVersionsLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installVersionsLogId
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setInstallVersionsLogId($installVersionsLogId = null)
    {
        // validation for constraint: int
        if (!is_null($installVersionsLogId) && !(is_int($installVersionsLogId) || ctype_digit($installVersionsLogId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installVersionsLogId, true), gettype($installVersionsLogId)), __LINE__);
        }
        if (is_null($installVersionsLogId) || (is_array($installVersionsLogId) && empty($installVersionsLogId))) {
            unset($this->InstallVersionsLogId);
        } else {
            $this->InstallVersionsLogId = $installVersionsLogId;
        }
        return $this;
    }
    /**
     * Get IsRemoveNolock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRemoveNolock()
    {
        return isset($this->IsRemoveNolock) ? $this->IsRemoveNolock : null;
    }
    /**
     * Set IsRemoveNolock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRemoveNolock
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setIsRemoveNolock($isRemoveNolock = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRemoveNolock) && !is_bool($isRemoveNolock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRemoveNolock, true), gettype($isRemoveNolock)), __LINE__);
        }
        if (is_null($isRemoveNolock) || (is_array($isRemoveNolock) && empty($isRemoveNolock))) {
            unset($this->IsRemoveNolock);
        } else {
            $this->IsRemoveNolock = $isRemoveNolock;
        }
        return $this;
    }
    /**
     * Get IsSuccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSuccess()
    {
        return isset($this->IsSuccess) ? $this->IsSuccess : null;
    }
    /**
     * Set IsSuccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSuccess
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setIsSuccess($isSuccess = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSuccess) && !is_bool($isSuccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSuccess, true), gettype($isSuccess)), __LINE__);
        }
        if (is_null($isSuccess) || (is_array($isSuccess) && empty($isSuccess))) {
            unset($this->IsSuccess);
        } else {
            $this->IsSuccess = $isSuccess;
        }
        return $this;
    }
    /**
     * Get NewVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewVersion()
    {
        return isset($this->NewVersion) ? $this->NewVersion : null;
    }
    /**
     * Set NewVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newVersion
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setNewVersion($newVersion = null)
    {
        // validation for constraint: string
        if (!is_null($newVersion) && !is_string($newVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newVersion, true), gettype($newVersion)), __LINE__);
        }
        if (is_null($newVersion) || (is_array($newVersion) && empty($newVersion))) {
            unset($this->NewVersion);
        } else {
            $this->NewVersion = $newVersion;
        }
        return $this;
    }
    /**
     * Get ObjectName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectName()
    {
        return isset($this->ObjectName) ? $this->ObjectName : null;
    }
    /**
     * Set ObjectName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectName
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setObjectName($objectName = null)
    {
        // validation for constraint: string
        if (!is_null($objectName) && !is_string($objectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectName, true), gettype($objectName)), __LINE__);
        }
        if (is_null($objectName) || (is_array($objectName) && empty($objectName))) {
            unset($this->ObjectName);
        } else {
            $this->ObjectName = $objectName;
        }
        return $this;
    }
    /**
     * Get ObjectSchemaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectSchemaName()
    {
        return isset($this->ObjectSchemaName) ? $this->ObjectSchemaName : null;
    }
    /**
     * Set ObjectSchemaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectSchemaName
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setObjectSchemaName($objectSchemaName = null)
    {
        // validation for constraint: string
        if (!is_null($objectSchemaName) && !is_string($objectSchemaName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectSchemaName, true), gettype($objectSchemaName)), __LINE__);
        }
        if (is_null($objectSchemaName) || (is_array($objectSchemaName) && empty($objectSchemaName))) {
            unset($this->ObjectSchemaName);
        } else {
            $this->ObjectSchemaName = $objectSchemaName;
        }
        return $this;
    }
    /**
     * Get ObjectType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectType()
    {
        return isset($this->ObjectType) ? $this->ObjectType : null;
    }
    /**
     * Set ObjectType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectType
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setObjectType($objectType = null)
    {
        // validation for constraint: string
        if (!is_null($objectType) && !is_string($objectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objectType, true), gettype($objectType)), __LINE__);
        }
        if (is_null($objectType) || (is_array($objectType) && empty($objectType))) {
            unset($this->ObjectType);
        } else {
            $this->ObjectType = $objectType;
        }
        return $this;
    }
    /**
     * Get OldVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldVersion()
    {
        return isset($this->OldVersion) ? $this->OldVersion : null;
    }
    /**
     * Set OldVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldVersion
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setOldVersion($oldVersion = null)
    {
        // validation for constraint: string
        if (!is_null($oldVersion) && !is_string($oldVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldVersion, true), gettype($oldVersion)), __LINE__);
        }
        if (is_null($oldVersion) || (is_array($oldVersion) && empty($oldVersion))) {
            unset($this->OldVersion);
        } else {
            $this->OldVersion = $oldVersion;
        }
        return $this;
    }
    /**
     * Get TransformationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransformationDateTime()
    {
        return isset($this->TransformationDateTime) ? $this->TransformationDateTime : null;
    }
    /**
     * Set TransformationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transformationDateTime
     * @return \patest\StructType\Infra_NolockTranslationLog
     */
    public function setTransformationDateTime($transformationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($transformationDateTime) && !is_string($transformationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transformationDateTime, true), gettype($transformationDateTime)), __LINE__);
        }
        if (is_null($transformationDateTime) || (is_array($transformationDateTime) && empty($transformationDateTime))) {
            unset($this->TransformationDateTime);
        } else {
            $this->TransformationDateTime = $transformationDateTime;
        }
        return $this;
    }
}
