<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Infra.GlobalCounter StructType
 * @subpackage Structs
 */
class Infra_GlobalCounter extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Category;
    /**
     * The GlobalCounterType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Infra_GlobalCounterType
     */
    public $GlobalCounterType;
    /**
     * The GlobalCounterTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GlobalCounterTypeId;
    /**
     * The IsDefaultInOrgUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDefaultInOrgUnit;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceId;
    /**
     * The Service
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Service;
    /**
     * The SubCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubCategory;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Value;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Infra.GlobalCounter
     * @uses Infra_GlobalCounter::setCategory()
     * @uses Infra_GlobalCounter::setGlobalCounterType()
     * @uses Infra_GlobalCounter::setGlobalCounterTypeId()
     * @uses Infra_GlobalCounter::setIsDefaultInOrgUnit()
     * @uses Infra_GlobalCounter::setIsSystem()
     * @uses Infra_GlobalCounter::setOrganizationUnitId()
     * @uses Infra_GlobalCounter::setReferenceId()
     * @uses Infra_GlobalCounter::setService()
     * @uses Infra_GlobalCounter::setSubCategory()
     * @uses Infra_GlobalCounter::setValue()
     * @uses Infra_GlobalCounter::setVisibleBySubordinates()
     * @param string $category
     * @param \patest\StructType\Infra_GlobalCounterType $globalCounterType
     * @param string $globalCounterTypeId
     * @param bool $isDefaultInOrgUnit
     * @param bool $isSystem
     * @param string $organizationUnitId
     * @param string $referenceId
     * @param string $service
     * @param string $subCategory
     * @param int $value
     * @param bool $visibleBySubordinates
     */
    public function __construct($category = null, \patest\StructType\Infra_GlobalCounterType $globalCounterType = null, $globalCounterTypeId = null, $isDefaultInOrgUnit = null, $isSystem = null, $organizationUnitId = null, $referenceId = null, $service = null, $subCategory = null, $value = null, $visibleBySubordinates = null)
    {
        $this
            ->setCategory($category)
            ->setGlobalCounterType($globalCounterType)
            ->setGlobalCounterTypeId($globalCounterTypeId)
            ->setIsDefaultInOrgUnit($isDefaultInOrgUnit)
            ->setIsSystem($isSystem)
            ->setOrganizationUnitId($organizationUnitId)
            ->setReferenceId($referenceId)
            ->setService($service)
            ->setSubCategory($subCategory)
            ->setValue($value)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get Category value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategory()
    {
        return isset($this->Category) ? $this->Category : null;
    }
    /**
     * Set Category value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $category
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        if (is_null($category) || (is_array($category) && empty($category))) {
            unset($this->Category);
        } else {
            $this->Category = $category;
        }
        return $this;
    }
    /**
     * Get GlobalCounterType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Infra_GlobalCounterType|null
     */
    public function getGlobalCounterType()
    {
        return isset($this->GlobalCounterType) ? $this->GlobalCounterType : null;
    }
    /**
     * Set GlobalCounterType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Infra_GlobalCounterType $globalCounterType
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setGlobalCounterType(\patest\StructType\Infra_GlobalCounterType $globalCounterType = null)
    {
        if (is_null($globalCounterType) || (is_array($globalCounterType) && empty($globalCounterType))) {
            unset($this->GlobalCounterType);
        } else {
            $this->GlobalCounterType = $globalCounterType;
        }
        return $this;
    }
    /**
     * Get GlobalCounterTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGlobalCounterTypeId()
    {
        return isset($this->GlobalCounterTypeId) ? $this->GlobalCounterTypeId : null;
    }
    /**
     * Set GlobalCounterTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $globalCounterTypeId
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setGlobalCounterTypeId($globalCounterTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($globalCounterTypeId) && !is_string($globalCounterTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($globalCounterTypeId, true), gettype($globalCounterTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($globalCounterTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $globalCounterTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($globalCounterTypeId, true)), __LINE__);
        }
        if (is_null($globalCounterTypeId) || (is_array($globalCounterTypeId) && empty($globalCounterTypeId))) {
            unset($this->GlobalCounterTypeId);
        } else {
            $this->GlobalCounterTypeId = $globalCounterTypeId;
        }
        return $this;
    }
    /**
     * Get IsDefaultInOrgUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDefaultInOrgUnit()
    {
        return isset($this->IsDefaultInOrgUnit) ? $this->IsDefaultInOrgUnit : null;
    }
    /**
     * Set IsDefaultInOrgUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDefaultInOrgUnit
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setIsDefaultInOrgUnit($isDefaultInOrgUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDefaultInOrgUnit) && !is_bool($isDefaultInOrgUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDefaultInOrgUnit, true), gettype($isDefaultInOrgUnit)), __LINE__);
        }
        if (is_null($isDefaultInOrgUnit) || (is_array($isDefaultInOrgUnit) && empty($isDefaultInOrgUnit))) {
            unset($this->IsDefaultInOrgUnit);
        } else {
            $this->IsDefaultInOrgUnit = $isDefaultInOrgUnit;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get Service value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getService()
    {
        return isset($this->Service) ? $this->Service : null;
    }
    /**
     * Set Service value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $service
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setService($service = null)
    {
        // validation for constraint: string
        if (!is_null($service) && !is_string($service)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($service, true), gettype($service)), __LINE__);
        }
        if (is_null($service) || (is_array($service) && empty($service))) {
            unset($this->Service);
        } else {
            $this->Service = $service;
        }
        return $this;
    }
    /**
     * Get SubCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubCategory()
    {
        return isset($this->SubCategory) ? $this->SubCategory : null;
    }
    /**
     * Set SubCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subCategory
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setSubCategory($subCategory = null)
    {
        // validation for constraint: string
        if (!is_null($subCategory) && !is_string($subCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subCategory, true), gettype($subCategory)), __LINE__);
        }
        if (is_null($subCategory) || (is_array($subCategory) && empty($subCategory))) {
            unset($this->SubCategory);
        } else {
            $this->SubCategory = $subCategory;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $value
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setValue($value = null)
    {
        // validation for constraint: int
        if (!is_null($value) && !(is_int($value) || ctype_digit($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Infra_GlobalCounter
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
