<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HelpDesk.CommonBookingServiceRequest StructType
 * @subpackage Structs
 */
class HelpDesk_CommonBookingServiceRequest extends HelpDesk_ServiceRequest
{
    /**
     * The NeedParkingInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeedParkingInformation;
    /**
     * The NumberOfHearingImpaired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfHearingImpaired;
    /**
     * The NumberOfPeopleUsingWheelChairs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfPeopleUsingWheelChairs;
    /**
     * The NumberOfVisionImpaired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfVisionImpaired;
    /**
     * The NumberOfWheelChairsToBorrow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfWheelChairsToBorrow;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * Constructor method for HelpDesk.CommonBookingServiceRequest
     * @uses HelpDesk_CommonBookingServiceRequest::setNeedParkingInformation()
     * @uses HelpDesk_CommonBookingServiceRequest::setNumberOfHearingImpaired()
     * @uses HelpDesk_CommonBookingServiceRequest::setNumberOfPeopleUsingWheelChairs()
     * @uses HelpDesk_CommonBookingServiceRequest::setNumberOfVisionImpaired()
     * @uses HelpDesk_CommonBookingServiceRequest::setNumberOfWheelChairsToBorrow()
     * @uses HelpDesk_CommonBookingServiceRequest::setPriceLevelId()
     * @uses HelpDesk_CommonBookingServiceRequest::setPriceTypeId()
     * @param bool $needParkingInformation
     * @param int $numberOfHearingImpaired
     * @param int $numberOfPeopleUsingWheelChairs
     * @param int $numberOfVisionImpaired
     * @param int $numberOfWheelChairsToBorrow
     * @param string $priceLevelId
     * @param string $priceTypeId
     */
    public function __construct($needParkingInformation = null, $numberOfHearingImpaired = null, $numberOfPeopleUsingWheelChairs = null, $numberOfVisionImpaired = null, $numberOfWheelChairsToBorrow = null, $priceLevelId = null, $priceTypeId = null)
    {
        $this
            ->setNeedParkingInformation($needParkingInformation)
            ->setNumberOfHearingImpaired($numberOfHearingImpaired)
            ->setNumberOfPeopleUsingWheelChairs($numberOfPeopleUsingWheelChairs)
            ->setNumberOfVisionImpaired($numberOfVisionImpaired)
            ->setNumberOfWheelChairsToBorrow($numberOfWheelChairsToBorrow)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypeId($priceTypeId);
    }
    /**
     * Get NeedParkingInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeedParkingInformation()
    {
        return isset($this->NeedParkingInformation) ? $this->NeedParkingInformation : null;
    }
    /**
     * Set NeedParkingInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $needParkingInformation
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setNeedParkingInformation($needParkingInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($needParkingInformation) && !is_bool($needParkingInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needParkingInformation, true), gettype($needParkingInformation)), __LINE__);
        }
        if (is_null($needParkingInformation) || (is_array($needParkingInformation) && empty($needParkingInformation))) {
            unset($this->NeedParkingInformation);
        } else {
            $this->NeedParkingInformation = $needParkingInformation;
        }
        return $this;
    }
    /**
     * Get NumberOfHearingImpaired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfHearingImpaired()
    {
        return isset($this->NumberOfHearingImpaired) ? $this->NumberOfHearingImpaired : null;
    }
    /**
     * Set NumberOfHearingImpaired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfHearingImpaired
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setNumberOfHearingImpaired($numberOfHearingImpaired = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfHearingImpaired) && !(is_int($numberOfHearingImpaired) || ctype_digit($numberOfHearingImpaired))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfHearingImpaired, true), gettype($numberOfHearingImpaired)), __LINE__);
        }
        if (is_null($numberOfHearingImpaired) || (is_array($numberOfHearingImpaired) && empty($numberOfHearingImpaired))) {
            unset($this->NumberOfHearingImpaired);
        } else {
            $this->NumberOfHearingImpaired = $numberOfHearingImpaired;
        }
        return $this;
    }
    /**
     * Get NumberOfPeopleUsingWheelChairs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfPeopleUsingWheelChairs()
    {
        return isset($this->NumberOfPeopleUsingWheelChairs) ? $this->NumberOfPeopleUsingWheelChairs : null;
    }
    /**
     * Set NumberOfPeopleUsingWheelChairs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfPeopleUsingWheelChairs
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setNumberOfPeopleUsingWheelChairs($numberOfPeopleUsingWheelChairs = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfPeopleUsingWheelChairs) && !(is_int($numberOfPeopleUsingWheelChairs) || ctype_digit($numberOfPeopleUsingWheelChairs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfPeopleUsingWheelChairs, true), gettype($numberOfPeopleUsingWheelChairs)), __LINE__);
        }
        if (is_null($numberOfPeopleUsingWheelChairs) || (is_array($numberOfPeopleUsingWheelChairs) && empty($numberOfPeopleUsingWheelChairs))) {
            unset($this->NumberOfPeopleUsingWheelChairs);
        } else {
            $this->NumberOfPeopleUsingWheelChairs = $numberOfPeopleUsingWheelChairs;
        }
        return $this;
    }
    /**
     * Get NumberOfVisionImpaired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfVisionImpaired()
    {
        return isset($this->NumberOfVisionImpaired) ? $this->NumberOfVisionImpaired : null;
    }
    /**
     * Set NumberOfVisionImpaired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfVisionImpaired
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setNumberOfVisionImpaired($numberOfVisionImpaired = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfVisionImpaired) && !(is_int($numberOfVisionImpaired) || ctype_digit($numberOfVisionImpaired))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfVisionImpaired, true), gettype($numberOfVisionImpaired)), __LINE__);
        }
        if (is_null($numberOfVisionImpaired) || (is_array($numberOfVisionImpaired) && empty($numberOfVisionImpaired))) {
            unset($this->NumberOfVisionImpaired);
        } else {
            $this->NumberOfVisionImpaired = $numberOfVisionImpaired;
        }
        return $this;
    }
    /**
     * Get NumberOfWheelChairsToBorrow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfWheelChairsToBorrow()
    {
        return isset($this->NumberOfWheelChairsToBorrow) ? $this->NumberOfWheelChairsToBorrow : null;
    }
    /**
     * Set NumberOfWheelChairsToBorrow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfWheelChairsToBorrow
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setNumberOfWheelChairsToBorrow($numberOfWheelChairsToBorrow = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfWheelChairsToBorrow) && !(is_int($numberOfWheelChairsToBorrow) || ctype_digit($numberOfWheelChairsToBorrow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfWheelChairsToBorrow, true), gettype($numberOfWheelChairsToBorrow)), __LINE__);
        }
        if (is_null($numberOfWheelChairsToBorrow) || (is_array($numberOfWheelChairsToBorrow) && empty($numberOfWheelChairsToBorrow))) {
            unset($this->NumberOfWheelChairsToBorrow);
        } else {
            $this->NumberOfWheelChairsToBorrow = $numberOfWheelChairsToBorrow;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\HelpDesk_CommonBookingServiceRequest
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
}
