<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GlobalString StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GlobalString
 * @subpackage Structs
 */
class GlobalString extends AbstractStructBase
{
    /**
     * The GSEntry
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \patest\StructType\GSEntry[]
     */
    public $GSEntry;
    /**
     * Constructor method for GlobalString
     * @uses GlobalString::setGSEntry()
     * @param \patest\StructType\GSEntry[] $gSEntry
     */
    public function __construct(array $gSEntry = array())
    {
        $this
            ->setGSEntry($gSEntry);
    }
    /**
     * Get GSEntry value
     * @return \patest\StructType\GSEntry[]|null
     */
    public function getGSEntry()
    {
        return $this->GSEntry;
    }
    /**
     * This method is responsible for validating the values passed to the setGSEntry method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGSEntry method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGSEntryForArrayConstraintsFromSetGSEntry(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $globalStringGSEntryItem) {
            // validation for constraint: itemType
            if (!$globalStringGSEntryItem instanceof \patest\StructType\GSEntry) {
                $invalidValues[] = is_object($globalStringGSEntryItem) ? get_class($globalStringGSEntryItem) : sprintf('%s(%s)', gettype($globalStringGSEntryItem), var_export($globalStringGSEntryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GSEntry property can only contain items of type \patest\StructType\GSEntry, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GSEntry value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\GSEntry[] $gSEntry
     * @return \patest\StructType\GlobalString
     */
    public function setGSEntry(array $gSEntry = array())
    {
        // validation for constraint: array
        if ('' !== ($gSEntryArrayErrorMessage = self::validateGSEntryForArrayConstraintsFromSetGSEntry($gSEntry))) {
            throw new \InvalidArgumentException($gSEntryArrayErrorMessage, __LINE__);
        }
        $this->GSEntry = $gSEntry;
        return $this;
    }
    /**
     * Add item to GSEntry value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\GSEntry $item
     * @return \patest\StructType\GlobalString
     */
    public function addToGSEntry(\patest\StructType\GSEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\GSEntry) {
            throw new \InvalidArgumentException(sprintf('The GSEntry property can only contain items of type \patest\StructType\GSEntry, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GSEntry[] = $item;
        return $this;
    }
}
