<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.GiftVoucherProductItem StructType
 * @subpackage Structs
 */
class GiftVoucher_GiftVoucherProductItem extends GiftVoucher_Base
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CurrentRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrentRedemptionValue;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStatus;
    /**
     * The CurrentValidFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidFrom;
    /**
     * The CurrentValidUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentValidUntil;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EffectiveRedemptionValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $EffectiveRedemptionValue;
    /**
     * The EffectiveStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveStatus;
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * The GiftVoucherDefinitionType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherDefinitionType;
    /**
     * The GiftVoucherItemTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction
     */
    public $GiftVoucherItemTransactions;
    /**
     * The GiftVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVoucherNumber;
    /**
     * The IsMultipleRedeemable
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMultipleRedeemable;
    /**
     * The IsPrePrinted
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrePrinted;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PricingOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingOption;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for GiftVoucher.GiftVoucherProductItem
     * @uses GiftVoucher_GiftVoucherProductItem::setClientId()
     * @uses GiftVoucher_GiftVoucherProductItem::setCurrentRedemptionValue()
     * @uses GiftVoucher_GiftVoucherProductItem::setCurrentStatus()
     * @uses GiftVoucher_GiftVoucherProductItem::setCurrentValidFrom()
     * @uses GiftVoucher_GiftVoucherProductItem::setCurrentValidUntil()
     * @uses GiftVoucher_GiftVoucherProductItem::setDescription()
     * @uses GiftVoucher_GiftVoucherProductItem::setEffectiveRedemptionValue()
     * @uses GiftVoucher_GiftVoucherProductItem::setEffectiveStatus()
     * @uses GiftVoucher_GiftVoucherProductItem::setGiftVoucherDefinitionId()
     * @uses GiftVoucher_GiftVoucherProductItem::setGiftVoucherDefinitionType()
     * @uses GiftVoucher_GiftVoucherProductItem::setGiftVoucherItemTransactions()
     * @uses GiftVoucher_GiftVoucherProductItem::setGiftVoucherNumber()
     * @uses GiftVoucher_GiftVoucherProductItem::setIsMultipleRedeemable()
     * @uses GiftVoucher_GiftVoucherProductItem::setIsPrePrinted()
     * @uses GiftVoucher_GiftVoucherProductItem::setIsPrinting()
     * @uses GiftVoucher_GiftVoucherProductItem::setName()
     * @uses GiftVoucher_GiftVoucherProductItem::setOrganizationUnitId()
     * @uses GiftVoucher_GiftVoucherProductItem::setPricingOption()
     * @uses GiftVoucher_GiftVoucherProductItem::setPrintCount()
     * @uses GiftVoucher_GiftVoucherProductItem::setTransactionGuid()
     * @uses GiftVoucher_GiftVoucherProductItem::setVisibleBySubordinates()
     * @param string $clientId
     * @param float $currentRedemptionValue
     * @param string $currentStatus
     * @param string $currentValidFrom
     * @param string $currentValidUntil
     * @param \patest\StructType\GlobalString $description
     * @param float $effectiveRedemptionValue
     * @param string $effectiveStatus
     * @param string $giftVoucherDefinitionId
     * @param string $giftVoucherDefinitionType
     * @param \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemTransactions
     * @param string $giftVoucherNumber
     * @param bool $isMultipleRedeemable
     * @param bool $isPrePrinted
     * @param bool $isPrinting
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $pricingOption
     * @param int $printCount
     * @param string $transactionGuid
     * @param bool $visibleBySubordinates
     */
    public function __construct($clientId = null, $currentRedemptionValue = null, $currentStatus = null, $currentValidFrom = null, $currentValidUntil = null, \patest\StructType\GlobalString $description = null, $effectiveRedemptionValue = null, $effectiveStatus = null, $giftVoucherDefinitionId = null, $giftVoucherDefinitionType = null, \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemTransactions = null, $giftVoucherNumber = null, $isMultipleRedeemable = null, $isPrePrinted = null, $isPrinting = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $pricingOption = null, $printCount = null, $transactionGuid = null, $visibleBySubordinates = null)
    {
        $this
            ->setClientId($clientId)
            ->setCurrentRedemptionValue($currentRedemptionValue)
            ->setCurrentStatus($currentStatus)
            ->setCurrentValidFrom($currentValidFrom)
            ->setCurrentValidUntil($currentValidUntil)
            ->setDescription($description)
            ->setEffectiveRedemptionValue($effectiveRedemptionValue)
            ->setEffectiveStatus($effectiveStatus)
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId)
            ->setGiftVoucherDefinitionType($giftVoucherDefinitionType)
            ->setGiftVoucherItemTransactions($giftVoucherItemTransactions)
            ->setGiftVoucherNumber($giftVoucherNumber)
            ->setIsMultipleRedeemable($isMultipleRedeemable)
            ->setIsPrePrinted($isPrePrinted)
            ->setIsPrinting($isPrinting)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPricingOption($pricingOption)
            ->setPrintCount($printCount)
            ->setTransactionGuid($transactionGuid)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CurrentRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrentRedemptionValue()
    {
        return isset($this->CurrentRedemptionValue) ? $this->CurrentRedemptionValue : null;
    }
    /**
     * Set CurrentRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currentRedemptionValue
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setCurrentRedemptionValue($currentRedemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($currentRedemptionValue) && !(is_float($currentRedemptionValue) || is_numeric($currentRedemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currentRedemptionValue, true), gettype($currentRedemptionValue)), __LINE__);
        }
        if (is_null($currentRedemptionValue) || (is_array($currentRedemptionValue) && empty($currentRedemptionValue))) {
            unset($this->CurrentRedemptionValue);
        } else {
            $this->CurrentRedemptionValue = $currentRedemptionValue;
        }
        return $this;
    }
    /**
     * Get CurrentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return isset($this->CurrentStatus) ? $this->CurrentStatus : null;
    }
    /**
     * Set CurrentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($currentStatus) ? implode(', ', $currentStatus) : var_export($currentStatus, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentStatus) || (is_array($currentStatus) && empty($currentStatus))) {
            unset($this->CurrentStatus);
        } else {
            $this->CurrentStatus = $currentStatus;
        }
        return $this;
    }
    /**
     * Get CurrentValidFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidFrom()
    {
        return isset($this->CurrentValidFrom) ? $this->CurrentValidFrom : null;
    }
    /**
     * Set CurrentValidFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidFrom
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setCurrentValidFrom($currentValidFrom = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidFrom) && !is_string($currentValidFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidFrom, true), gettype($currentValidFrom)), __LINE__);
        }
        if (is_null($currentValidFrom) || (is_array($currentValidFrom) && empty($currentValidFrom))) {
            unset($this->CurrentValidFrom);
        } else {
            $this->CurrentValidFrom = $currentValidFrom;
        }
        return $this;
    }
    /**
     * Get CurrentValidUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentValidUntil()
    {
        return isset($this->CurrentValidUntil) ? $this->CurrentValidUntil : null;
    }
    /**
     * Set CurrentValidUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentValidUntil
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setCurrentValidUntil($currentValidUntil = null)
    {
        // validation for constraint: string
        if (!is_null($currentValidUntil) && !is_string($currentValidUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentValidUntil, true), gettype($currentValidUntil)), __LINE__);
        }
        if (is_null($currentValidUntil) || (is_array($currentValidUntil) && empty($currentValidUntil))) {
            unset($this->CurrentValidUntil);
        } else {
            $this->CurrentValidUntil = $currentValidUntil;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveRedemptionValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEffectiveRedemptionValue()
    {
        return isset($this->EffectiveRedemptionValue) ? $this->EffectiveRedemptionValue : null;
    }
    /**
     * Set EffectiveRedemptionValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $effectiveRedemptionValue
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setEffectiveRedemptionValue($effectiveRedemptionValue = null)
    {
        // validation for constraint: float
        if (!is_null($effectiveRedemptionValue) && !(is_float($effectiveRedemptionValue) || is_numeric($effectiveRedemptionValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($effectiveRedemptionValue, true), gettype($effectiveRedemptionValue)), __LINE__);
        }
        if (is_null($effectiveRedemptionValue) || (is_array($effectiveRedemptionValue) && empty($effectiveRedemptionValue))) {
            unset($this->EffectiveRedemptionValue);
        } else {
            $this->EffectiveRedemptionValue = $effectiveRedemptionValue;
        }
        return $this;
    }
    /**
     * Get EffectiveStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveStatus()
    {
        return isset($this->EffectiveStatus) ? $this->EffectiveStatus : null;
    }
    /**
     * Set EffectiveStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherStatus::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $effectiveStatus
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setEffectiveStatus($effectiveStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherStatus::valueIsValid($effectiveStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherStatus', is_array($effectiveStatus) ? implode(', ', $effectiveStatus) : var_export($effectiveStatus, true), implode(', ', \patest\EnumType\GiftVoucherStatus::getValidValues())), __LINE__);
        }
        if (is_null($effectiveStatus) || (is_array($effectiveStatus) && empty($effectiveStatus))) {
            unset($this->EffectiveStatus);
        } else {
            $this->EffectiveStatus = $effectiveStatus;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return isset($this->GiftVoucherDefinitionId) ? $this->GiftVoucherDefinitionId : null;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        if (is_null($giftVoucherDefinitionId) || (is_array($giftVoucherDefinitionId) && empty($giftVoucherDefinitionId))) {
            unset($this->GiftVoucherDefinitionId);
        } else {
            $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        }
        return $this;
    }
    /**
     * Get GiftVoucherDefinitionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherDefinitionType()
    {
        return isset($this->GiftVoucherDefinitionType) ? $this->GiftVoucherDefinitionType : null;
    }
    /**
     * Set GiftVoucherDefinitionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GiftVoucherType::valueIsValid()
     * @uses \patest\EnumType\GiftVoucherType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftVoucherDefinitionType
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setGiftVoucherDefinitionType($giftVoucherDefinitionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GiftVoucherType::valueIsValid($giftVoucherDefinitionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GiftVoucherType', is_array($giftVoucherDefinitionType) ? implode(', ', $giftVoucherDefinitionType) : var_export($giftVoucherDefinitionType, true), implode(', ', \patest\EnumType\GiftVoucherType::getValidValues())), __LINE__);
        }
        if (is_null($giftVoucherDefinitionType) || (is_array($giftVoucherDefinitionType) && empty($giftVoucherDefinitionType))) {
            unset($this->GiftVoucherDefinitionType);
        } else {
            $this->GiftVoucherDefinitionType = $giftVoucherDefinitionType;
        }
        return $this;
    }
    /**
     * Get GiftVoucherItemTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction|null
     */
    public function getGiftVoucherItemTransactions()
    {
        return isset($this->GiftVoucherItemTransactions) ? $this->GiftVoucherItemTransactions : null;
    }
    /**
     * Set GiftVoucherItemTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemTransactions
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setGiftVoucherItemTransactions(\patest\StructType\RecordSetOfGiftVoucher_GiftVoucherItemTransaction $giftVoucherItemTransactions = null)
    {
        if (is_null($giftVoucherItemTransactions) || (is_array($giftVoucherItemTransactions) && empty($giftVoucherItemTransactions))) {
            unset($this->GiftVoucherItemTransactions);
        } else {
            $this->GiftVoucherItemTransactions = $giftVoucherItemTransactions;
        }
        return $this;
    }
    /**
     * Get GiftVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherNumber()
    {
        return isset($this->GiftVoucherNumber) ? $this->GiftVoucherNumber : null;
    }
    /**
     * Set GiftVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherNumber
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setGiftVoucherNumber($giftVoucherNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherNumber) && !is_string($giftVoucherNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherNumber, true), gettype($giftVoucherNumber)), __LINE__);
        }
        if (is_null($giftVoucherNumber) || (is_array($giftVoucherNumber) && empty($giftVoucherNumber))) {
            unset($this->GiftVoucherNumber);
        } else {
            $this->GiftVoucherNumber = $giftVoucherNumber;
        }
        return $this;
    }
    /**
     * Get IsMultipleRedeemable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMultipleRedeemable()
    {
        return isset($this->IsMultipleRedeemable) ? $this->IsMultipleRedeemable : null;
    }
    /**
     * Set IsMultipleRedeemable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMultipleRedeemable
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setIsMultipleRedeemable($isMultipleRedeemable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMultipleRedeemable) && !is_bool($isMultipleRedeemable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMultipleRedeemable, true), gettype($isMultipleRedeemable)), __LINE__);
        }
        if (is_null($isMultipleRedeemable) || (is_array($isMultipleRedeemable) && empty($isMultipleRedeemable))) {
            unset($this->IsMultipleRedeemable);
        } else {
            $this->IsMultipleRedeemable = $isMultipleRedeemable;
        }
        return $this;
    }
    /**
     * Get IsPrePrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrePrinted()
    {
        return isset($this->IsPrePrinted) ? $this->IsPrePrinted : null;
    }
    /**
     * Set IsPrePrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrePrinted
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setIsPrePrinted($isPrePrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrePrinted) && !is_bool($isPrePrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrePrinted, true), gettype($isPrePrinted)), __LINE__);
        }
        if (is_null($isPrePrinted) || (is_array($isPrePrinted) && empty($isPrePrinted))) {
            unset($this->IsPrePrinted);
        } else {
            $this->IsPrePrinted = $isPrePrinted;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PricingOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingOption()
    {
        return isset($this->PricingOption) ? $this->PricingOption : null;
    }
    /**
     * Set PricingOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingOption::valueIsValid()
     * @uses \patest\EnumType\PricingOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingOption
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setPricingOption($pricingOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingOption::valueIsValid($pricingOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingOption', is_array($pricingOption) ? implode(', ', $pricingOption) : var_export($pricingOption, true), implode(', ', \patest\EnumType\PricingOption::getValidValues())), __LINE__);
        }
        if (is_null($pricingOption) || (is_array($pricingOption) && empty($pricingOption))) {
            unset($this->PricingOption);
        } else {
            $this->PricingOption = $pricingOption;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\GiftVoucher_GiftVoucherProductItem
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
