<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GiftVoucher.CardLoadingProductDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GiftVoucher.CardLoadingProductDescription
 * @subpackage Structs
 */
class GiftVoucher_CardLoadingProductDescription extends AnyEntity
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Elements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfGiftVoucher_ProgramElement
     */
    public $Elements;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProgramKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProgramKey;
    /**
     * The ProgramKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProgramKind;
    /**
     * The RedemptionKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RedemptionKind;
    /**
     * Constructor method for GiftVoucher.CardLoadingProductDescription
     * @uses GiftVoucher_CardLoadingProductDescription::setDescription()
     * @uses GiftVoucher_CardLoadingProductDescription::setElements()
     * @uses GiftVoucher_CardLoadingProductDescription::setId()
     * @uses GiftVoucher_CardLoadingProductDescription::setName()
     * @uses GiftVoucher_CardLoadingProductDescription::setOrganizationUnitId()
     * @uses GiftVoucher_CardLoadingProductDescription::setProgramKey()
     * @uses GiftVoucher_CardLoadingProductDescription::setProgramKind()
     * @uses GiftVoucher_CardLoadingProductDescription::setRedemptionKind()
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\RecordSetOfGiftVoucher_ProgramElement $elements
     * @param string $id
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param string $programKey
     * @param string $programKind
     * @param string $redemptionKind
     */
    public function __construct(\patest\StructType\GlobalString $description = null, \patest\StructType\RecordSetOfGiftVoucher_ProgramElement $elements = null, $id = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, $programKey = null, $programKind = null, $redemptionKind = null)
    {
        $this
            ->setDescription($description)
            ->setElements($elements)
            ->setId($id)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProgramKey($programKey)
            ->setProgramKind($programKind)
            ->setRedemptionKind($redemptionKind);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Elements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfGiftVoucher_ProgramElement|null
     */
    public function getElements()
    {
        return isset($this->Elements) ? $this->Elements : null;
    }
    /**
     * Set Elements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfGiftVoucher_ProgramElement $elements
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setElements(\patest\StructType\RecordSetOfGiftVoucher_ProgramElement $elements = null)
    {
        if (is_null($elements) || (is_array($elements) && empty($elements))) {
            unset($this->Elements);
        } else {
            $this->Elements = $elements;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProgramKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgramKey()
    {
        return isset($this->ProgramKey) ? $this->ProgramKey : null;
    }
    /**
     * Set ProgramKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $programKey
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setProgramKey($programKey = null)
    {
        // validation for constraint: string
        if (!is_null($programKey) && !is_string($programKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($programKey, true), gettype($programKey)), __LINE__);
        }
        if (is_null($programKey) || (is_array($programKey) && empty($programKey))) {
            unset($this->ProgramKey);
        } else {
            $this->ProgramKey = $programKey;
        }
        return $this;
    }
    /**
     * Get ProgramKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProgramKind()
    {
        return isset($this->ProgramKind) ? $this->ProgramKind : null;
    }
    /**
     * Set ProgramKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProgramKind::valueIsValid()
     * @uses \patest\EnumType\ProgramKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $programKind
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setProgramKind($programKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProgramKind::valueIsValid($programKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProgramKind', is_array($programKind) ? implode(', ', $programKind) : var_export($programKind, true), implode(', ', \patest\EnumType\ProgramKind::getValidValues())), __LINE__);
        }
        if (is_null($programKind) || (is_array($programKind) && empty($programKind))) {
            unset($this->ProgramKind);
        } else {
            $this->ProgramKind = $programKind;
        }
        return $this;
    }
    /**
     * Get RedemptionKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedemptionKind()
    {
        return isset($this->RedemptionKind) ? $this->RedemptionKind : null;
    }
    /**
     * Set RedemptionKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RedemptionKind::valueIsValid()
     * @uses \patest\EnumType\RedemptionKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $redemptionKind
     * @return \patest\StructType\GiftVoucher_CardLoadingProductDescription
     */
    public function setRedemptionKind($redemptionKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RedemptionKind::valueIsValid($redemptionKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RedemptionKind', is_array($redemptionKind) ? implode(', ', $redemptionKind) : var_export($redemptionKind, true), implode(', ', \patest\EnumType\RedemptionKind::getValidValues())), __LINE__);
        }
        if (is_null($redemptionKind) || (is_array($redemptionKind) && empty($redemptionKind))) {
            unset($this->RedemptionKind);
        } else {
            $this->RedemptionKind = $redemptionKind;
        }
        return $this;
    }
}
