<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTicketsToManageRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketsToManageRequest
 * @subpackage Structs
 */
class GetTicketsToManageRequest extends AbstractStructBase
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $Action;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The FromTicketLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromTicketLocalId;
    /**
     * The IncludeNfc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeNfc;
    /**
     * The IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
    /**
     * The IncludeTicketsOfSpecificRelationshipType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IncludeTicketsOfSpecificRelationshipType;
    /**
     * The IncludeTicketsOfStronglyConnectedOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeTicketsOfStronglyConnectedOwners;
    /**
     * The MaxPageSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxPageSize;
    /**
     * The StronglyRelatedClientsMaxAgeFilterForTicketList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StronglyRelatedClientsMaxAgeFilterForTicketList;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketIds;
    /**
     * Constructor method for GetTicketsToManageRequest
     * @uses GetTicketsToManageRequest::setAction()
     * @uses GetTicketsToManageRequest::setClientId()
     * @uses GetTicketsToManageRequest::setEventIds()
     * @uses GetTicketsToManageRequest::setFromTicketLocalId()
     * @uses GetTicketsToManageRequest::setIncludeNfc()
     * @uses GetTicketsToManageRequest::setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
     * @uses GetTicketsToManageRequest::setIncludeTicketsOfSpecificRelationshipType()
     * @uses GetTicketsToManageRequest::setIncludeTicketsOfStronglyConnectedOwners()
     * @uses GetTicketsToManageRequest::setMaxPageSize()
     * @uses GetTicketsToManageRequest::setStronglyRelatedClientsMaxAgeFilterForTicketList()
     * @uses GetTicketsToManageRequest::setTicketIds()
     * @param string[] $action
     * @param string $clientId
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param int $fromTicketLocalId
     * @param bool $includeNfc
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @param string $includeTicketsOfSpecificRelationshipType
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @param int $maxPageSize
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     */
    public function __construct(array $action = array(), $clientId = null, \patest\ArrayType\ArrayOfguid $eventIds = null, $fromTicketLocalId = null, $includeNfc = null, $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null, $includeTicketsOfSpecificRelationshipType = null, $includeTicketsOfStronglyConnectedOwners = null, $maxPageSize = null, $stronglyRelatedClientsMaxAgeFilterForTicketList = null, \patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        $this
            ->setAction($action)
            ->setClientId($clientId)
            ->setEventIds($eventIds)
            ->setFromTicketLocalId($fromTicketLocalId)
            ->setIncludeNfc($includeNfc)
            ->setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)
            ->setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType)
            ->setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners)
            ->setMaxPageSize($maxPageSize)
            ->setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList)
            ->setTicketIds($ticketIds);
    }
    /**
     * Get Action value
     * @return string[]|null
     */
    public function getAction()
    {
        return $this->Action;
    }
    /**
     * This method is responsible for validating the values passed to the setAction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateActionForArrayConstraintsFromSetAction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getTicketsToManageRequestActionItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\GetTicketsToManageRequestAction::valueIsValid($getTicketsToManageRequestActionItem)) {
                $invalidValues[] = is_object($getTicketsToManageRequestActionItem) ? get_class($getTicketsToManageRequestActionItem) : sprintf('%s(%s)', gettype($getTicketsToManageRequestActionItem), var_export($getTicketsToManageRequestActionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GetTicketsToManageRequestAction', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\GetTicketsToManageRequestAction::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Action value
     * @uses \patest\EnumType\GetTicketsToManageRequestAction::valueIsValid()
     * @uses \patest\EnumType\GetTicketsToManageRequestAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $action
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setAction(array $action = array())
    {
        // validation for constraint: list
        if ('' !== ($actionArrayErrorMessage = self::validateActionForArrayConstraintsFromSetAction($action))) {
            throw new \InvalidArgumentException($actionArrayErrorMessage, __LINE__);
        }
        $this->Action = is_array($action) ? implode(' ', $action) : null;
        return $this;
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get FromTicketLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromTicketLocalId()
    {
        return isset($this->FromTicketLocalId) ? $this->FromTicketLocalId : null;
    }
    /**
     * Set FromTicketLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromTicketLocalId
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setFromTicketLocalId($fromTicketLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($fromTicketLocalId) && !(is_int($fromTicketLocalId) || ctype_digit($fromTicketLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromTicketLocalId, true), gettype($fromTicketLocalId)), __LINE__);
        }
        if (is_null($fromTicketLocalId) || (is_array($fromTicketLocalId) && empty($fromTicketLocalId))) {
            unset($this->FromTicketLocalId);
        } else {
            $this->FromTicketLocalId = $fromTicketLocalId;
        }
        return $this;
    }
    /**
     * Get IncludeNfc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeNfc()
    {
        return isset($this->IncludeNfc) ? $this->IncludeNfc : null;
    }
    /**
     * Set IncludeNfc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeNfc
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setIncludeNfc($includeNfc = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeNfc) && !is_bool($includeNfc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeNfc, true), gettype($includeNfc)), __LINE__);
        }
        if (is_null($includeNfc) || (is_array($includeNfc) && empty($includeNfc))) {
            unset($this->IncludeNfc);
        } else {
            $this->IncludeNfc = $includeNfc;
        }
        return $this;
    }
    /**
     * Get IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged()
    {
        return isset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged) ? $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged : null;
    }
    /**
     * Set IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setIncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && !is_bool($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged, true), gettype($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged)), __LINE__);
        }
        if (is_null($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) || (is_array($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged) && empty($includePurchasedByClientNonForwardedOwnedByRelatedUnderaged))) {
            unset($this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged);
        } else {
            $this->IncludePurchasedByClientNonForwardedOwnedByRelatedUnderaged = $includePurchasedByClientNonForwardedOwnedByRelatedUnderaged;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfSpecificRelationshipType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeTicketsOfSpecificRelationshipType()
    {
        return isset($this->IncludeTicketsOfSpecificRelationshipType) ? $this->IncludeTicketsOfSpecificRelationshipType : null;
    }
    /**
     * Set IncludeTicketsOfSpecificRelationshipType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includeTicketsOfSpecificRelationshipType
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setIncludeTicketsOfSpecificRelationshipType($includeTicketsOfSpecificRelationshipType = null)
    {
        // validation for constraint: string
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !is_string($includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeTicketsOfSpecificRelationshipType, true), gettype($includeTicketsOfSpecificRelationshipType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($includeTicketsOfSpecificRelationshipType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $includeTicketsOfSpecificRelationshipType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($includeTicketsOfSpecificRelationshipType, true)), __LINE__);
        }
        if (is_null($includeTicketsOfSpecificRelationshipType) || (is_array($includeTicketsOfSpecificRelationshipType) && empty($includeTicketsOfSpecificRelationshipType))) {
            unset($this->IncludeTicketsOfSpecificRelationshipType);
        } else {
            $this->IncludeTicketsOfSpecificRelationshipType = $includeTicketsOfSpecificRelationshipType;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsOfStronglyConnectedOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeTicketsOfStronglyConnectedOwners()
    {
        return isset($this->IncludeTicketsOfStronglyConnectedOwners) ? $this->IncludeTicketsOfStronglyConnectedOwners : null;
    }
    /**
     * Set IncludeTicketsOfStronglyConnectedOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeTicketsOfStronglyConnectedOwners
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setIncludeTicketsOfStronglyConnectedOwners($includeTicketsOfStronglyConnectedOwners = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTicketsOfStronglyConnectedOwners) && !is_bool($includeTicketsOfStronglyConnectedOwners)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTicketsOfStronglyConnectedOwners, true), gettype($includeTicketsOfStronglyConnectedOwners)), __LINE__);
        }
        if (is_null($includeTicketsOfStronglyConnectedOwners) || (is_array($includeTicketsOfStronglyConnectedOwners) && empty($includeTicketsOfStronglyConnectedOwners))) {
            unset($this->IncludeTicketsOfStronglyConnectedOwners);
        } else {
            $this->IncludeTicketsOfStronglyConnectedOwners = $includeTicketsOfStronglyConnectedOwners;
        }
        return $this;
    }
    /**
     * Get MaxPageSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxPageSize()
    {
        return isset($this->MaxPageSize) ? $this->MaxPageSize : null;
    }
    /**
     * Set MaxPageSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxPageSize
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setMaxPageSize($maxPageSize = null)
    {
        // validation for constraint: int
        if (!is_null($maxPageSize) && !(is_int($maxPageSize) || ctype_digit($maxPageSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxPageSize, true), gettype($maxPageSize)), __LINE__);
        }
        if (is_null($maxPageSize) || (is_array($maxPageSize) && empty($maxPageSize))) {
            unset($this->MaxPageSize);
        } else {
            $this->MaxPageSize = $maxPageSize;
        }
        return $this;
    }
    /**
     * Get StronglyRelatedClientsMaxAgeFilterForTicketList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStronglyRelatedClientsMaxAgeFilterForTicketList()
    {
        return isset($this->StronglyRelatedClientsMaxAgeFilterForTicketList) ? $this->StronglyRelatedClientsMaxAgeFilterForTicketList : null;
    }
    /**
     * Set StronglyRelatedClientsMaxAgeFilterForTicketList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stronglyRelatedClientsMaxAgeFilterForTicketList
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setStronglyRelatedClientsMaxAgeFilterForTicketList($stronglyRelatedClientsMaxAgeFilterForTicketList = null)
    {
        // validation for constraint: int
        if (!is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) && !(is_int($stronglyRelatedClientsMaxAgeFilterForTicketList) || ctype_digit($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stronglyRelatedClientsMaxAgeFilterForTicketList, true), gettype($stronglyRelatedClientsMaxAgeFilterForTicketList)), __LINE__);
        }
        if (is_null($stronglyRelatedClientsMaxAgeFilterForTicketList) || (is_array($stronglyRelatedClientsMaxAgeFilterForTicketList) && empty($stronglyRelatedClientsMaxAgeFilterForTicketList))) {
            unset($this->StronglyRelatedClientsMaxAgeFilterForTicketList);
        } else {
            $this->StronglyRelatedClientsMaxAgeFilterForTicketList = $stronglyRelatedClientsMaxAgeFilterForTicketList;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketIds
     * @return \patest\StructType\GetTicketsToManageRequest
     */
    public function setTicketIds(\patest\ArrayType\ArrayOfguid $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
}
