<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTicketViewConfigurationImagesByImageTypeRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetTicketViewConfigurationImagesByImageTypeRequest
 * @subpackage Structs
 */
class GetTicketViewConfigurationImagesByImageTypeRequest extends AbstractStructBase
{
    /**
     * The FilterByImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FilterByImageType;
    /**
     * The FilterByIsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterByIsHidden;
    /**
     * Constructor method for GetTicketViewConfigurationImagesByImageTypeRequest
     * @uses GetTicketViewConfigurationImagesByImageTypeRequest::setFilterByImageType()
     * @uses GetTicketViewConfigurationImagesByImageTypeRequest::setFilterByIsHidden()
     * @param string $filterByImageType
     * @param bool $filterByIsHidden
     */
    public function __construct($filterByImageType = null, $filterByIsHidden = null)
    {
        $this
            ->setFilterByImageType($filterByImageType)
            ->setFilterByIsHidden($filterByIsHidden);
    }
    /**
     * Get FilterByImageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilterByImageType()
    {
        return isset($this->FilterByImageType) ? $this->FilterByImageType : null;
    }
    /**
     * Set FilterByImageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketViewConfigurationImageType::valueIsValid()
     * @uses \patest\EnumType\TicketViewConfigurationImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $filterByImageType
     * @return \patest\StructType\GetTicketViewConfigurationImagesByImageTypeRequest
     */
    public function setFilterByImageType($filterByImageType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewConfigurationImageType::valueIsValid($filterByImageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewConfigurationImageType', is_array($filterByImageType) ? implode(', ', $filterByImageType) : var_export($filterByImageType, true), implode(', ', \patest\EnumType\TicketViewConfigurationImageType::getValidValues())), __LINE__);
        }
        if (is_null($filterByImageType) || (is_array($filterByImageType) && empty($filterByImageType))) {
            unset($this->FilterByImageType);
        } else {
            $this->FilterByImageType = $filterByImageType;
        }
        return $this;
    }
    /**
     * Get FilterByIsHidden value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterByIsHidden()
    {
        return isset($this->FilterByIsHidden) ? $this->FilterByIsHidden : null;
    }
    /**
     * Set FilterByIsHidden value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterByIsHidden
     * @return \patest\StructType\GetTicketViewConfigurationImagesByImageTypeRequest
     */
    public function setFilterByIsHidden($filterByIsHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByIsHidden) && !is_bool($filterByIsHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterByIsHidden, true), gettype($filterByIsHidden)), __LINE__);
        }
        if (is_null($filterByIsHidden) || (is_array($filterByIsHidden) && empty($filterByIsHidden))) {
            unset($this->FilterByIsHidden);
        } else {
            $this->FilterByIsHidden = $filterByIsHidden;
        }
        return $this;
    }
}
