<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSeatToolTipInfo-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetSeatToolTipInfo-Response
 * @subpackage Structs
 */
class GetSeatToolTipInfo_Response extends ExtensibleDataContract
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The CustomerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PersonName
     */
    public $CustomerName;
    /**
     * The RelatedSeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $RelatedSeatIds;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The HeldForInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HeldForInfo;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesName;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerName;
    /**
     * The Pricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventPricingDescription
     */
    public $Pricing;
    /**
     * The SeatInventoryDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatInventoryDetails
     */
    public $SeatInventoryDetails;
    /**
     * The ResaleRequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleRequestDate;
    /**
     * The SessionInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatTooltipSessionInfo
     */
    public $SessionInfo;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * The SeatTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatTypeId;
    /**
     * The SeatTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeName;
    /**
     * The SeatTypeNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeNote;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsResale;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * The Allocations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $Allocations;
    /**
     * The CustomProperty1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty1;
    /**
     * The CustomProperty2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty2;
    /**
     * The CustomProperty3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty3;
    /**
     * The CustomProperty4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty4;
    /**
     * The Lock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lock;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * The SeatPriceOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SeatPriceOverride;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The TransfereeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransfereeDetails;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * The IsAvailableForResaleRequest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAvailableForResaleRequest;
    /**
     * The ClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClubAccess;
    /**
     * The EntryGate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntryGate;
    /**
     * The Level
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Level;
    /**
     * The SecondaryClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SecondaryClubAccess;
    /**
     * Constructor method for GetSeatToolTipInfo-Response
     * @uses GetSeatToolTipInfo_Response::setAccountName()
     * @uses GetSeatToolTipInfo_Response::setCustomerName()
     * @uses GetSeatToolTipInfo_Response::setRelatedSeatIds()
     * @uses GetSeatToolTipInfo_Response::setReservationExpiryDate()
     * @uses GetSeatToolTipInfo_Response::setTransactionDate()
     * @uses GetSeatToolTipInfo_Response::setTransactionNumber()
     * @uses GetSeatToolTipInfo_Response::setHeldForInfo()
     * @uses GetSeatToolTipInfo_Response::setSeriesName()
     * @uses GetSeatToolTipInfo_Response::setSubscriptionNumber()
     * @uses GetSeatToolTipInfo_Response::setCrmId()
     * @uses GetSeatToolTipInfo_Response::setOwnerName()
     * @uses GetSeatToolTipInfo_Response::setPricing()
     * @uses GetSeatToolTipInfo_Response::setSeatInventoryDetails()
     * @uses GetSeatToolTipInfo_Response::setResaleRequestDate()
     * @uses GetSeatToolTipInfo_Response::setSessionInfo()
     * @uses GetSeatToolTipInfo_Response::setTransactionReferenceNumber()
     * @uses GetSeatToolTipInfo_Response::setSeatTypeId()
     * @uses GetSeatToolTipInfo_Response::setSeatTypeName()
     * @uses GetSeatToolTipInfo_Response::setSeatTypeNote()
     * @uses GetSeatToolTipInfo_Response::setIsResale()
     * @uses GetSeatToolTipInfo_Response::setClientId()
     * @uses GetSeatToolTipInfo_Response::setTransactionId()
     * @uses GetSeatToolTipInfo_Response::setAllocations()
     * @uses GetSeatToolTipInfo_Response::setCustomProperty1()
     * @uses GetSeatToolTipInfo_Response::setCustomProperty2()
     * @uses GetSeatToolTipInfo_Response::setCustomProperty3()
     * @uses GetSeatToolTipInfo_Response::setCustomProperty4()
     * @uses GetSeatToolTipInfo_Response::setLock()
     * @uses GetSeatToolTipInfo_Response::setNote()
     * @uses GetSeatToolTipInfo_Response::setOwnerId()
     * @uses GetSeatToolTipInfo_Response::setSeatPriceOverride()
     * @uses GetSeatToolTipInfo_Response::setResaleMethod()
     * @uses GetSeatToolTipInfo_Response::setTransfereeDetails()
     * @uses GetSeatToolTipInfo_Response::setTicketId()
     * @uses GetSeatToolTipInfo_Response::setIsAvailableForResaleRequest()
     * @uses GetSeatToolTipInfo_Response::setClubAccess()
     * @uses GetSeatToolTipInfo_Response::setEntryGate()
     * @uses GetSeatToolTipInfo_Response::setLevel()
     * @uses GetSeatToolTipInfo_Response::setSecondaryClubAccess()
     * @param string $accountName
     * @param \patest\StructType\PersonName $customerName
     * @param \patest\ArrayType\ArrayOfint $relatedSeatIds
     * @param string $reservationExpiryDate
     * @param string $transactionDate
     * @param int $transactionNumber
     * @param string $heldForInfo
     * @param string $seriesName
     * @param string $subscriptionNumber
     * @param string $crmId
     * @param string $ownerName
     * @param \patest\StructType\EventPricingDescription $pricing
     * @param \patest\StructType\SeatInventoryDetails $seatInventoryDetails
     * @param string $resaleRequestDate
     * @param \patest\StructType\SeatTooltipSessionInfo $sessionInfo
     * @param int $transactionReferenceNumber
     * @param string $seatTypeId
     * @param string $seatTypeName
     * @param string $seatTypeNote
     * @param bool $isResale
     * @param string $clientId
     * @param string $transactionId
     * @param \patest\ArrayType\ArrayOfstring $allocations
     * @param string $customProperty1
     * @param string $customProperty2
     * @param string $customProperty3
     * @param string $customProperty4
     * @param string $lock
     * @param string $note
     * @param string $ownerId
     * @param \patest\StructType\Money $seatPriceOverride
     * @param string $resaleMethod
     * @param string $transfereeDetails
     * @param string $ticketId
     * @param bool $isAvailableForResaleRequest
     * @param string $clubAccess
     * @param string $entryGate
     * @param string $level
     * @param string $secondaryClubAccess
     */
    public function __construct($accountName = null, \patest\StructType\PersonName $customerName = null, \patest\ArrayType\ArrayOfint $relatedSeatIds = null, $reservationExpiryDate = null, $transactionDate = null, $transactionNumber = null, $heldForInfo = null, $seriesName = null, $subscriptionNumber = null, $crmId = null, $ownerName = null, \patest\StructType\EventPricingDescription $pricing = null, \patest\StructType\SeatInventoryDetails $seatInventoryDetails = null, $resaleRequestDate = null, \patest\StructType\SeatTooltipSessionInfo $sessionInfo = null, $transactionReferenceNumber = null, $seatTypeId = null, $seatTypeName = null, $seatTypeNote = null, $isResale = null, $clientId = null, $transactionId = null, \patest\ArrayType\ArrayOfstring $allocations = null, $customProperty1 = null, $customProperty2 = null, $customProperty3 = null, $customProperty4 = null, $lock = null, $note = null, $ownerId = null, \patest\StructType\Money $seatPriceOverride = null, $resaleMethod = null, $transfereeDetails = null, $ticketId = null, $isAvailableForResaleRequest = null, $clubAccess = null, $entryGate = null, $level = null, $secondaryClubAccess = null)
    {
        $this
            ->setAccountName($accountName)
            ->setCustomerName($customerName)
            ->setRelatedSeatIds($relatedSeatIds)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setTransactionDate($transactionDate)
            ->setTransactionNumber($transactionNumber)
            ->setHeldForInfo($heldForInfo)
            ->setSeriesName($seriesName)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setCrmId($crmId)
            ->setOwnerName($ownerName)
            ->setPricing($pricing)
            ->setSeatInventoryDetails($seatInventoryDetails)
            ->setResaleRequestDate($resaleRequestDate)
            ->setSessionInfo($sessionInfo)
            ->setTransactionReferenceNumber($transactionReferenceNumber)
            ->setSeatTypeId($seatTypeId)
            ->setSeatTypeName($seatTypeName)
            ->setSeatTypeNote($seatTypeNote)
            ->setIsResale($isResale)
            ->setClientId($clientId)
            ->setTransactionId($transactionId)
            ->setAllocations($allocations)
            ->setCustomProperty1($customProperty1)
            ->setCustomProperty2($customProperty2)
            ->setCustomProperty3($customProperty3)
            ->setCustomProperty4($customProperty4)
            ->setLock($lock)
            ->setNote($note)
            ->setOwnerId($ownerId)
            ->setSeatPriceOverride($seatPriceOverride)
            ->setResaleMethod($resaleMethod)
            ->setTransfereeDetails($transfereeDetails)
            ->setTicketId($ticketId)
            ->setIsAvailableForResaleRequest($isAvailableForResaleRequest)
            ->setClubAccess($clubAccess)
            ->setEntryGate($entryGate)
            ->setLevel($level)
            ->setSecondaryClubAccess($secondaryClubAccess);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get CustomerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PersonName|null
     */
    public function getCustomerName()
    {
        return isset($this->CustomerName) ? $this->CustomerName : null;
    }
    /**
     * Set CustomerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PersonName $customerName
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCustomerName(\patest\StructType\PersonName $customerName = null)
    {
        if (is_null($customerName) || (is_array($customerName) && empty($customerName))) {
            unset($this->CustomerName);
        } else {
            $this->CustomerName = $customerName;
        }
        return $this;
    }
    /**
     * Get RelatedSeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getRelatedSeatIds()
    {
        return isset($this->RelatedSeatIds) ? $this->RelatedSeatIds : null;
    }
    /**
     * Set RelatedSeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $relatedSeatIds
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setRelatedSeatIds(\patest\ArrayType\ArrayOfint $relatedSeatIds = null)
    {
        if (is_null($relatedSeatIds) || (is_array($relatedSeatIds) && empty($relatedSeatIds))) {
            unset($this->RelatedSeatIds);
        } else {
            $this->RelatedSeatIds = $relatedSeatIds;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get HeldForInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHeldForInfo()
    {
        return isset($this->HeldForInfo) ? $this->HeldForInfo : null;
    }
    /**
     * Set HeldForInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $heldForInfo
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setHeldForInfo($heldForInfo = null)
    {
        // validation for constraint: string
        if (!is_null($heldForInfo) && !is_string($heldForInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($heldForInfo, true), gettype($heldForInfo)), __LINE__);
        }
        if (is_null($heldForInfo) || (is_array($heldForInfo) && empty($heldForInfo))) {
            unset($this->HeldForInfo);
        } else {
            $this->HeldForInfo = $heldForInfo;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesName
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeriesName($seriesName = null)
    {
        // validation for constraint: string
        if (!is_null($seriesName) && !is_string($seriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesName, true), gettype($seriesName)), __LINE__);
        }
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get OwnerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerName()
    {
        return isset($this->OwnerName) ? $this->OwnerName : null;
    }
    /**
     * Set OwnerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerName
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        if (is_null($ownerName) || (is_array($ownerName) && empty($ownerName))) {
            unset($this->OwnerName);
        } else {
            $this->OwnerName = $ownerName;
        }
        return $this;
    }
    /**
     * Get Pricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventPricingDescription|null
     */
    public function getPricing()
    {
        return isset($this->Pricing) ? $this->Pricing : null;
    }
    /**
     * Set Pricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventPricingDescription $pricing
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setPricing(\patest\StructType\EventPricingDescription $pricing = null)
    {
        if (is_null($pricing) || (is_array($pricing) && empty($pricing))) {
            unset($this->Pricing);
        } else {
            $this->Pricing = $pricing;
        }
        return $this;
    }
    /**
     * Get SeatInventoryDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatInventoryDetails|null
     */
    public function getSeatInventoryDetails()
    {
        return isset($this->SeatInventoryDetails) ? $this->SeatInventoryDetails : null;
    }
    /**
     * Set SeatInventoryDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatInventoryDetails $seatInventoryDetails
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeatInventoryDetails(\patest\StructType\SeatInventoryDetails $seatInventoryDetails = null)
    {
        if (is_null($seatInventoryDetails) || (is_array($seatInventoryDetails) && empty($seatInventoryDetails))) {
            unset($this->SeatInventoryDetails);
        } else {
            $this->SeatInventoryDetails = $seatInventoryDetails;
        }
        return $this;
    }
    /**
     * Get ResaleRequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleRequestDate()
    {
        return isset($this->ResaleRequestDate) ? $this->ResaleRequestDate : null;
    }
    /**
     * Set ResaleRequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resaleRequestDate
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setResaleRequestDate($resaleRequestDate = null)
    {
        // validation for constraint: string
        if (!is_null($resaleRequestDate) && !is_string($resaleRequestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resaleRequestDate, true), gettype($resaleRequestDate)), __LINE__);
        }
        if (is_null($resaleRequestDate) || (is_array($resaleRequestDate) && empty($resaleRequestDate))) {
            unset($this->ResaleRequestDate);
        } else {
            $this->ResaleRequestDate = $resaleRequestDate;
        }
        return $this;
    }
    /**
     * Get SessionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatTooltipSessionInfo|null
     */
    public function getSessionInfo()
    {
        return isset($this->SessionInfo) ? $this->SessionInfo : null;
    }
    /**
     * Set SessionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatTooltipSessionInfo $sessionInfo
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSessionInfo(\patest\StructType\SeatTooltipSessionInfo $sessionInfo = null)
    {
        if (is_null($sessionInfo) || (is_array($sessionInfo) && empty($sessionInfo))) {
            unset($this->SessionInfo);
        } else {
            $this->SessionInfo = $sessionInfo;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
    /**
     * Get SeatTypeId value
     * @return string|null
     */
    public function getSeatTypeId()
    {
        return $this->SeatTypeId;
    }
    /**
     * Set SeatTypeId value
     * @param string $seatTypeId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeatTypeId($seatTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeId) && !is_string($seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeId, true), gettype($seatTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatTypeId, true)), __LINE__);
        }
        $this->SeatTypeId = $seatTypeId;
        return $this;
    }
    /**
     * Get SeatTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeName()
    {
        return isset($this->SeatTypeName) ? $this->SeatTypeName : null;
    }
    /**
     * Set SeatTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeName
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeatTypeName($seatTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeName) && !is_string($seatTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeName, true), gettype($seatTypeName)), __LINE__);
        }
        if (is_null($seatTypeName) || (is_array($seatTypeName) && empty($seatTypeName))) {
            unset($this->SeatTypeName);
        } else {
            $this->SeatTypeName = $seatTypeName;
        }
        return $this;
    }
    /**
     * Get SeatTypeNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeNote()
    {
        return isset($this->SeatTypeNote) ? $this->SeatTypeNote : null;
    }
    /**
     * Set SeatTypeNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeNote
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeatTypeNote($seatTypeNote = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeNote) && !is_string($seatTypeNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeNote, true), gettype($seatTypeNote)), __LINE__);
        }
        if (is_null($seatTypeNote) || (is_array($seatTypeNote) && empty($seatTypeNote))) {
            unset($this->SeatTypeNote);
        } else {
            $this->SeatTypeNote = $seatTypeNote;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * @return bool|null
     */
    public function getIsResale()
    {
        return $this->IsResale;
    }
    /**
     * Set IsResale value
     * @param bool $isResale
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        $this->IsResale = $isResale;
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
    /**
     * Get Allocations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getAllocations()
    {
        return isset($this->Allocations) ? $this->Allocations : null;
    }
    /**
     * Set Allocations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $allocations
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setAllocations(\patest\ArrayType\ArrayOfstring $allocations = null)
    {
        if (is_null($allocations) || (is_array($allocations) && empty($allocations))) {
            unset($this->Allocations);
        } else {
            $this->Allocations = $allocations;
        }
        return $this;
    }
    /**
     * Get CustomProperty1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty1()
    {
        return isset($this->CustomProperty1) ? $this->CustomProperty1 : null;
    }
    /**
     * Set CustomProperty1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty1
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCustomProperty1($customProperty1 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty1) && !is_string($customProperty1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty1, true), gettype($customProperty1)), __LINE__);
        }
        if (is_null($customProperty1) || (is_array($customProperty1) && empty($customProperty1))) {
            unset($this->CustomProperty1);
        } else {
            $this->CustomProperty1 = $customProperty1;
        }
        return $this;
    }
    /**
     * Get CustomProperty2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty2()
    {
        return isset($this->CustomProperty2) ? $this->CustomProperty2 : null;
    }
    /**
     * Set CustomProperty2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty2
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCustomProperty2($customProperty2 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty2) && !is_string($customProperty2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty2, true), gettype($customProperty2)), __LINE__);
        }
        if (is_null($customProperty2) || (is_array($customProperty2) && empty($customProperty2))) {
            unset($this->CustomProperty2);
        } else {
            $this->CustomProperty2 = $customProperty2;
        }
        return $this;
    }
    /**
     * Get CustomProperty3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty3()
    {
        return isset($this->CustomProperty3) ? $this->CustomProperty3 : null;
    }
    /**
     * Set CustomProperty3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty3
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCustomProperty3($customProperty3 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty3) && !is_string($customProperty3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty3, true), gettype($customProperty3)), __LINE__);
        }
        if (is_null($customProperty3) || (is_array($customProperty3) && empty($customProperty3))) {
            unset($this->CustomProperty3);
        } else {
            $this->CustomProperty3 = $customProperty3;
        }
        return $this;
    }
    /**
     * Get CustomProperty4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty4()
    {
        return isset($this->CustomProperty4) ? $this->CustomProperty4 : null;
    }
    /**
     * Set CustomProperty4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty4
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setCustomProperty4($customProperty4 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty4) && !is_string($customProperty4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty4, true), gettype($customProperty4)), __LINE__);
        }
        if (is_null($customProperty4) || (is_array($customProperty4) && empty($customProperty4))) {
            unset($this->CustomProperty4);
        } else {
            $this->CustomProperty4 = $customProperty4;
        }
        return $this;
    }
    /**
     * Get Lock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLock()
    {
        return isset($this->Lock) ? $this->Lock : null;
    }
    /**
     * Set Lock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lock
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setLock($lock = null)
    {
        // validation for constraint: string
        if (!is_null($lock) && !is_string($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lock, true), gettype($lock)), __LINE__);
        }
        if (is_null($lock) || (is_array($lock) && empty($lock))) {
            unset($this->Lock);
        } else {
            $this->Lock = $lock;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
    /**
     * Get SeatPriceOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSeatPriceOverride()
    {
        return isset($this->SeatPriceOverride) ? $this->SeatPriceOverride : null;
    }
    /**
     * Set SeatPriceOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $seatPriceOverride
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSeatPriceOverride(\patest\StructType\Money $seatPriceOverride = null)
    {
        if (is_null($seatPriceOverride) || (is_array($seatPriceOverride) && empty($seatPriceOverride))) {
            unset($this->SeatPriceOverride);
        } else {
            $this->SeatPriceOverride = $seatPriceOverride;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get TransfereeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransfereeDetails()
    {
        return isset($this->TransfereeDetails) ? $this->TransfereeDetails : null;
    }
    /**
     * Set TransfereeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transfereeDetails
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTransfereeDetails($transfereeDetails = null)
    {
        // validation for constraint: string
        if (!is_null($transfereeDetails) && !is_string($transfereeDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transfereeDetails, true), gettype($transfereeDetails)), __LINE__);
        }
        if (is_null($transfereeDetails) || (is_array($transfereeDetails) && empty($transfereeDetails))) {
            unset($this->TransfereeDetails);
        } else {
            $this->TransfereeDetails = $transfereeDetails;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketId()
    {
        return isset($this->TicketId) ? $this->TicketId : null;
    }
    /**
     * Set TicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketId
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        if (is_null($ticketId) || (is_array($ticketId) && empty($ticketId))) {
            unset($this->TicketId);
        } else {
            $this->TicketId = $ticketId;
        }
        return $this;
    }
    /**
     * Get IsAvailableForResaleRequest value
     * @return bool|null
     */
    public function getIsAvailableForResaleRequest()
    {
        return $this->IsAvailableForResaleRequest;
    }
    /**
     * Set IsAvailableForResaleRequest value
     * @param bool $isAvailableForResaleRequest
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setIsAvailableForResaleRequest($isAvailableForResaleRequest = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAvailableForResaleRequest) && !is_bool($isAvailableForResaleRequest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAvailableForResaleRequest, true), gettype($isAvailableForResaleRequest)), __LINE__);
        }
        $this->IsAvailableForResaleRequest = $isAvailableForResaleRequest;
        return $this;
    }
    /**
     * Get ClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClubAccess()
    {
        return isset($this->ClubAccess) ? $this->ClubAccess : null;
    }
    /**
     * Set ClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clubAccess
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setClubAccess($clubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($clubAccess) && !is_string($clubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clubAccess, true), gettype($clubAccess)), __LINE__);
        }
        if (is_null($clubAccess) || (is_array($clubAccess) && empty($clubAccess))) {
            unset($this->ClubAccess);
        } else {
            $this->ClubAccess = $clubAccess;
        }
        return $this;
    }
    /**
     * Get EntryGate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntryGate()
    {
        return isset($this->EntryGate) ? $this->EntryGate : null;
    }
    /**
     * Set EntryGate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entryGate
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setEntryGate($entryGate = null)
    {
        // validation for constraint: string
        if (!is_null($entryGate) && !is_string($entryGate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entryGate, true), gettype($entryGate)), __LINE__);
        }
        if (is_null($entryGate) || (is_array($entryGate) && empty($entryGate))) {
            unset($this->EntryGate);
        } else {
            $this->EntryGate = $entryGate;
        }
        return $this;
    }
    /**
     * Get Level value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLevel()
    {
        return isset($this->Level) ? $this->Level : null;
    }
    /**
     * Set Level value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $level
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setLevel($level = null)
    {
        // validation for constraint: string
        if (!is_null($level) && !is_string($level)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($level, true), gettype($level)), __LINE__);
        }
        if (is_null($level) || (is_array($level) && empty($level))) {
            unset($this->Level);
        } else {
            $this->Level = $level;
        }
        return $this;
    }
    /**
     * Get SecondaryClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecondaryClubAccess()
    {
        return isset($this->SecondaryClubAccess) ? $this->SecondaryClubAccess : null;
    }
    /**
     * Set SecondaryClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $secondaryClubAccess
     * @return \patest\StructType\GetSeatToolTipInfo_Response
     */
    public function setSecondaryClubAccess($secondaryClubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($secondaryClubAccess) && !is_string($secondaryClubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secondaryClubAccess, true), gettype($secondaryClubAccess)), __LINE__);
        }
        if (is_null($secondaryClubAccess) || (is_array($secondaryClubAccess) && empty($secondaryClubAccess))) {
            unset($this->SecondaryClubAccess);
        } else {
            $this->SecondaryClubAccess = $secondaryClubAccess;
        }
        return $this;
    }
}
