<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetPaymentPlanDefaults-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetPaymentPlanDefaults-Response
 * @subpackage Structs
 */
class GetPaymentPlanDefaults_Response extends AbstractStructBase
{
    /**
     * The BaseDownPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $BaseDownPayment;
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The DownPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $DownPayment;
    /**
     * The InstallmentDates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfInstallmentDateInfo
     */
    public $InstallmentDates;
    /**
     * The InstallmentSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstallmentSchedule;
    /**
     * The InstallmentsAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $InstallmentsAmount;
    /**
     * The InstallmentsPastDueMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsPastDueMessage;
    /**
     * The InstallmentsPastDuePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InstallmentsPastDuePolicy;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PastDueAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PastDueAmount;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * Constructor method for GetPaymentPlanDefaults-Response
     * @uses GetPaymentPlanDefaults_Response::setBaseDownPayment()
     * @uses GetPaymentPlanDefaults_Response::setDateOfFirstInstallment()
     * @uses GetPaymentPlanDefaults_Response::setDownPayment()
     * @uses GetPaymentPlanDefaults_Response::setInstallmentDates()
     * @uses GetPaymentPlanDefaults_Response::setInstallmentSchedule()
     * @uses GetPaymentPlanDefaults_Response::setInstallmentsAmount()
     * @uses GetPaymentPlanDefaults_Response::setInstallmentsPastDueMessage()
     * @uses GetPaymentPlanDefaults_Response::setInstallmentsPastDuePolicy()
     * @uses GetPaymentPlanDefaults_Response::setNumberOfInstallments()
     * @uses GetPaymentPlanDefaults_Response::setPastDueAmount()
     * @uses GetPaymentPlanDefaults_Response::setRemainingAmount()
     * @param \patest\StructType\Money $baseDownPayment
     * @param string $dateOfFirstInstallment
     * @param \patest\StructType\Money $downPayment
     * @param \patest\ArrayType\ArrayOfInstallmentDateInfo $installmentDates
     * @param string $installmentSchedule
     * @param \patest\StructType\Money $installmentsAmount
     * @param string $installmentsPastDueMessage
     * @param string $installmentsPastDuePolicy
     * @param int $numberOfInstallments
     * @param \patest\StructType\Money $pastDueAmount
     * @param \patest\StructType\Money $remainingAmount
     */
    public function __construct(\patest\StructType\Money $baseDownPayment = null, $dateOfFirstInstallment = null, \patest\StructType\Money $downPayment = null, \patest\ArrayType\ArrayOfInstallmentDateInfo $installmentDates = null, $installmentSchedule = null, \patest\StructType\Money $installmentsAmount = null, $installmentsPastDueMessage = null, $installmentsPastDuePolicy = null, $numberOfInstallments = null, \patest\StructType\Money $pastDueAmount = null, \patest\StructType\Money $remainingAmount = null)
    {
        $this
            ->setBaseDownPayment($baseDownPayment)
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setDownPayment($downPayment)
            ->setInstallmentDates($installmentDates)
            ->setInstallmentSchedule($installmentSchedule)
            ->setInstallmentsAmount($installmentsAmount)
            ->setInstallmentsPastDueMessage($installmentsPastDueMessage)
            ->setInstallmentsPastDuePolicy($installmentsPastDuePolicy)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPastDueAmount($pastDueAmount)
            ->setRemainingAmount($remainingAmount);
    }
    /**
     * Get BaseDownPayment value
     * @return \patest\StructType\Money|null
     */
    public function getBaseDownPayment()
    {
        return $this->BaseDownPayment;
    }
    /**
     * Set BaseDownPayment value
     * @param \patest\StructType\Money $baseDownPayment
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setBaseDownPayment(\patest\StructType\Money $baseDownPayment = null)
    {
        $this->BaseDownPayment = $baseDownPayment;
        return $this;
    }
    /**
     * Get DateOfFirstInstallment value
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return $this->DateOfFirstInstallment;
    }
    /**
     * Set DateOfFirstInstallment value
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        return $this;
    }
    /**
     * Get DownPayment value
     * @return \patest\StructType\Money|null
     */
    public function getDownPayment()
    {
        return $this->DownPayment;
    }
    /**
     * Set DownPayment value
     * @param \patest\StructType\Money $downPayment
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setDownPayment(\patest\StructType\Money $downPayment = null)
    {
        $this->DownPayment = $downPayment;
        return $this;
    }
    /**
     * Get InstallmentDates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfInstallmentDateInfo|null
     */
    public function getInstallmentDates()
    {
        return isset($this->InstallmentDates) ? $this->InstallmentDates : null;
    }
    /**
     * Set InstallmentDates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfInstallmentDateInfo $installmentDates
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setInstallmentDates(\patest\ArrayType\ArrayOfInstallmentDateInfo $installmentDates = null)
    {
        if (is_null($installmentDates) || (is_array($installmentDates) && empty($installmentDates))) {
            unset($this->InstallmentDates);
        } else {
            $this->InstallmentDates = $installmentDates;
        }
        return $this;
    }
    /**
     * Get InstallmentSchedule value
     * @return string|null
     */
    public function getInstallmentSchedule()
    {
        return $this->InstallmentSchedule;
    }
    /**
     * Set InstallmentSchedule value
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentSchedule
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setInstallmentSchedule($installmentSchedule = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentSchedule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentSchedule) ? implode(', ', $installmentSchedule) : var_export($installmentSchedule, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        $this->InstallmentSchedule = $installmentSchedule;
        return $this;
    }
    /**
     * Get InstallmentsAmount value
     * @return \patest\StructType\Money|null
     */
    public function getInstallmentsAmount()
    {
        return $this->InstallmentsAmount;
    }
    /**
     * Set InstallmentsAmount value
     * @param \patest\StructType\Money $installmentsAmount
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setInstallmentsAmount(\patest\StructType\Money $installmentsAmount = null)
    {
        $this->InstallmentsAmount = $installmentsAmount;
        return $this;
    }
    /**
     * Get InstallmentsPastDueMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPastDueMessage()
    {
        return isset($this->InstallmentsPastDueMessage) ? $this->InstallmentsPastDueMessage : null;
    }
    /**
     * Set InstallmentsPastDueMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentsPastDueMessage
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setInstallmentsPastDueMessage($installmentsPastDueMessage = null)
    {
        // validation for constraint: string
        if (!is_null($installmentsPastDueMessage) && !is_string($installmentsPastDueMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentsPastDueMessage, true), gettype($installmentsPastDueMessage)), __LINE__);
        }
        if (is_null($installmentsPastDueMessage) || (is_array($installmentsPastDueMessage) && empty($installmentsPastDueMessage))) {
            unset($this->InstallmentsPastDueMessage);
        } else {
            $this->InstallmentsPastDueMessage = $installmentsPastDueMessage;
        }
        return $this;
    }
    /**
     * Get InstallmentsPastDuePolicy value
     * @return string|null
     */
    public function getInstallmentsPastDuePolicy()
    {
        return $this->InstallmentsPastDuePolicy;
    }
    /**
     * Set InstallmentsPastDuePolicy value
     * @uses \patest\EnumType\InstallmentsPastDuePolicy::valueIsValid()
     * @uses \patest\EnumType\InstallmentsPastDuePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsPastDuePolicy
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setInstallmentsPastDuePolicy($installmentsPastDuePolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsPastDuePolicy::valueIsValid($installmentsPastDuePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsPastDuePolicy', is_array($installmentsPastDuePolicy) ? implode(', ', $installmentsPastDuePolicy) : var_export($installmentsPastDuePolicy, true), implode(', ', \patest\EnumType\InstallmentsPastDuePolicy::getValidValues())), __LINE__);
        }
        $this->InstallmentsPastDuePolicy = $installmentsPastDuePolicy;
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return $this->NumberOfInstallments;
    }
    /**
     * Set NumberOfInstallments value
     * @param int $numberOfInstallments
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        $this->NumberOfInstallments = $numberOfInstallments;
        return $this;
    }
    /**
     * Get PastDueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPastDueAmount()
    {
        return isset($this->PastDueAmount) ? $this->PastDueAmount : null;
    }
    /**
     * Set PastDueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $pastDueAmount
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setPastDueAmount(\patest\StructType\Money $pastDueAmount = null)
    {
        if (is_null($pastDueAmount) || (is_array($pastDueAmount) && empty($pastDueAmount))) {
            unset($this->PastDueAmount);
        } else {
            $this->PastDueAmount = $pastDueAmount;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return $this->RemainingAmount;
    }
    /**
     * Set RemainingAmount value
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\GetPaymentPlanDefaults_Response
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        $this->RemainingAmount = $remainingAmount;
        return $this;
    }
}
