<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMergedXmlDocumentsAsXmlResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMergedXmlDocumentsAsXmlResponse
 * @subpackage Structs
 */
class GetMergedXmlDocumentsAsXmlResponse extends AbstractStructBase
{
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidstring
     */
    public $Documents;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Status;
    /**
     * Constructor method for GetMergedXmlDocumentsAsXmlResponse
     * @uses GetMergedXmlDocumentsAsXmlResponse::setDocuments()
     * @uses GetMergedXmlDocumentsAsXmlResponse::setStatus()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $documents
     * @param int $status
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidstring $documents = null, $status = null)
    {
        $this
            ->setDocuments($documents)
            ->setStatus($status);
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidstring|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $documents
     * @return \patest\StructType\GetMergedXmlDocumentsAsXmlResponse
     */
    public function setDocuments(\patest\ArrayType\ArrayOfKeyValueOfguidstring $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get Status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \patest\StructType\GetMergedXmlDocumentsAsXmlResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
