<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMembershipDefinitionDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMembershipDefinitionDescription-Request
 * @subpackage Structs
 */
class GetMembershipDefinitionDescription_Request extends ExtensibleDataContract
{
    /**
     * The IncludePricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePricing;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The IncludeAutoRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeAutoRenew;
    /**
     * Constructor method for GetMembershipDefinitionDescription-Request
     * @uses GetMembershipDefinitionDescription_Request::setIncludePricing()
     * @uses GetMembershipDefinitionDescription_Request::setMembershipDefinitionId()
     * @uses GetMembershipDefinitionDescription_Request::setIncludeAutoRenew()
     * @param bool $includePricing
     * @param string $membershipDefinitionId
     * @param bool $includeAutoRenew
     */
    public function __construct($includePricing = null, $membershipDefinitionId = null, $includeAutoRenew = null)
    {
        $this
            ->setIncludePricing($includePricing)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setIncludeAutoRenew($includeAutoRenew);
    }
    /**
     * Get IncludePricing value
     * @return bool|null
     */
    public function getIncludePricing()
    {
        return $this->IncludePricing;
    }
    /**
     * Set IncludePricing value
     * @param bool $includePricing
     * @return \patest\StructType\GetMembershipDefinitionDescription_Request
     */
    public function setIncludePricing($includePricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePricing) && !is_bool($includePricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePricing, true), gettype($includePricing)), __LINE__);
        }
        $this->IncludePricing = $includePricing;
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return $this->MembershipDefinitionId;
    }
    /**
     * Set MembershipDefinitionId value
     * @param string $membershipDefinitionId
     * @return \patest\StructType\GetMembershipDefinitionDescription_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        $this->MembershipDefinitionId = $membershipDefinitionId;
        return $this;
    }
    /**
     * Get IncludeAutoRenew value
     * @return bool|null
     */
    public function getIncludeAutoRenew()
    {
        return $this->IncludeAutoRenew;
    }
    /**
     * Set IncludeAutoRenew value
     * @param bool $includeAutoRenew
     * @return \patest\StructType\GetMembershipDefinitionDescription_Request
     */
    public function setIncludeAutoRenew($includeAutoRenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAutoRenew) && !is_bool($includeAutoRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAutoRenew, true), gettype($includeAutoRenew)), __LINE__);
        }
        $this->IncludeAutoRenew = $includeAutoRenew;
        return $this;
    }
}
