<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetGiftVoucherDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetGiftVoucherDescription-Request
 * @subpackage Structs
 */
class GetGiftVoucherDescription_Request extends ExtensibleDataContract
{
    /**
     * The GiftVoucherDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherDefinitionId;
    /**
     * Constructor method for GetGiftVoucherDescription-Request
     * @uses GetGiftVoucherDescription_Request::setGiftVoucherDefinitionId()
     * @param string $giftVoucherDefinitionId
     */
    public function __construct($giftVoucherDefinitionId = null)
    {
        $this
            ->setGiftVoucherDefinitionId($giftVoucherDefinitionId);
    }
    /**
     * Get GiftVoucherDefinitionId value
     * @return string|null
     */
    public function getGiftVoucherDefinitionId()
    {
        return $this->GiftVoucherDefinitionId;
    }
    /**
     * Set GiftVoucherDefinitionId value
     * @param string $giftVoucherDefinitionId
     * @return \patest\StructType\GetGiftVoucherDescription_Request
     */
    public function setGiftVoucherDefinitionId($giftVoucherDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherDefinitionId) && !is_string($giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherDefinitionId, true), gettype($giftVoucherDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherDefinitionId, true)), __LINE__);
        }
        $this->GiftVoucherDefinitionId = $giftVoucherDefinitionId;
        return $this;
    }
}
