<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventsCrmHasTicketsFor-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventsCrmHasTicketsFor-Request
 * @subpackage Structs
 */
class GetEventsCrmHasTicketsFor_Request extends ExtensibleDataContract
{
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmId;
    /**
     * The DetermineSellability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DetermineSellability;
    /**
     * The DetermineTransferability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DetermineTransferability;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The IgnoreVisibilityRule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IgnoreVisibilityRule;
    /**
     * The IsOwned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOwned;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsValid;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The ShouldOnlyApplyRulesPerTransactionPerEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldOnlyApplyRulesPerTransactionPerEvent;
    /**
     * The ShouldUseEsql
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldUseEsql;
    /**
     * The ShouldUseStoredProcedure
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldUseStoredProcedure;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The TransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TransactionIds;
    /**
     * The ShouldUsePurchaser
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShouldUsePurchaser;
    /**
     * Constructor method for GetEventsCrmHasTicketsFor-Request
     * @uses GetEventsCrmHasTicketsFor_Request::setCrmId()
     * @uses GetEventsCrmHasTicketsFor_Request::setDetermineSellability()
     * @uses GetEventsCrmHasTicketsFor_Request::setDetermineTransferability()
     * @uses GetEventsCrmHasTicketsFor_Request::setEndDate()
     * @uses GetEventsCrmHasTicketsFor_Request::setIgnoreVisibilityRule()
     * @uses GetEventsCrmHasTicketsFor_Request::setIsOwned()
     * @uses GetEventsCrmHasTicketsFor_Request::setIsValid()
     * @uses GetEventsCrmHasTicketsFor_Request::setSellerBranchId()
     * @uses GetEventsCrmHasTicketsFor_Request::setShouldOnlyApplyRulesPerTransactionPerEvent()
     * @uses GetEventsCrmHasTicketsFor_Request::setShouldUseEsql()
     * @uses GetEventsCrmHasTicketsFor_Request::setShouldUseStoredProcedure()
     * @uses GetEventsCrmHasTicketsFor_Request::setStartDate()
     * @uses GetEventsCrmHasTicketsFor_Request::setTransactionIds()
     * @uses GetEventsCrmHasTicketsFor_Request::setShouldUsePurchaser()
     * @param string $crmId
     * @param bool $determineSellability
     * @param bool $determineTransferability
     * @param string $endDate
     * @param bool $ignoreVisibilityRule
     * @param bool $isOwned
     * @param bool $isValid
     * @param string $sellerBranchId
     * @param bool $shouldOnlyApplyRulesPerTransactionPerEvent
     * @param bool $shouldUseEsql
     * @param bool $shouldUseStoredProcedure
     * @param string $startDate
     * @param \patest\ArrayType\ArrayOfguid $transactionIds
     * @param bool $shouldUsePurchaser
     */
    public function __construct($crmId = null, $determineSellability = null, $determineTransferability = null, $endDate = null, $ignoreVisibilityRule = null, $isOwned = null, $isValid = null, $sellerBranchId = null, $shouldOnlyApplyRulesPerTransactionPerEvent = null, $shouldUseEsql = null, $shouldUseStoredProcedure = null, $startDate = null, \patest\ArrayType\ArrayOfguid $transactionIds = null, $shouldUsePurchaser = null)
    {
        $this
            ->setCrmId($crmId)
            ->setDetermineSellability($determineSellability)
            ->setDetermineTransferability($determineTransferability)
            ->setEndDate($endDate)
            ->setIgnoreVisibilityRule($ignoreVisibilityRule)
            ->setIsOwned($isOwned)
            ->setIsValid($isValid)
            ->setSellerBranchId($sellerBranchId)
            ->setShouldOnlyApplyRulesPerTransactionPerEvent($shouldOnlyApplyRulesPerTransactionPerEvent)
            ->setShouldUseEsql($shouldUseEsql)
            ->setShouldUseStoredProcedure($shouldUseStoredProcedure)
            ->setStartDate($startDate)
            ->setTransactionIds($transactionIds)
            ->setShouldUsePurchaser($shouldUsePurchaser);
    }
    /**
     * Get CrmId value
     * @return string|null
     */
    public function getCrmId()
    {
        return $this->CrmId;
    }
    /**
     * Set CrmId value
     * @param string $crmId
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmId, true)), __LINE__);
        }
        $this->CrmId = $crmId;
        return $this;
    }
    /**
     * Get DetermineSellability value
     * @return bool|null
     */
    public function getDetermineSellability()
    {
        return $this->DetermineSellability;
    }
    /**
     * Set DetermineSellability value
     * @param bool $determineSellability
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setDetermineSellability($determineSellability = null)
    {
        // validation for constraint: boolean
        if (!is_null($determineSellability) && !is_bool($determineSellability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($determineSellability, true), gettype($determineSellability)), __LINE__);
        }
        $this->DetermineSellability = $determineSellability;
        return $this;
    }
    /**
     * Get DetermineTransferability value
     * @return bool|null
     */
    public function getDetermineTransferability()
    {
        return $this->DetermineTransferability;
    }
    /**
     * Set DetermineTransferability value
     * @param bool $determineTransferability
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setDetermineTransferability($determineTransferability = null)
    {
        // validation for constraint: boolean
        if (!is_null($determineTransferability) && !is_bool($determineTransferability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($determineTransferability, true), gettype($determineTransferability)), __LINE__);
        }
        $this->DetermineTransferability = $determineTransferability;
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get IgnoreVisibilityRule value
     * @return bool|null
     */
    public function getIgnoreVisibilityRule()
    {
        return $this->IgnoreVisibilityRule;
    }
    /**
     * Set IgnoreVisibilityRule value
     * @param bool $ignoreVisibilityRule
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setIgnoreVisibilityRule($ignoreVisibilityRule = null)
    {
        // validation for constraint: boolean
        if (!is_null($ignoreVisibilityRule) && !is_bool($ignoreVisibilityRule)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ignoreVisibilityRule, true), gettype($ignoreVisibilityRule)), __LINE__);
        }
        $this->IgnoreVisibilityRule = $ignoreVisibilityRule;
        return $this;
    }
    /**
     * Get IsOwned value
     * @return bool|null
     */
    public function getIsOwned()
    {
        return $this->IsOwned;
    }
    /**
     * Set IsOwned value
     * @param bool $isOwned
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setIsOwned($isOwned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOwned) && !is_bool($isOwned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOwned, true), gettype($isOwned)), __LINE__);
        }
        $this->IsOwned = $isOwned;
        return $this;
    }
    /**
     * Get IsValid value
     * @return bool|null
     */
    public function getIsValid()
    {
        return $this->IsValid;
    }
    /**
     * Set IsValid value
     * @param bool $isValid
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        $this->IsValid = $isValid;
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get ShouldOnlyApplyRulesPerTransactionPerEvent value
     * @return bool|null
     */
    public function getShouldOnlyApplyRulesPerTransactionPerEvent()
    {
        return $this->ShouldOnlyApplyRulesPerTransactionPerEvent;
    }
    /**
     * Set ShouldOnlyApplyRulesPerTransactionPerEvent value
     * @param bool $shouldOnlyApplyRulesPerTransactionPerEvent
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setShouldOnlyApplyRulesPerTransactionPerEvent($shouldOnlyApplyRulesPerTransactionPerEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldOnlyApplyRulesPerTransactionPerEvent) && !is_bool($shouldOnlyApplyRulesPerTransactionPerEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldOnlyApplyRulesPerTransactionPerEvent, true), gettype($shouldOnlyApplyRulesPerTransactionPerEvent)), __LINE__);
        }
        $this->ShouldOnlyApplyRulesPerTransactionPerEvent = $shouldOnlyApplyRulesPerTransactionPerEvent;
        return $this;
    }
    /**
     * Get ShouldUseEsql value
     * @return bool|null
     */
    public function getShouldUseEsql()
    {
        return $this->ShouldUseEsql;
    }
    /**
     * Set ShouldUseEsql value
     * @param bool $shouldUseEsql
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setShouldUseEsql($shouldUseEsql = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUseEsql) && !is_bool($shouldUseEsql)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUseEsql, true), gettype($shouldUseEsql)), __LINE__);
        }
        $this->ShouldUseEsql = $shouldUseEsql;
        return $this;
    }
    /**
     * Get ShouldUseStoredProcedure value
     * @return bool|null
     */
    public function getShouldUseStoredProcedure()
    {
        return $this->ShouldUseStoredProcedure;
    }
    /**
     * Set ShouldUseStoredProcedure value
     * @param bool $shouldUseStoredProcedure
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setShouldUseStoredProcedure($shouldUseStoredProcedure = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUseStoredProcedure) && !is_bool($shouldUseStoredProcedure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUseStoredProcedure, true), gettype($shouldUseStoredProcedure)), __LINE__);
        }
        $this->ShouldUseStoredProcedure = $shouldUseStoredProcedure;
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get TransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTransactionIds()
    {
        return isset($this->TransactionIds) ? $this->TransactionIds : null;
    }
    /**
     * Set TransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $transactionIds
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setTransactionIds(\patest\ArrayType\ArrayOfguid $transactionIds = null)
    {
        if (is_null($transactionIds) || (is_array($transactionIds) && empty($transactionIds))) {
            unset($this->TransactionIds);
        } else {
            $this->TransactionIds = $transactionIds;
        }
        return $this;
    }
    /**
     * Get ShouldUsePurchaser value
     * @return bool|null
     */
    public function getShouldUsePurchaser()
    {
        return $this->ShouldUsePurchaser;
    }
    /**
     * Set ShouldUsePurchaser value
     * @param bool $shouldUsePurchaser
     * @return \patest\StructType\GetEventsCrmHasTicketsFor_Request
     */
    public function setShouldUsePurchaser($shouldUsePurchaser = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUsePurchaser) && !is_bool($shouldUsePurchaser)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUsePurchaser, true), gettype($shouldUsePurchaser)), __LINE__);
        }
        $this->ShouldUsePurchaser = $shouldUsePurchaser;
        return $this;
    }
}
