<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEventDescription-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEventDescription-Request
 * @subpackage Structs
 */
class GetEventDescription_Request extends ExtensibleDataContract
{
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The CompactMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CompactMode;
    /**
     * The OwnerSubscriptionSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerSubscriptionSeriesId;
    /**
     * The IsOmitPricingInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOmitPricingInfo;
    /**
     * The IncludeEventInSeriesAvailability
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventInSeriesAvailability;
    /**
     * The IncludeEventTags
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeEventTags;
    /**
     * The IncludeHospitalityDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeHospitalityDetails;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The CouponSpecificationIsOptional
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CouponSpecificationIsOptional;
    /**
     * The ExtraOfPromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtraOfPromptId;
    /**
     * The IncludePricingPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePricingPriceLevels;
    /**
     * The IncludeOnlineTicketsLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeOnlineTicketsLimit;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The IncludePriceModifiersForSubsTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludePriceModifiersForSubsTickets;
    /**
     * The IncludeBasketLevelPriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeBasketLevelPriceModifiers;
    /**
     * The IncludeTicketLimitationRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeTicketLimitationRules;
    /**
     * The OverridePriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OverridePriceTypeIds;
    /**
     * Constructor method for GetEventDescription-Request
     * @uses GetEventDescription_Request::setEventGuid()
     * @uses GetEventDescription_Request::setCompactMode()
     * @uses GetEventDescription_Request::setOwnerSubscriptionSeriesId()
     * @uses GetEventDescription_Request::setIsOmitPricingInfo()
     * @uses GetEventDescription_Request::setIncludeEventInSeriesAvailability()
     * @uses GetEventDescription_Request::setIncludeEventTags()
     * @uses GetEventDescription_Request::setIncludeHospitalityDetails()
     * @uses GetEventDescription_Request::setCouponIdentity()
     * @uses GetEventDescription_Request::setCouponSpecificationIsOptional()
     * @uses GetEventDescription_Request::setExtraOfPromptId()
     * @uses GetEventDescription_Request::setIncludePricingPriceLevels()
     * @uses GetEventDescription_Request::setIncludeOnlineTicketsLimit()
     * @uses GetEventDescription_Request::setAreaId()
     * @uses GetEventDescription_Request::setPresaleId()
     * @uses GetEventDescription_Request::setIncludePriceModifiersForSubsTickets()
     * @uses GetEventDescription_Request::setIncludeBasketLevelPriceModifiers()
     * @uses GetEventDescription_Request::setIncludeTicketLimitationRules()
     * @uses GetEventDescription_Request::setOverridePriceTypeIds()
     * @param string $eventGuid
     * @param bool $compactMode
     * @param string $ownerSubscriptionSeriesId
     * @param bool $isOmitPricingInfo
     * @param bool $includeEventInSeriesAvailability
     * @param bool $includeEventTags
     * @param bool $includeHospitalityDetails
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param bool $couponSpecificationIsOptional
     * @param string $extraOfPromptId
     * @param bool $includePricingPriceLevels
     * @param bool $includeOnlineTicketsLimit
     * @param string $areaId
     * @param string $presaleId
     * @param bool $includePriceModifiersForSubsTickets
     * @param bool $includeBasketLevelPriceModifiers
     * @param bool $includeTicketLimitationRules
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     */
    public function __construct($eventGuid = null, $compactMode = null, $ownerSubscriptionSeriesId = null, $isOmitPricingInfo = null, $includeEventInSeriesAvailability = null, $includeEventTags = null, $includeHospitalityDetails = null, \patest\StructType\CouponIdentity $couponIdentity = null, $couponSpecificationIsOptional = null, $extraOfPromptId = null, $includePricingPriceLevels = null, $includeOnlineTicketsLimit = null, $areaId = null, $presaleId = null, $includePriceModifiersForSubsTickets = null, $includeBasketLevelPriceModifiers = null, $includeTicketLimitationRules = null, \patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        $this
            ->setEventGuid($eventGuid)
            ->setCompactMode($compactMode)
            ->setOwnerSubscriptionSeriesId($ownerSubscriptionSeriesId)
            ->setIsOmitPricingInfo($isOmitPricingInfo)
            ->setIncludeEventInSeriesAvailability($includeEventInSeriesAvailability)
            ->setIncludeEventTags($includeEventTags)
            ->setIncludeHospitalityDetails($includeHospitalityDetails)
            ->setCouponIdentity($couponIdentity)
            ->setCouponSpecificationIsOptional($couponSpecificationIsOptional)
            ->setExtraOfPromptId($extraOfPromptId)
            ->setIncludePricingPriceLevels($includePricingPriceLevels)
            ->setIncludeOnlineTicketsLimit($includeOnlineTicketsLimit)
            ->setAreaId($areaId)
            ->setPresaleId($presaleId)
            ->setIncludePriceModifiersForSubsTickets($includePriceModifiersForSubsTickets)
            ->setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers)
            ->setIncludeTicketLimitationRules($includeTicketLimitationRules)
            ->setOverridePriceTypeIds($overridePriceTypeIds);
    }
    /**
     * Get EventGuid value
     * @return string|null
     */
    public function getEventGuid()
    {
        return $this->EventGuid;
    }
    /**
     * Set EventGuid value
     * @param string $eventGuid
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        $this->EventGuid = $eventGuid;
        return $this;
    }
    /**
     * Get CompactMode value
     * @return bool|null
     */
    public function getCompactMode()
    {
        return $this->CompactMode;
    }
    /**
     * Set CompactMode value
     * @param bool $compactMode
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setCompactMode($compactMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($compactMode) && !is_bool($compactMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($compactMode, true), gettype($compactMode)), __LINE__);
        }
        $this->CompactMode = $compactMode;
        return $this;
    }
    /**
     * Get OwnerSubscriptionSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerSubscriptionSeriesId()
    {
        return isset($this->OwnerSubscriptionSeriesId) ? $this->OwnerSubscriptionSeriesId : null;
    }
    /**
     * Set OwnerSubscriptionSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerSubscriptionSeriesId
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setOwnerSubscriptionSeriesId($ownerSubscriptionSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerSubscriptionSeriesId) && !is_string($ownerSubscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerSubscriptionSeriesId, true), gettype($ownerSubscriptionSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerSubscriptionSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerSubscriptionSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerSubscriptionSeriesId, true)), __LINE__);
        }
        if (is_null($ownerSubscriptionSeriesId) || (is_array($ownerSubscriptionSeriesId) && empty($ownerSubscriptionSeriesId))) {
            unset($this->OwnerSubscriptionSeriesId);
        } else {
            $this->OwnerSubscriptionSeriesId = $ownerSubscriptionSeriesId;
        }
        return $this;
    }
    /**
     * Get IsOmitPricingInfo value
     * @return bool|null
     */
    public function getIsOmitPricingInfo()
    {
        return $this->IsOmitPricingInfo;
    }
    /**
     * Set IsOmitPricingInfo value
     * @param bool $isOmitPricingInfo
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIsOmitPricingInfo($isOmitPricingInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOmitPricingInfo) && !is_bool($isOmitPricingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOmitPricingInfo, true), gettype($isOmitPricingInfo)), __LINE__);
        }
        $this->IsOmitPricingInfo = $isOmitPricingInfo;
        return $this;
    }
    /**
     * Get IncludeEventInSeriesAvailability value
     * @return bool|null
     */
    public function getIncludeEventInSeriesAvailability()
    {
        return $this->IncludeEventInSeriesAvailability;
    }
    /**
     * Set IncludeEventInSeriesAvailability value
     * @param bool $includeEventInSeriesAvailability
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeEventInSeriesAvailability($includeEventInSeriesAvailability = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventInSeriesAvailability) && !is_bool($includeEventInSeriesAvailability)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventInSeriesAvailability, true), gettype($includeEventInSeriesAvailability)), __LINE__);
        }
        $this->IncludeEventInSeriesAvailability = $includeEventInSeriesAvailability;
        return $this;
    }
    /**
     * Get IncludeEventTags value
     * @return bool|null
     */
    public function getIncludeEventTags()
    {
        return $this->IncludeEventTags;
    }
    /**
     * Set IncludeEventTags value
     * @param bool $includeEventTags
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeEventTags($includeEventTags = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeEventTags) && !is_bool($includeEventTags)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeEventTags, true), gettype($includeEventTags)), __LINE__);
        }
        $this->IncludeEventTags = $includeEventTags;
        return $this;
    }
    /**
     * Get IncludeHospitalityDetails value
     * @return bool|null
     */
    public function getIncludeHospitalityDetails()
    {
        return $this->IncludeHospitalityDetails;
    }
    /**
     * Set IncludeHospitalityDetails value
     * @param bool $includeHospitalityDetails
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeHospitalityDetails($includeHospitalityDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeHospitalityDetails) && !is_bool($includeHospitalityDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeHospitalityDetails, true), gettype($includeHospitalityDetails)), __LINE__);
        }
        $this->IncludeHospitalityDetails = $includeHospitalityDetails;
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get CouponSpecificationIsOptional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCouponSpecificationIsOptional()
    {
        return isset($this->CouponSpecificationIsOptional) ? $this->CouponSpecificationIsOptional : null;
    }
    /**
     * Set CouponSpecificationIsOptional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $couponSpecificationIsOptional
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setCouponSpecificationIsOptional($couponSpecificationIsOptional = null)
    {
        // validation for constraint: boolean
        if (!is_null($couponSpecificationIsOptional) && !is_bool($couponSpecificationIsOptional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($couponSpecificationIsOptional, true), gettype($couponSpecificationIsOptional)), __LINE__);
        }
        if (is_null($couponSpecificationIsOptional) || (is_array($couponSpecificationIsOptional) && empty($couponSpecificationIsOptional))) {
            unset($this->CouponSpecificationIsOptional);
        } else {
            $this->CouponSpecificationIsOptional = $couponSpecificationIsOptional;
        }
        return $this;
    }
    /**
     * Get ExtraOfPromptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraOfPromptId()
    {
        return isset($this->ExtraOfPromptId) ? $this->ExtraOfPromptId : null;
    }
    /**
     * Set ExtraOfPromptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraOfPromptId
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setExtraOfPromptId($extraOfPromptId = null)
    {
        // validation for constraint: string
        if (!is_null($extraOfPromptId) && !is_string($extraOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraOfPromptId, true), gettype($extraOfPromptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extraOfPromptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extraOfPromptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extraOfPromptId, true)), __LINE__);
        }
        if (is_null($extraOfPromptId) || (is_array($extraOfPromptId) && empty($extraOfPromptId))) {
            unset($this->ExtraOfPromptId);
        } else {
            $this->ExtraOfPromptId = $extraOfPromptId;
        }
        return $this;
    }
    /**
     * Get IncludePricingPriceLevels value
     * @return bool|null
     */
    public function getIncludePricingPriceLevels()
    {
        return $this->IncludePricingPriceLevels;
    }
    /**
     * Set IncludePricingPriceLevels value
     * @param bool $includePricingPriceLevels
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludePricingPriceLevels($includePricingPriceLevels = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePricingPriceLevels) && !is_bool($includePricingPriceLevels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePricingPriceLevels, true), gettype($includePricingPriceLevels)), __LINE__);
        }
        $this->IncludePricingPriceLevels = $includePricingPriceLevels;
        return $this;
    }
    /**
     * Get IncludeOnlineTicketsLimit value
     * @return bool|null
     */
    public function getIncludeOnlineTicketsLimit()
    {
        return $this->IncludeOnlineTicketsLimit;
    }
    /**
     * Set IncludeOnlineTicketsLimit value
     * @param bool $includeOnlineTicketsLimit
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeOnlineTicketsLimit($includeOnlineTicketsLimit = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeOnlineTicketsLimit) && !is_bool($includeOnlineTicketsLimit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeOnlineTicketsLimit, true), gettype($includeOnlineTicketsLimit)), __LINE__);
        }
        $this->IncludeOnlineTicketsLimit = $includeOnlineTicketsLimit;
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get IncludePriceModifiersForSubsTickets value
     * @return bool|null
     */
    public function getIncludePriceModifiersForSubsTickets()
    {
        return $this->IncludePriceModifiersForSubsTickets;
    }
    /**
     * Set IncludePriceModifiersForSubsTickets value
     * @param bool $includePriceModifiersForSubsTickets
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludePriceModifiersForSubsTickets($includePriceModifiersForSubsTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($includePriceModifiersForSubsTickets) && !is_bool($includePriceModifiersForSubsTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includePriceModifiersForSubsTickets, true), gettype($includePriceModifiersForSubsTickets)), __LINE__);
        }
        $this->IncludePriceModifiersForSubsTickets = $includePriceModifiersForSubsTickets;
        return $this;
    }
    /**
     * Get IncludeBasketLevelPriceModifiers value
     * @return bool|null
     */
    public function getIncludeBasketLevelPriceModifiers()
    {
        return $this->IncludeBasketLevelPriceModifiers;
    }
    /**
     * Set IncludeBasketLevelPriceModifiers value
     * @param bool $includeBasketLevelPriceModifiers
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBasketLevelPriceModifiers) && !is_bool($includeBasketLevelPriceModifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBasketLevelPriceModifiers, true), gettype($includeBasketLevelPriceModifiers)), __LINE__);
        }
        $this->IncludeBasketLevelPriceModifiers = $includeBasketLevelPriceModifiers;
        return $this;
    }
    /**
     * Get IncludeTicketLimitationRules value
     * @return bool|null
     */
    public function getIncludeTicketLimitationRules()
    {
        return $this->IncludeTicketLimitationRules;
    }
    /**
     * Set IncludeTicketLimitationRules value
     * @param bool $includeTicketLimitationRules
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setIncludeTicketLimitationRules($includeTicketLimitationRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeTicketLimitationRules) && !is_bool($includeTicketLimitationRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeTicketLimitationRules, true), gettype($includeTicketLimitationRules)), __LINE__);
        }
        $this->IncludeTicketLimitationRules = $includeTicketLimitationRules;
        return $this;
    }
    /**
     * Get OverridePriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOverridePriceTypeIds()
    {
        return isset($this->OverridePriceTypeIds) ? $this->OverridePriceTypeIds : null;
    }
    /**
     * Set OverridePriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     * @return \patest\StructType\GetEventDescription_Request
     */
    public function setOverridePriceTypeIds(\patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        if (is_null($overridePriceTypeIds) || (is_array($overridePriceTypeIds) && empty($overridePriceTypeIds))) {
            unset($this->OverridePriceTypeIds);
        } else {
            $this->OverridePriceTypeIds = $overridePriceTypeIds;
        }
        return $this;
    }
}
