<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetEtlRunDetailsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetEtlRunDetailsResponse
 * @subpackage Structs
 */
class GetEtlRunDetailsResponse extends AbstractStructBase
{
    /**
     * The CompletionCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompletionCode;
    /**
     * The ErrorText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorText;
    /**
     * The ExtractDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExtractDurationMs;
    /**
     * The ExtractedRowCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ExtractedRowCount;
    /**
     * The LoadDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LoadDurationMs;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LocalId;
    /**
     * The RunEndDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RunEndDateTimeUtc;
    /**
     * The RunKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunKind;
    /**
     * The RunStartDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RunStartDateTimeUtc;
    /**
     * The TimingDetailsXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TimingDetailsXml
     */
    public $TimingDetailsXml;
    /**
     * The TotalDurationMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TotalDurationMs;
    /**
     * Constructor method for GetEtlRunDetailsResponse
     * @uses GetEtlRunDetailsResponse::setCompletionCode()
     * @uses GetEtlRunDetailsResponse::setErrorText()
     * @uses GetEtlRunDetailsResponse::setExtractDurationMs()
     * @uses GetEtlRunDetailsResponse::setExtractedRowCount()
     * @uses GetEtlRunDetailsResponse::setLoadDurationMs()
     * @uses GetEtlRunDetailsResponse::setLocalId()
     * @uses GetEtlRunDetailsResponse::setRunEndDateTimeUtc()
     * @uses GetEtlRunDetailsResponse::setRunKind()
     * @uses GetEtlRunDetailsResponse::setRunStartDateTimeUtc()
     * @uses GetEtlRunDetailsResponse::setTimingDetailsXml()
     * @uses GetEtlRunDetailsResponse::setTotalDurationMs()
     * @param string $completionCode
     * @param string $errorText
     * @param int $extractDurationMs
     * @param int $extractedRowCount
     * @param int $loadDurationMs
     * @param int $localId
     * @param string $runEndDateTimeUtc
     * @param string $runKind
     * @param string $runStartDateTimeUtc
     * @param \patest\StructType\TimingDetailsXml $timingDetailsXml
     * @param int $totalDurationMs
     */
    public function __construct($completionCode = null, $errorText = null, $extractDurationMs = null, $extractedRowCount = null, $loadDurationMs = null, $localId = null, $runEndDateTimeUtc = null, $runKind = null, $runStartDateTimeUtc = null, \patest\StructType\TimingDetailsXml $timingDetailsXml = null, $totalDurationMs = null)
    {
        $this
            ->setCompletionCode($completionCode)
            ->setErrorText($errorText)
            ->setExtractDurationMs($extractDurationMs)
            ->setExtractedRowCount($extractedRowCount)
            ->setLoadDurationMs($loadDurationMs)
            ->setLocalId($localId)
            ->setRunEndDateTimeUtc($runEndDateTimeUtc)
            ->setRunKind($runKind)
            ->setRunStartDateTimeUtc($runStartDateTimeUtc)
            ->setTimingDetailsXml($timingDetailsXml)
            ->setTotalDurationMs($totalDurationMs);
    }
    /**
     * Get CompletionCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompletionCode()
    {
        return isset($this->CompletionCode) ? $this->CompletionCode : null;
    }
    /**
     * Set CompletionCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $completionCode
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setCompletionCode($completionCode = null)
    {
        // validation for constraint: string
        if (!is_null($completionCode) && !is_string($completionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($completionCode, true), gettype($completionCode)), __LINE__);
        }
        if (is_null($completionCode) || (is_array($completionCode) && empty($completionCode))) {
            unset($this->CompletionCode);
        } else {
            $this->CompletionCode = $completionCode;
        }
        return $this;
    }
    /**
     * Get ErrorText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorText()
    {
        return isset($this->ErrorText) ? $this->ErrorText : null;
    }
    /**
     * Set ErrorText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorText
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setErrorText($errorText = null)
    {
        // validation for constraint: string
        if (!is_null($errorText) && !is_string($errorText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorText, true), gettype($errorText)), __LINE__);
        }
        if (is_null($errorText) || (is_array($errorText) && empty($errorText))) {
            unset($this->ErrorText);
        } else {
            $this->ErrorText = $errorText;
        }
        return $this;
    }
    /**
     * Get ExtractDurationMs value
     * @return int|null
     */
    public function getExtractDurationMs()
    {
        return $this->ExtractDurationMs;
    }
    /**
     * Set ExtractDurationMs value
     * @param int $extractDurationMs
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setExtractDurationMs($extractDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($extractDurationMs) && !(is_int($extractDurationMs) || ctype_digit($extractDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extractDurationMs, true), gettype($extractDurationMs)), __LINE__);
        }
        $this->ExtractDurationMs = $extractDurationMs;
        return $this;
    }
    /**
     * Get ExtractedRowCount value
     * @return int|null
     */
    public function getExtractedRowCount()
    {
        return $this->ExtractedRowCount;
    }
    /**
     * Set ExtractedRowCount value
     * @param int $extractedRowCount
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setExtractedRowCount($extractedRowCount = null)
    {
        // validation for constraint: int
        if (!is_null($extractedRowCount) && !(is_int($extractedRowCount) || ctype_digit($extractedRowCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($extractedRowCount, true), gettype($extractedRowCount)), __LINE__);
        }
        $this->ExtractedRowCount = $extractedRowCount;
        return $this;
    }
    /**
     * Get LoadDurationMs value
     * @return int|null
     */
    public function getLoadDurationMs()
    {
        return $this->LoadDurationMs;
    }
    /**
     * Set LoadDurationMs value
     * @param int $loadDurationMs
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setLoadDurationMs($loadDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($loadDurationMs) && !(is_int($loadDurationMs) || ctype_digit($loadDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loadDurationMs, true), gettype($loadDurationMs)), __LINE__);
        }
        $this->LoadDurationMs = $loadDurationMs;
        return $this;
    }
    /**
     * Get LocalId value
     * @return int|null
     */
    public function getLocalId()
    {
        return $this->LocalId;
    }
    /**
     * Set LocalId value
     * @param int $localId
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        $this->LocalId = $localId;
        return $this;
    }
    /**
     * Get RunEndDateTimeUtc value
     * @return string|null
     */
    public function getRunEndDateTimeUtc()
    {
        return $this->RunEndDateTimeUtc;
    }
    /**
     * Set RunEndDateTimeUtc value
     * @param string $runEndDateTimeUtc
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setRunEndDateTimeUtc($runEndDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($runEndDateTimeUtc) && !is_string($runEndDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runEndDateTimeUtc, true), gettype($runEndDateTimeUtc)), __LINE__);
        }
        $this->RunEndDateTimeUtc = $runEndDateTimeUtc;
        return $this;
    }
    /**
     * Get RunKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunKind()
    {
        return isset($this->RunKind) ? $this->RunKind : null;
    }
    /**
     * Set RunKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runKind
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setRunKind($runKind = null)
    {
        // validation for constraint: string
        if (!is_null($runKind) && !is_string($runKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runKind, true), gettype($runKind)), __LINE__);
        }
        if (is_null($runKind) || (is_array($runKind) && empty($runKind))) {
            unset($this->RunKind);
        } else {
            $this->RunKind = $runKind;
        }
        return $this;
    }
    /**
     * Get RunStartDateTimeUtc value
     * @return string|null
     */
    public function getRunStartDateTimeUtc()
    {
        return $this->RunStartDateTimeUtc;
    }
    /**
     * Set RunStartDateTimeUtc value
     * @param string $runStartDateTimeUtc
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setRunStartDateTimeUtc($runStartDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($runStartDateTimeUtc) && !is_string($runStartDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runStartDateTimeUtc, true), gettype($runStartDateTimeUtc)), __LINE__);
        }
        $this->RunStartDateTimeUtc = $runStartDateTimeUtc;
        return $this;
    }
    /**
     * Get TimingDetailsXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TimingDetailsXml|null
     */
    public function getTimingDetailsXml()
    {
        return isset($this->TimingDetailsXml) ? $this->TimingDetailsXml : null;
    }
    /**
     * Set TimingDetailsXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TimingDetailsXml $timingDetailsXml
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setTimingDetailsXml(\patest\StructType\TimingDetailsXml $timingDetailsXml = null)
    {
        if (is_null($timingDetailsXml) || (is_array($timingDetailsXml) && empty($timingDetailsXml))) {
            unset($this->TimingDetailsXml);
        } else {
            $this->TimingDetailsXml = $timingDetailsXml;
        }
        return $this;
    }
    /**
     * Get TotalDurationMs value
     * @return int|null
     */
    public function getTotalDurationMs()
    {
        return $this->TotalDurationMs;
    }
    /**
     * Set TotalDurationMs value
     * @param int $totalDurationMs
     * @return \patest\StructType\GetEtlRunDetailsResponse
     */
    public function setTotalDurationMs($totalDurationMs = null)
    {
        // validation for constraint: int
        if (!is_null($totalDurationMs) && !(is_int($totalDurationMs) || ctype_digit($totalDurationMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalDurationMs, true), gettype($totalDurationMs)), __LINE__);
        }
        $this->TotalDurationMs = $totalDurationMs;
        return $this;
    }
}
