<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDirectDebitRecordsToSend-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetDirectDebitRecordsToSend-Response
 * @subpackage Structs
 */
class GetDirectDebitRecordsToSend_Response extends AbstractStructBase
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchId;
    /**
     * The CollectRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDirectDebitRecord
     */
    public $CollectRecords;
    /**
     * The ReturnRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfDirectDebitRecord
     */
    public $ReturnRecords;
    /**
     * Constructor method for GetDirectDebitRecordsToSend-Response
     * @uses GetDirectDebitRecordsToSend_Response::setBatchId()
     * @uses GetDirectDebitRecordsToSend_Response::setCollectRecords()
     * @uses GetDirectDebitRecordsToSend_Response::setReturnRecords()
     * @param string $batchId
     * @param \patest\ArrayType\ArrayOfDirectDebitRecord $collectRecords
     * @param \patest\ArrayType\ArrayOfDirectDebitRecord $returnRecords
     */
    public function __construct($batchId = null, \patest\ArrayType\ArrayOfDirectDebitRecord $collectRecords = null, \patest\ArrayType\ArrayOfDirectDebitRecord $returnRecords = null)
    {
        $this
            ->setBatchId($batchId)
            ->setCollectRecords($collectRecords)
            ->setReturnRecords($returnRecords);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\GetDirectDebitRecordsToSend_Response
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get CollectRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDirectDebitRecord|null
     */
    public function getCollectRecords()
    {
        return isset($this->CollectRecords) ? $this->CollectRecords : null;
    }
    /**
     * Set CollectRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDirectDebitRecord $collectRecords
     * @return \patest\StructType\GetDirectDebitRecordsToSend_Response
     */
    public function setCollectRecords(\patest\ArrayType\ArrayOfDirectDebitRecord $collectRecords = null)
    {
        if (is_null($collectRecords) || (is_array($collectRecords) && empty($collectRecords))) {
            unset($this->CollectRecords);
        } else {
            $this->CollectRecords = $collectRecords;
        }
        return $this;
    }
    /**
     * Get ReturnRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfDirectDebitRecord|null
     */
    public function getReturnRecords()
    {
        return isset($this->ReturnRecords) ? $this->ReturnRecords : null;
    }
    /**
     * Set ReturnRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfDirectDebitRecord $returnRecords
     * @return \patest\StructType\GetDirectDebitRecordsToSend_Response
     */
    public function setReturnRecords(\patest\ArrayType\ArrayOfDirectDebitRecord $returnRecords = null)
    {
        if (is_null($returnRecords) || (is_array($returnRecords) && empty($returnRecords))) {
            unset($this->ReturnRecords);
        } else {
            $this->ReturnRecords = $returnRecords;
        }
        return $this;
    }
}
