<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientWaveTimeRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientWaveTimeRequest
 * @subpackage Structs
 */
class GetClientWaveTimeRequest extends ExtensibleDataContract
{
    /**
     * The ClientGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientGuid;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for GetClientWaveTimeRequest
     * @uses GetClientWaveTimeRequest::setClientGuid()
     * @uses GetClientWaveTimeRequest::setSeriesId()
     * @param string $clientGuid
     * @param string $seriesId
     */
    public function __construct($clientGuid = null, $seriesId = null)
    {
        $this
            ->setClientGuid($clientGuid)
            ->setSeriesId($seriesId);
    }
    /**
     * Get ClientGuid value
     * @return string|null
     */
    public function getClientGuid()
    {
        return $this->ClientGuid;
    }
    /**
     * Set ClientGuid value
     * @param string $clientGuid
     * @return \patest\StructType\GetClientWaveTimeRequest
     */
    public function setClientGuid($clientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($clientGuid) && !is_string($clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientGuid, true), gettype($clientGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientGuid, true)), __LINE__);
        }
        $this->ClientGuid = $clientGuid;
        return $this;
    }
    /**
     * Get SeriesId value
     * @return string|null
     */
    public function getSeriesId()
    {
        return $this->SeriesId;
    }
    /**
     * Set SeriesId value
     * @param string $seriesId
     * @return \patest\StructType\GetClientWaveTimeRequest
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        $this->SeriesId = $seriesId;
        return $this;
    }
}
