<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetClientEventsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetClientEventsResponse
 * @subpackage Structs
 */
class GetClientEventsResponse extends AbstractStructBase
{
    /**
     * The Events
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfClientEventInfo
     */
    public $Events;
    /**
     * The IsThereMoreData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThereMoreData;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK
     */
    public $Tickets;
    /**
     * Constructor method for GetClientEventsResponse
     * @uses GetClientEventsResponse::setEvents()
     * @uses GetClientEventsResponse::setIsThereMoreData()
     * @uses GetClientEventsResponse::setTickets()
     * @param \patest\ArrayType\ArrayOfClientEventInfo $events
     * @param bool $isThereMoreData
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK $tickets
     */
    public function __construct(\patest\ArrayType\ArrayOfClientEventInfo $events = null, $isThereMoreData = null, \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK $tickets = null)
    {
        $this
            ->setEvents($events)
            ->setIsThereMoreData($isThereMoreData)
            ->setTickets($tickets);
    }
    /**
     * Get Events value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfClientEventInfo|null
     */
    public function getEvents()
    {
        return isset($this->Events) ? $this->Events : null;
    }
    /**
     * Set Events value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfClientEventInfo $events
     * @return \patest\StructType\GetClientEventsResponse
     */
    public function setEvents(\patest\ArrayType\ArrayOfClientEventInfo $events = null)
    {
        if (is_null($events) || (is_array($events) && empty($events))) {
            unset($this->Events);
        } else {
            $this->Events = $events;
        }
        return $this;
    }
    /**
     * Get IsThereMoreData value
     * @return bool|null
     */
    public function getIsThereMoreData()
    {
        return $this->IsThereMoreData;
    }
    /**
     * Set IsThereMoreData value
     * @param bool $isThereMoreData
     * @return \patest\StructType\GetClientEventsResponse
     */
    public function setIsThereMoreData($isThereMoreData = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThereMoreData) && !is_bool($isThereMoreData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThereMoreData, true), gettype($isThereMoreData)), __LINE__);
        }
        $this->IsThereMoreData = $isThereMoreData;
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK $tickets
     * @return \patest\StructType\GetClientEventsResponse
     */
    public function setTickets(\patest\ArrayType\ArrayOfKeyValueOfguidArrayOfClientTicketTwLakkHK $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
