<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBundleDescriptionResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBundleDescriptionResponse
 * @subpackage Structs
 */
class GetBundleDescriptionResponse extends ExtensibleDataContract
{
    /**
     * The BundleDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BundleDescription
     */
    public $BundleDescription;
    /**
     * The ElementDescriptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBundleElementDescription
     */
    public $ElementDescriptions;
    /**
     * Constructor method for GetBundleDescriptionResponse
     * @uses GetBundleDescriptionResponse::setBundleDescription()
     * @uses GetBundleDescriptionResponse::setElementDescriptions()
     * @param \patest\StructType\BundleDescription $bundleDescription
     * @param \patest\ArrayType\ArrayOfBundleElementDescription $elementDescriptions
     */
    public function __construct(\patest\StructType\BundleDescription $bundleDescription = null, \patest\ArrayType\ArrayOfBundleElementDescription $elementDescriptions = null)
    {
        $this
            ->setBundleDescription($bundleDescription)
            ->setElementDescriptions($elementDescriptions);
    }
    /**
     * Get BundleDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BundleDescription|null
     */
    public function getBundleDescription()
    {
        return isset($this->BundleDescription) ? $this->BundleDescription : null;
    }
    /**
     * Set BundleDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BundleDescription $bundleDescription
     * @return \patest\StructType\GetBundleDescriptionResponse
     */
    public function setBundleDescription(\patest\StructType\BundleDescription $bundleDescription = null)
    {
        if (is_null($bundleDescription) || (is_array($bundleDescription) && empty($bundleDescription))) {
            unset($this->BundleDescription);
        } else {
            $this->BundleDescription = $bundleDescription;
        }
        return $this;
    }
    /**
     * Get ElementDescriptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBundleElementDescription|null
     */
    public function getElementDescriptions()
    {
        return isset($this->ElementDescriptions) ? $this->ElementDescriptions : null;
    }
    /**
     * Set ElementDescriptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBundleElementDescription $elementDescriptions
     * @return \patest\StructType\GetBundleDescriptionResponse
     */
    public function setElementDescriptions(\patest\ArrayType\ArrayOfBundleElementDescription $elementDescriptions = null)
    {
        if (is_null($elementDescriptions) || (is_array($elementDescriptions) && empty($elementDescriptions))) {
            unset($this->ElementDescriptions);
        } else {
            $this->ElementDescriptions = $elementDescriptions;
        }
        return $this;
    }
}
