<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetBallotPricingEventValues StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetBallotPricingEventValues
 * @subpackage Structs
 */
class GetBallotPricingEventValues extends AbstractStructBase
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Maximum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Maximum;
    /**
     * The Minimum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Minimum;
    /**
     * The SectionValues
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfGetBallotPricingSectionValues
     */
    public $SectionValues;
    /**
     * Constructor method for GetBallotPricingEventValues
     * @uses GetBallotPricingEventValues::setEventId()
     * @uses GetBallotPricingEventValues::setMaximum()
     * @uses GetBallotPricingEventValues::setMinimum()
     * @uses GetBallotPricingEventValues::setSectionValues()
     * @param string $eventId
     * @param float $maximum
     * @param float $minimum
     * @param \patest\ArrayType\ArrayOfGetBallotPricingSectionValues $sectionValues
     */
    public function __construct($eventId = null, $maximum = null, $minimum = null, \patest\ArrayType\ArrayOfGetBallotPricingSectionValues $sectionValues = null)
    {
        $this
            ->setEventId($eventId)
            ->setMaximum($maximum)
            ->setMinimum($minimum)
            ->setSectionValues($sectionValues);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\GetBallotPricingEventValues
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Maximum value
     * @return float|null
     */
    public function getMaximum()
    {
        return $this->Maximum;
    }
    /**
     * Set Maximum value
     * @param float $maximum
     * @return \patest\StructType\GetBallotPricingEventValues
     */
    public function setMaximum($maximum = null)
    {
        // validation for constraint: float
        if (!is_null($maximum) && !(is_float($maximum) || is_numeric($maximum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($maximum, true), gettype($maximum)), __LINE__);
        }
        $this->Maximum = $maximum;
        return $this;
    }
    /**
     * Get Minimum value
     * @return float|null
     */
    public function getMinimum()
    {
        return $this->Minimum;
    }
    /**
     * Set Minimum value
     * @param float $minimum
     * @return \patest\StructType\GetBallotPricingEventValues
     */
    public function setMinimum($minimum = null)
    {
        // validation for constraint: float
        if (!is_null($minimum) && !(is_float($minimum) || is_numeric($minimum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($minimum, true), gettype($minimum)), __LINE__);
        }
        $this->Minimum = $minimum;
        return $this;
    }
    /**
     * Get SectionValues value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfGetBallotPricingSectionValues|null
     */
    public function getSectionValues()
    {
        return isset($this->SectionValues) ? $this->SectionValues : null;
    }
    /**
     * Set SectionValues value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfGetBallotPricingSectionValues $sectionValues
     * @return \patest\StructType\GetBallotPricingEventValues
     */
    public function setSectionValues(\patest\ArrayType\ArrayOfGetBallotPricingSectionValues $sectionValues = null)
    {
        if (is_null($sectionValues) || (is_array($sectionValues) && empty($sectionValues))) {
            unset($this->SectionValues);
        } else {
            $this->SectionValues = $sectionValues;
        }
        return $this;
    }
}
