<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableShows-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableShows-Request
 * @subpackage Structs
 */
class GetAvailableShows_Request extends ExtensibleDataContract
{
    /**
     * The BestsellerOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BestsellerOnly;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GenreId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GenreId;
    /**
     * The MaxResultCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxResultCount;
    /**
     * The RecommendedOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RecommendedOnly;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * The AssociatedDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateFrom;
    /**
     * The AssociatedDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociatedDateTo;
    /**
     * The IncludeDisplayableFutureSales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeDisplayableFutureSales;
    /**
     * The IncludeClosedForSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeClosedForSale;
    /**
     * The OnlyHospitalityShows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $OnlyHospitalityShows;
    /**
     * The CouponIdentity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\CouponIdentity
     */
    public $CouponIdentity;
    /**
     * The IsSupportingMarketDrivenResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSupportingMarketDrivenResalePolicy;
    /**
     * The IsTour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTour;
    /**
     * Constructor method for GetAvailableShows-Request
     * @uses GetAvailableShows_Request::setBestsellerOnly()
     * @uses GetAvailableShows_Request::setFromDate()
     * @uses GetAvailableShows_Request::setGenreId()
     * @uses GetAvailableShows_Request::setMaxResultCount()
     * @uses GetAvailableShows_Request::setRecommendedOnly()
     * @uses GetAvailableShows_Request::setToDate()
     * @uses GetAvailableShows_Request::setAssociatedDateFrom()
     * @uses GetAvailableShows_Request::setAssociatedDateTo()
     * @uses GetAvailableShows_Request::setIncludeDisplayableFutureSales()
     * @uses GetAvailableShows_Request::setIncludeClosedForSale()
     * @uses GetAvailableShows_Request::setOnlyHospitalityShows()
     * @uses GetAvailableShows_Request::setCouponIdentity()
     * @uses GetAvailableShows_Request::setIsSupportingMarketDrivenResalePolicy()
     * @uses GetAvailableShows_Request::setIsTour()
     * @param bool $bestsellerOnly
     * @param string $fromDate
     * @param string $genreId
     * @param int $maxResultCount
     * @param string $recommendedOnly
     * @param string $toDate
     * @param string $associatedDateFrom
     * @param string $associatedDateTo
     * @param bool $includeDisplayableFutureSales
     * @param bool $includeClosedForSale
     * @param bool $onlyHospitalityShows
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @param bool $isTour
     */
    public function __construct($bestsellerOnly = null, $fromDate = null, $genreId = null, $maxResultCount = null, $recommendedOnly = null, $toDate = null, $associatedDateFrom = null, $associatedDateTo = null, $includeDisplayableFutureSales = null, $includeClosedForSale = null, $onlyHospitalityShows = null, \patest\StructType\CouponIdentity $couponIdentity = null, $isSupportingMarketDrivenResalePolicy = null, $isTour = null)
    {
        $this
            ->setBestsellerOnly($bestsellerOnly)
            ->setFromDate($fromDate)
            ->setGenreId($genreId)
            ->setMaxResultCount($maxResultCount)
            ->setRecommendedOnly($recommendedOnly)
            ->setToDate($toDate)
            ->setAssociatedDateFrom($associatedDateFrom)
            ->setAssociatedDateTo($associatedDateTo)
            ->setIncludeDisplayableFutureSales($includeDisplayableFutureSales)
            ->setIncludeClosedForSale($includeClosedForSale)
            ->setOnlyHospitalityShows($onlyHospitalityShows)
            ->setCouponIdentity($couponIdentity)
            ->setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy)
            ->setIsTour($isTour);
    }
    /**
     * Get BestsellerOnly value
     * @return bool|null
     */
    public function getBestsellerOnly()
    {
        return $this->BestsellerOnly;
    }
    /**
     * Set BestsellerOnly value
     * @param bool $bestsellerOnly
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setBestsellerOnly($bestsellerOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestsellerOnly) && !is_bool($bestsellerOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestsellerOnly, true), gettype($bestsellerOnly)), __LINE__);
        }
        $this->BestsellerOnly = $bestsellerOnly;
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GenreId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenreId()
    {
        return isset($this->GenreId) ? $this->GenreId : null;
    }
    /**
     * Set GenreId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $genreId
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setGenreId($genreId = null)
    {
        // validation for constraint: string
        if (!is_null($genreId) && !is_string($genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genreId, true), gettype($genreId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($genreId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $genreId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($genreId, true)), __LINE__);
        }
        if (is_null($genreId) || (is_array($genreId) && empty($genreId))) {
            unset($this->GenreId);
        } else {
            $this->GenreId = $genreId;
        }
        return $this;
    }
    /**
     * Get MaxResultCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxResultCount()
    {
        return isset($this->MaxResultCount) ? $this->MaxResultCount : null;
    }
    /**
     * Set MaxResultCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxResultCount
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setMaxResultCount($maxResultCount = null)
    {
        // validation for constraint: int
        if (!is_null($maxResultCount) && !(is_int($maxResultCount) || ctype_digit($maxResultCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxResultCount, true), gettype($maxResultCount)), __LINE__);
        }
        if (is_null($maxResultCount) || (is_array($maxResultCount) && empty($maxResultCount))) {
            unset($this->MaxResultCount);
        } else {
            $this->MaxResultCount = $maxResultCount;
        }
        return $this;
    }
    /**
     * Get RecommendedOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecommendedOnly()
    {
        return isset($this->RecommendedOnly) ? $this->RecommendedOnly : null;
    }
    /**
     * Set RecommendedOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ShowRecommendationScope::valueIsValid()
     * @uses \patest\EnumType\ShowRecommendationScope::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recommendedOnly
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setRecommendedOnly($recommendedOnly = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ShowRecommendationScope::valueIsValid($recommendedOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ShowRecommendationScope', is_array($recommendedOnly) ? implode(', ', $recommendedOnly) : var_export($recommendedOnly, true), implode(', ', \patest\EnumType\ShowRecommendationScope::getValidValues())), __LINE__);
        }
        if (is_null($recommendedOnly) || (is_array($recommendedOnly) && empty($recommendedOnly))) {
            unset($this->RecommendedOnly);
        } else {
            $this->RecommendedOnly = $recommendedOnly;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
    /**
     * Get AssociatedDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateFrom()
    {
        return isset($this->AssociatedDateFrom) ? $this->AssociatedDateFrom : null;
    }
    /**
     * Set AssociatedDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateFrom
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setAssociatedDateFrom($associatedDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateFrom) && !is_string($associatedDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateFrom, true), gettype($associatedDateFrom)), __LINE__);
        }
        if (is_null($associatedDateFrom) || (is_array($associatedDateFrom) && empty($associatedDateFrom))) {
            unset($this->AssociatedDateFrom);
        } else {
            $this->AssociatedDateFrom = $associatedDateFrom;
        }
        return $this;
    }
    /**
     * Get AssociatedDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedDateTo()
    {
        return isset($this->AssociatedDateTo) ? $this->AssociatedDateTo : null;
    }
    /**
     * Set AssociatedDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedDateTo
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setAssociatedDateTo($associatedDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($associatedDateTo) && !is_string($associatedDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedDateTo, true), gettype($associatedDateTo)), __LINE__);
        }
        if (is_null($associatedDateTo) || (is_array($associatedDateTo) && empty($associatedDateTo))) {
            unset($this->AssociatedDateTo);
        } else {
            $this->AssociatedDateTo = $associatedDateTo;
        }
        return $this;
    }
    /**
     * Get IncludeDisplayableFutureSales value
     * @return bool|null
     */
    public function getIncludeDisplayableFutureSales()
    {
        return $this->IncludeDisplayableFutureSales;
    }
    /**
     * Set IncludeDisplayableFutureSales value
     * @param bool $includeDisplayableFutureSales
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setIncludeDisplayableFutureSales($includeDisplayableFutureSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeDisplayableFutureSales) && !is_bool($includeDisplayableFutureSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeDisplayableFutureSales, true), gettype($includeDisplayableFutureSales)), __LINE__);
        }
        $this->IncludeDisplayableFutureSales = $includeDisplayableFutureSales;
        return $this;
    }
    /**
     * Get IncludeClosedForSale value
     * @return bool|null
     */
    public function getIncludeClosedForSale()
    {
        return $this->IncludeClosedForSale;
    }
    /**
     * Set IncludeClosedForSale value
     * @param bool $includeClosedForSale
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setIncludeClosedForSale($includeClosedForSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeClosedForSale) && !is_bool($includeClosedForSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeClosedForSale, true), gettype($includeClosedForSale)), __LINE__);
        }
        $this->IncludeClosedForSale = $includeClosedForSale;
        return $this;
    }
    /**
     * Get OnlyHospitalityShows value
     * @return bool|null
     */
    public function getOnlyHospitalityShows()
    {
        return $this->OnlyHospitalityShows;
    }
    /**
     * Set OnlyHospitalityShows value
     * @param bool $onlyHospitalityShows
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setOnlyHospitalityShows($onlyHospitalityShows = null)
    {
        // validation for constraint: boolean
        if (!is_null($onlyHospitalityShows) && !is_bool($onlyHospitalityShows)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($onlyHospitalityShows, true), gettype($onlyHospitalityShows)), __LINE__);
        }
        $this->OnlyHospitalityShows = $onlyHospitalityShows;
        return $this;
    }
    /**
     * Get CouponIdentity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\CouponIdentity|null
     */
    public function getCouponIdentity()
    {
        return isset($this->CouponIdentity) ? $this->CouponIdentity : null;
    }
    /**
     * Set CouponIdentity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\CouponIdentity $couponIdentity
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setCouponIdentity(\patest\StructType\CouponIdentity $couponIdentity = null)
    {
        if (is_null($couponIdentity) || (is_array($couponIdentity) && empty($couponIdentity))) {
            unset($this->CouponIdentity);
        } else {
            $this->CouponIdentity = $couponIdentity;
        }
        return $this;
    }
    /**
     * Get IsSupportingMarketDrivenResalePolicy value
     * @return bool|null
     */
    public function getIsSupportingMarketDrivenResalePolicy()
    {
        return $this->IsSupportingMarketDrivenResalePolicy;
    }
    /**
     * Set IsSupportingMarketDrivenResalePolicy value
     * @param bool $isSupportingMarketDrivenResalePolicy
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setIsSupportingMarketDrivenResalePolicy($isSupportingMarketDrivenResalePolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSupportingMarketDrivenResalePolicy) && !is_bool($isSupportingMarketDrivenResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSupportingMarketDrivenResalePolicy, true), gettype($isSupportingMarketDrivenResalePolicy)), __LINE__);
        }
        $this->IsSupportingMarketDrivenResalePolicy = $isSupportingMarketDrivenResalePolicy;
        return $this;
    }
    /**
     * Get IsTour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTour()
    {
        return isset($this->IsTour) ? $this->IsTour : null;
    }
    /**
     * Set IsTour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTour
     * @return \patest\StructType\GetAvailableShows_Request
     */
    public function setIsTour($isTour = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTour) && !is_bool($isTour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTour, true), gettype($isTour)), __LINE__);
        }
        if (is_null($isTour) || (is_array($isTour) && empty($isTour))) {
            unset($this->IsTour);
        } else {
            $this->IsTour = $isTour;
        }
        return $this;
    }
}
