<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAvailableMerchandiseItemTypes-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAvailableMerchandiseItemTypes-Request
 * @subpackage Structs
 */
class GetAvailableMerchandiseItemTypes_Request extends ExtensibleDataContract
{
    /**
     * The ExcludeServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ExcludeServices;
    /**
     * The OfCategories
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OfCategories;
    /**
     * Constructor method for GetAvailableMerchandiseItemTypes-Request
     * @uses GetAvailableMerchandiseItemTypes_Request::setExcludeServices()
     * @uses GetAvailableMerchandiseItemTypes_Request::setOfCategories()
     * @param bool $excludeServices
     * @param \patest\ArrayType\ArrayOfguid $ofCategories
     */
    public function __construct($excludeServices = null, \patest\ArrayType\ArrayOfguid $ofCategories = null)
    {
        $this
            ->setExcludeServices($excludeServices)
            ->setOfCategories($ofCategories);
    }
    /**
     * Get ExcludeServices value
     * @return bool|null
     */
    public function getExcludeServices()
    {
        return $this->ExcludeServices;
    }
    /**
     * Set ExcludeServices value
     * @param bool $excludeServices
     * @return \patest\StructType\GetAvailableMerchandiseItemTypes_Request
     */
    public function setExcludeServices($excludeServices = null)
    {
        // validation for constraint: boolean
        if (!is_null($excludeServices) && !is_bool($excludeServices)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($excludeServices, true), gettype($excludeServices)), __LINE__);
        }
        $this->ExcludeServices = $excludeServices;
        return $this;
    }
    /**
     * Get OfCategories value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOfCategories()
    {
        return isset($this->OfCategories) ? $this->OfCategories : null;
    }
    /**
     * Set OfCategories value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ofCategories
     * @return \patest\StructType\GetAvailableMerchandiseItemTypes_Request
     */
    public function setOfCategories(\patest\ArrayType\ArrayOfguid $ofCategories = null)
    {
        if (is_null($ofCategories) || (is_array($ofCategories) && empty($ofCategories))) {
            unset($this->OfCategories);
        } else {
            $this->OfCategories = $ofCategories;
        }
        return $this;
    }
}
