<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetAreasOfHallVersion-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetAreasOfHallVersion-Request
 * @subpackage Structs
 */
class GetAreasOfHallVersion_Request extends ExtensibleDataContract
{
    /**
     * The HallVersionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallVersionId;
    /**
     * The RequestedType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedType;
    /**
     * Constructor method for GetAreasOfHallVersion-Request
     * @uses GetAreasOfHallVersion_Request::setHallVersionId()
     * @uses GetAreasOfHallVersion_Request::setRequestedType()
     * @param string $hallVersionId
     * @param string $requestedType
     */
    public function __construct($hallVersionId = null, $requestedType = null)
    {
        $this
            ->setHallVersionId($hallVersionId)
            ->setRequestedType($requestedType);
    }
    /**
     * Get HallVersionId value
     * @return string|null
     */
    public function getHallVersionId()
    {
        return $this->HallVersionId;
    }
    /**
     * Set HallVersionId value
     * @param string $hallVersionId
     * @return \patest\StructType\GetAreasOfHallVersion_Request
     */
    public function setHallVersionId($hallVersionId = null)
    {
        // validation for constraint: string
        if (!is_null($hallVersionId) && !is_string($hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallVersionId, true), gettype($hallVersionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallVersionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallVersionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallVersionId, true)), __LINE__);
        }
        $this->HallVersionId = $hallVersionId;
        return $this;
    }
    /**
     * Get RequestedType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedType()
    {
        return isset($this->RequestedType) ? $this->RequestedType : null;
    }
    /**
     * Set RequestedType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaSeatingType::valueIsValid()
     * @uses \patest\EnumType\AreaSeatingType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedType
     * @return \patest\StructType\GetAreasOfHallVersion_Request
     */
    public function setRequestedType($requestedType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaSeatingType::valueIsValid($requestedType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaSeatingType', is_array($requestedType) ? implode(', ', $requestedType) : var_export($requestedType, true), implode(', ', \patest\EnumType\AreaSeatingType::getValidValues())), __LINE__);
        }
        if (is_null($requestedType) || (is_array($requestedType) && empty($requestedType))) {
            unset($this->RequestedType);
        } else {
            $this->RequestedType = $requestedType;
        }
        return $this;
    }
}
