<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenreDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GenreDescription
 * @subpackage Structs
 */
class GenreDescription extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OnlineDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDescription;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Ordinal;
    /**
     * Constructor method for GenreDescription
     * @uses GenreDescription::setId()
     * @uses GenreDescription::setName()
     * @uses GenreDescription::setOnlineDescription()
     * @uses GenreDescription::setOrdinal()
     * @param string $id
     * @param string $name
     * @param \patest\StructType\GlobalString $onlineDescription
     * @param int $ordinal
     */
    public function __construct($id = null, $name = null, \patest\StructType\GlobalString $onlineDescription = null, $ordinal = null)
    {
        $this
            ->setId($id)
            ->setName($name)
            ->setOnlineDescription($onlineDescription)
            ->setOrdinal($ordinal);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\GenreDescription
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\GenreDescription
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OnlineDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDescription()
    {
        return isset($this->OnlineDescription) ? $this->OnlineDescription : null;
    }
    /**
     * Set OnlineDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDescription
     * @return \patest\StructType\GenreDescription
     */
    public function setOnlineDescription(\patest\StructType\GlobalString $onlineDescription = null)
    {
        if (is_null($onlineDescription) || (is_array($onlineDescription) && empty($onlineDescription))) {
            unset($this->OnlineDescription);
        } else {
            $this->OnlineDescription = $onlineDescription;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * @return int|null
     */
    public function getOrdinal()
    {
        return $this->Ordinal;
    }
    /**
     * Set Ordinal value
     * @param int $ordinal
     * @return \patest\StructType\GenreDescription
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        $this->Ordinal = $ordinal;
        return $this;
    }
}
