<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeneralAdmissionLayerSettings StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GeneralAdmissionLayerSettings
 * @subpackage Structs
 */
class GeneralAdmissionLayerSettings extends AbstractGeneralAdmissionLayerSettings
{
    /**
     * The GuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidValue;
    /**
     * The IntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntValue;
    /**
     * The LayerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LayerType;
    /**
     * Constructor method for GeneralAdmissionLayerSettings
     * @uses GeneralAdmissionLayerSettings::setGuidValue()
     * @uses GeneralAdmissionLayerSettings::setIntValue()
     * @uses GeneralAdmissionLayerSettings::setLayerType()
     * @param string $guidValue
     * @param int $intValue
     * @param string $layerType
     */
    public function __construct($guidValue = null, $intValue = null, $layerType = null)
    {
        $this
            ->setGuidValue($guidValue)
            ->setIntValue($intValue)
            ->setLayerType($layerType);
    }
    /**
     * Get GuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidValue()
    {
        return isset($this->GuidValue) ? $this->GuidValue : null;
    }
    /**
     * Set GuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidValue
     * @return \patest\StructType\GeneralAdmissionLayerSettings
     */
    public function setGuidValue($guidValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidValue) && !is_string($guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidValue, true), gettype($guidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidValue, true)), __LINE__);
        }
        if (is_null($guidValue) || (is_array($guidValue) && empty($guidValue))) {
            unset($this->GuidValue);
        } else {
            $this->GuidValue = $guidValue;
        }
        return $this;
    }
    /**
     * Get IntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntValue()
    {
        return isset($this->IntValue) ? $this->IntValue : null;
    }
    /**
     * Set IntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intValue
     * @return \patest\StructType\GeneralAdmissionLayerSettings
     */
    public function setIntValue($intValue = null)
    {
        // validation for constraint: int
        if (!is_null($intValue) && !(is_int($intValue) || ctype_digit($intValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intValue, true), gettype($intValue)), __LINE__);
        }
        if (is_null($intValue) || (is_array($intValue) && empty($intValue))) {
            unset($this->IntValue);
        } else {
            $this->IntValue = $intValue;
        }
        return $this;
    }
    /**
     * Get LayerType value
     * @return string|null
     */
    public function getLayerType()
    {
        return $this->LayerType;
    }
    /**
     * Set LayerType value
     * @uses \patest\EnumType\LayerTypes::valueIsValid()
     * @uses \patest\EnumType\LayerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $layerType
     * @return \patest\StructType\GeneralAdmissionLayerSettings
     */
    public function setLayerType($layerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LayerTypes::valueIsValid($layerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LayerTypes', is_array($layerType) ? implode(', ', $layerType) : var_export($layerType, true), implode(', ', \patest\EnumType\LayerTypes::getValidValues())), __LINE__);
        }
        $this->LayerType = $layerType;
        return $this;
    }
}
